/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.verificationcode;

import com.verisign.epp.exception.EPPException;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class TrustAnchorVerificationData {
    private static Logger cat = Logger.getLogger((String)TrustAnchorVerificationData.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static int UNDEFINED = -1;
    private int codeVspId = UNDEFINED;
    private int vspId = UNDEFINED;
    private String profileName;
    private List<String> codeTypes = new ArrayList<String>();
    private String shortName;
    private int certNumber = UNDEFINED;
    private static String FIELD_SEP = ":";
    private static String CODE_TYPE_SEP = "~";
    private static int NUM_TOKENS = 6;

    public TrustAnchorVerificationData() {
    }

    public TrustAnchorVerificationData(String aTrustAnchorAlias) throws EPPException {
        this.decode(aTrustAnchorAlias);
    }

    public boolean hasCodeVspId() {
        return this.codeVspId != UNDEFINED;
    }

    public int getCodeVspId() {
        return this.codeVspId;
    }

    public void setCodeVspId(int aCodeVspId) {
        this.codeVspId = aCodeVspId;
    }

    public boolean hasVspId() {
        return this.vspId != UNDEFINED;
    }

    public int getVspId() {
        return this.vspId;
    }

    public void setVspId(int aVspId) {
        this.vspId = aVspId;
    }

    public boolean hasProfileName() {
        return this.profileName != null;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String aProfileName) {
        this.profileName = aProfileName;
    }

    public boolean hasCodeTypes() {
        return this.codeTypes != null && !this.codeTypes.isEmpty();
    }

    public void addCodeType(String aCodeType) {
        if (this.codeTypes == null) {
            this.codeTypes = new ArrayList<String>();
        }
        this.codeTypes.add(aCodeType);
    }

    public List<String> getCodeTypes() {
        return this.codeTypes;
    }

    public void setCodeTypes(List<String> aCodeTypes) {
        this.codeTypes = aCodeTypes;
    }

    public boolean hasShortName() {
        return this.shortName != null;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String aShortName) {
        this.shortName = aShortName;
    }

    public boolean hasCertNumber() {
        return this.certNumber != UNDEFINED;
    }

    public int getCertNumber() {
        return this.certNumber;
    }

    public void setCertNumber(int aCertNumber) {
        this.certNumber = aCertNumber;
    }

    public void decode(String aTrustAnchorAlias) throws EPPException {
        String[] tokens = aTrustAnchorAlias.split(FIELD_SEP);
        if (tokens.length != NUM_TOKENS) {
            throw new EPPException("Trust anchor alias " + tokens.length + " tokens != " + NUM_TOKENS);
        }
        try {
            this.codeVspId = Integer.parseInt(tokens[0]);
        }
        catch (NumberFormatException ex) {
            this.codeVspId = UNDEFINED;
        }
        try {
            this.vspId = Integer.parseInt(tokens[1]);
        }
        catch (NumberFormatException ex) {
            this.vspId = UNDEFINED;
        }
        this.profileName = tokens[2];
        String theCodeTypesToken = tokens[3];
        String[] theCodeTypes = theCodeTypesToken.split(CODE_TYPE_SEP);
        this.codeTypes = Arrays.asList(theCodeTypes);
        this.shortName = tokens[4];
        try {
            this.certNumber = Integer.parseInt(tokens[5]);
        }
        catch (NumberFormatException ex) {
            this.certNumber = UNDEFINED;
        }
    }

    public String encode() throws EPPException {
        if (!this.hasCodeVspId()) {
            throw new EPPException("Required codeVspId attribute is not set");
        }
        if (!this.hasProfileName()) {
            throw new EPPException("Required profileName attribute is not set");
        }
        if (!this.hasCodeTypes()) {
            throw new EPPException("Required codeTypes attribute is not set");
        }
        if (!this.hasShortName()) {
            throw new EPPException("Required shortName attribute is not set");
        }
        if (!this.hasCertNumber()) {
            throw new EPPException("Required certNumber attribute is not set");
        }
        String retStr = "" + this.codeVspId;
        retStr = retStr + FIELD_SEP + this.vspId;
        retStr = retStr + FIELD_SEP + this.profileName;
        boolean firstCodeType = true;
        for (String codeType : this.codeTypes) {
            if (!firstCodeType) {
                retStr = retStr + CODE_TYPE_SEP;
            } else {
                retStr = retStr + FIELD_SEP;
                firstCodeType = false;
            }
            retStr = retStr + codeType;
        }
        retStr = retStr + FIELD_SEP + this.shortName;
        retStr = retStr + FIELD_SEP + this.certNumber;
        return retStr;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof TrustAnchorVerificationData)) {
            cat.error((Object)("TrustAnchorVerificationData.equals(): " + aObject.getClass().getName() + " not TrustAnchorVerificationData instance"));
            return false;
        }
        TrustAnchorVerificationData other = (TrustAnchorVerificationData)aObject;
        if (!EqualityUtil.equals(this.codeVspId, other.codeVspId)) {
            cat.error((Object)"TrustAnchorVerificationData.equals(): codeVspId not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.vspId, other.vspId)) {
            cat.error((Object)"TrustAnchorVerificationData.equals(): vspId not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.profileName, other.profileName)) {
            cat.error((Object)"TrustAnchorVerificationData.equals(): profileName not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.codeTypes, other.codeTypes)) {
            cat.error((Object)"TrustAnchorVerificationData.equals(): codeTypes not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.shortName, other.shortName)) {
            cat.error((Object)"TrustAnchorVerificationData.equals(): shortName not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.certNumber, other.certNumber)) {
            cat.error((Object)"TrustAnchorVerificationData.equals(): certNumber not equal");
            return false;
        }
        return true;
    }
}

