/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.validate.v02;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPValidateAddress
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPValidateAddress.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "addr";
    public static final String ELM_NAME = "contact:addr";
    private static final String ELM_STREET = "street";
    private static final String ELM_CITY = "city";
    private static final String ELM_STATE_PROVINCE = "sp";
    private static final String ELM_POSTAL_CODE = "pc";
    private static final String ELM_COUNTRY = "cc";
    private static final int MAX_STREET = 3;
    private List<String> streets = new ArrayList<String>();
    private String city;
    private String stateProvince;
    private String postalCode;
    private String country;

    public EPPValidateAddress() {
    }

    public EPPValidateAddress(String aCity, String aCountry) {
        this.city = aCity;
        this.country = aCountry;
    }

    public EPPValidateAddress(List<String> aStreets, String aCity, String aStateProvince, String aPostalCode, String aCountry) {
        this.streets = aStreets;
        this.city = aCity;
        this.stateProvince = aStateProvince;
        this.postalCode = aPostalCode;
        this.country = aCountry;
    }

    public boolean hasStreets() {
        return this.streets != null && !this.streets.isEmpty();
    }

    public void addStreet(String aStreetLine) {
        this.streets.add(aStreetLine);
    }

    public List<String> getStreets() {
        return this.streets;
    }

    public void setStreets(List<String> aStreets) {
        this.streets = aStreets;
    }

    public void setStreet(String aStreet) {
        this.streets = new ArrayList<String>();
        this.streets.add(aStreet);
    }

    public void setStreets(String aStreet1, String aStreet2) {
        this.streets = new ArrayList<String>();
        this.streets.add(aStreet1);
        this.streets.add(aStreet2);
    }

    public void setStreets(String aStreet1, String aStreet2, String aStreet3) {
        this.streets = new ArrayList<String>();
        this.streets.add(aStreet1);
        this.streets.add(aStreet2);
        this.streets.add(aStreet3);
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String aCity) {
        this.city = aCity;
    }

    public String getStateProvince() {
        return this.stateProvince;
    }

    public void setStateProvince(String aStateProvince) {
        this.stateProvince = aStateProvince;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String aPostalCode) {
        this.postalCode = aPostalCode;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String aCountry) {
        this.country = aCountry;
    }

    void validateState() throws EPPCodecException {
        if (this.streets != null && this.streets.contains(null)) {
            throw new EPPCodecException("street lines cannot be set to null");
        }
        if (this.streets != null && !this.streets.isEmpty() && this.streets.size() > 3) {
            throw new EPPCodecException("street lines exceed the maximum");
        }
        if (this.city == null) {
            throw new EPPCodecException("city required attribute is not set");
        }
        if (this.country == null) {
            throw new EPPCodecException("country required attribute is not set");
        }
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPValidateAddress.encode: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:contact-1.0", ELM_NAME);
        EPPUtil.encodeStringList(aDocument, root, this.streets, "urn:ietf:params:xml:ns:contact-1.0", "contact:street");
        EPPUtil.encodeString(aDocument, root, this.city, "urn:ietf:params:xml:ns:contact-1.0", "contact:city");
        EPPUtil.encodeString(aDocument, root, this.stateProvince, "urn:ietf:params:xml:ns:contact-1.0", "contact:sp");
        EPPUtil.encodeString(aDocument, root, this.postalCode, "urn:ietf:params:xml:ns:contact-1.0", "contact:pc");
        EPPUtil.encodeString(aDocument, root, this.country, "urn:ietf:params:xml:ns:contact-1.0", "contact:cc");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.streets = EPPUtil.decodeList(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_STREET);
        this.city = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CITY);
        this.stateProvince = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_STATE_PROVINCE);
        this.postalCode = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_POSTAL_CODE);
        this.country = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_COUNTRY);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPValidateAddress)) {
            return false;
        }
        EPPValidateAddress other = (EPPValidateAddress)aObject;
        if (!EPPUtil.equalLists(this.streets, other.streets)) {
            cat.error((Object)"EPPValidateAddress.equals(): streets not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.city, other.city)) {
            cat.error((Object)"EPPValidateAddress.equals(): city not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.stateProvince, other.stateProvince)) {
            cat.error((Object)"EPPValidateAddress.equals(): stateProvince not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.postalCode, other.postalCode)) {
            cat.error((Object)"EPPValidateAddress.equals(): postalCode not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.country, other.country)) {
            cat.error((Object)"EPPValidateAddress.equals(): country not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPValidateAddress clone = null;
        clone = (EPPValidateAddress)super.clone();
        if (this.hasStreets()) {
            clone.streets = (List)((ArrayList)this.streets).clone();
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:validate-0.2";
    }
}

