/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.syncext;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPSyncExtUpdate
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPSyncExtUpdate.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_NAME = "sync:update";
    public static final String ELM_MONTH_DAY = "sync:expMonthDay";
    private int month = -1;
    private int day = -1;

    public EPPSyncExtUpdate() {
    }

    public EPPSyncExtUpdate(int aMonth, int aDay) {
        this.month = aMonth;
        this.day = aDay;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPSyncExtUpdate clone = null;
        clone = (EPPSyncExtUpdate)super.clone();
        return clone;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error((Object)("EPPSyncExtUpdate.encode(): Invalid state on encode: " + e));
            throw new EPPEncodeException("EPPSyncExtUpdate invalid state: " + e);
        }
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPSyncExtUpdate.encode(Document)");
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/sync-1.0", ELM_NAME);
        root.setAttribute("xmlns:sync", "http://www.verisign.com/epp/sync-1.0");
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.verisign.com/epp/sync-1.0 sync-1.0.xsd");
        int theMonth = this.month + 1;
        String theMonthStr = null;
        theMonthStr = theMonth < 10 ? "0" + theMonth : "" + theMonth;
        String theDayStr = null;
        theDayStr = this.day < 10 ? "0" + this.day : "" + this.day;
        String dateString = "--" + theMonthStr + "-" + theDayStr;
        EPPUtil.encodeString(aDocument, root, dateString, "http://www.verisign.com/epp/sync-1.0", ELM_MONTH_DAY);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        String dateString = EPPUtil.decodeString(aElement, "http://www.verisign.com/epp/sync-1.0", ELM_MONTH_DAY);
        if (dateString.length() != 7) {
            throw new EPPDecodeException("Couldn't parse date string: " + dateString + " it should be 7 characters with the format --MM-dd");
        }
        String theMonth = dateString.substring(2, 4);
        String theDay = dateString.substring(5);
        try {
            this.month = Integer.parseInt(theMonth) - 1;
            this.day = Integer.parseInt(theDay);
        }
        catch (NumberFormatException ex) {
            throw new EPPDecodeException("Error converting month " + theMonth + " or day " + theDay + " to integer: " + ex);
        }
    }

    void validateState() throws EPPCodecException {
        if (this.month < 0 || this.month > 11) {
            throw new EPPCodecException("EPPSyncExtUpdate month value of " + this.month + " is out of range [Calendar.JANUARY(" + 0 + ")<=month<=Calendar.DECEMBER(" + 11 + ")]");
        }
        if (this.day < 1 || this.day > 31) {
            throw new EPPCodecException("EPPSyncExtUpdate day value of " + this.day + " is out of range [1<=day<=31]");
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPSyncExtUpdate)) {
            return false;
        }
        EPPSyncExtUpdate theComp = (EPPSyncExtUpdate)aObject;
        return this.month == theComp.month && this.day == theComp.day;
    }

    public int getMonth() {
        return this.month;
    }

    public void setMonth(int aMonth) {
        this.month = aMonth;
    }

    public int getDay() {
        return this.day;
    }

    public void setDay(int aDay) {
        this.day = aDay;
    }

    @Override
    public String getNamespace() {
        return "http://www.verisign.com/epp/sync-1.0";
    }
}

