/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.secdnsext.v10;

import com.verisign.epp.codec.domain.EPPDomainContact;
import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.domain.EPPDomainPeriod;
import com.verisign.epp.codec.domain.EPPDomainStatus;
import com.verisign.epp.codec.domain.EPPDomainUpdateCmd;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodec;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.secdnsext.v10.EPPSecDNSExtCreate;
import com.verisign.epp.codec.secdnsext.v10.EPPSecDNSExtDsData;
import com.verisign.epp.codec.secdnsext.v10.EPPSecDNSExtFactory;
import com.verisign.epp.codec.secdnsext.v10.EPPSecDNSExtInfData;
import com.verisign.epp.codec.secdnsext.v10.EPPSecDNSExtKeyData;
import com.verisign.epp.codec.secdnsext.v10.EPPSecDNSExtUpdate;
import com.verisign.epp.util.TestThread;
import java.util.Date;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.w3c.dom.Document;

public class EPPSecDNSExtTst
extends TestCase {
    private static long numIterations = 1L;

    public EPPSecDNSExtTst(String name) {
        super(name);
    }

    public void testDomainInfoRespWithSecDNSExt() {
        EPPCodecTst.printStart("testDomainInfoRespWithSecDNSExt");
        EPPTransId respTransId = new EPPTransId("54321-CLI", "54321-SER");
        Vector<EPPDomainStatus> statuses = new Vector<EPPDomainStatus>();
        statuses.addElement(new EPPDomainStatus("ok"));
        EPPDomainInfoResp theResponse = new EPPDomainInfoResp(respTransId, "EXAMPLE1-VRSN", "example.tv", "ClientX", statuses, "ClientY", new Date(), new EPPAuthInfo("2fooBAR"));
        theResponse.setRegistrant("JD1234-VRSN");
        Vector<String> servers = new Vector<String>();
        servers.addElement("ns1.example.tv");
        servers.addElement("ns2.example.tv");
        theResponse.setNses(servers);
        Vector<String> hosts = new Vector<String>();
        hosts.addElement("ns1.example.tv");
        hosts.addElement("ns2.example.tv");
        theResponse.setHosts(hosts);
        if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
            Vector<EPPDomainContact> contacts = new Vector<EPPDomainContact>();
            contacts.addElement(new EPPDomainContact("SH8013-VRSN", "admin"));
            contacts.addElement(new EPPDomainContact("SH8013-VRSN", "tech"));
            theResponse.setContacts(contacts);
        }
        theResponse.setLastUpdatedBy("ClientX");
        theResponse.setLastUpdatedDate(new Date());
        theResponse.setLastTransferDate(new Date());
        respTransId = new EPPTransId("54321-CLI", "54321-SER");
        theResponse.setTransId(respTransId);
        theResponse.setRoid("EXAMPLE1-VRSN");
        theResponse.setResult(1000);
        EPPSecDNSExtKeyData keyData = new EPPSecDNSExtKeyData();
        keyData.setFlags(257);
        keyData.setProtocol(3);
        keyData.setAlg(5);
        keyData.setPubKey("AQPmsXk3Q1ngNSzsH1lrX63mRIhtwkkK+5ZjvxykBCV1NYne83+8RXkBElGb/YJ1n4TacMUspoZap7caJj7MdOaADKmzB2ci0vwpubNyW0t2AnaQqpy1ce+07Y8RkbTC6xCeEw1UQZ73PzIOOvJDdjwPxWaO9F7zSxnGpGt0WtuItQ==");
        EPPSecDNSExtKeyData keyData2 = new EPPSecDNSExtKeyData(257, 3, 5, "AQOxXpFbRp7+zPBoTt6zL7Af0aEKzpS4JbVB5ofk5E5HpXuUmU+Hnt9hm2kMph6LZdEEL142nq0HrgiETFCsN/YM4Zn+meRkELLpCG93Cu/HhwvxfaZenUAAA6Vb9FwXQ1EMYRW05K/gh2Gew5Sk/0o6Ev7DKG2YiDJYA17QsaZtFw==");
        EPPSecDNSExtDsData dsData = new EPPSecDNSExtDsData();
        dsData.setKeyTag(34095);
        dsData.setAlg(5);
        dsData.setDigestType(1);
        dsData.setDigest("6BD4FFFF11566D6E6A5BA44ED0018797564AA289");
        dsData.setMaxSigLife(604800);
        dsData.setKeyData(keyData);
        EPPSecDNSExtDsData dsData2 = new EPPSecDNSExtDsData(10563, 5, 1, "9C20674BFF957211D129B0DFE9410AF753559D4B", 604800, keyData2);
        EPPSecDNSExtInfData infData = new EPPSecDNSExtInfData();
        Vector<EPPSecDNSExtDsData> dsDataVec = new Vector<EPPSecDNSExtDsData>();
        dsDataVec.add(dsData);
        infData.setDsData(dsDataVec);
        infData.appendDsData(dsData2);
        theResponse.addExtension(infData);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testDomainInfoRespWithSecDNSExt");
    }

    public void testDomainCreate() {
        EPPCodecTst.printStart("testDomainCreate");
        Vector<String> servers = new Vector<String>();
        servers.addElement("ns1.example.tv");
        servers.addElement("ns2.example.tv");
        Vector<EPPDomainContact> contacts = null;
        if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
            contacts = new Vector<EPPDomainContact>();
            contacts.addElement(new EPPDomainContact("SH8013-VRSN", "admin"));
            contacts.addElement(new EPPDomainContact("SH8013-VRSN", "tech"));
        }
        EPPDomainCreateCmd theCommand = new EPPDomainCreateCmd("ABC-12345-XYZ", "example.tv", servers, contacts, new EPPDomainPeriod(2), new EPPAuthInfo("2fooBAR"));
        EPPSecDNSExtKeyData keyData = new EPPSecDNSExtKeyData();
        keyData.setFlags(257);
        keyData.setProtocol(3);
        keyData.setAlg(5);
        keyData.setPubKey("AQPmsXk3Q1ngNSzsH1lrX63mRIhtwkkK+5ZjvxykBCV1NYne83+8RXkBElGb/YJ1n4TacMUspoZap7caJj7MdOaADKmzB2ci0vwpubNyW0t2AnaQqpy1ce+07Y8RkbTC6xCeEw1UQZ73PzIOOvJDdjwPxWaO9F7zSxnGpGt0WtuItQ==");
        EPPSecDNSExtKeyData keyData2 = new EPPSecDNSExtKeyData(257, 3, 5, "AQOxXpFbRp7+zPBoTt6zL7Af0aEKzpS4JbVB5ofk5E5HpXuUmU+Hnt9hm2kMph6LZdEEL142nq0HrgiETFCsN/YM4Zn+meRkELLpCG93Cu/HhwvxfaZenUAAA6Vb9FwXQ1EMYRW05K/gh2Gew5Sk/0o6Ev7DKG2YiDJYA17QsaZtFw==");
        EPPSecDNSExtDsData dsData = new EPPSecDNSExtDsData();
        dsData.setKeyTag(34095);
        dsData.setAlg(5);
        dsData.setDigestType(1);
        dsData.setDigest("6BD4FFFF11566D6E6A5BA44ED0018797564AA289");
        dsData.setMaxSigLife(604800);
        dsData.setKeyData(keyData);
        EPPSecDNSExtDsData dsData2 = new EPPSecDNSExtDsData(10563, 5, 1, "9C20674BFF957211D129B0DFE9410AF753559D4B", 604800, keyData2);
        EPPSecDNSExtCreate create = new EPPSecDNSExtCreate();
        Vector<EPPSecDNSExtDsData> dsDataVec = new Vector<EPPSecDNSExtDsData>();
        dsDataVec.add(dsData);
        create.setDsData(dsDataVec);
        create.appendDsData(dsData2);
        theCommand.addExtension(create);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testDomainCreate");
    }

    public void testDomainUpdate() {
        Document ex2;
        EPPCodecTst.printStart("testDomainUpdate");
        EPPDomainUpdateCmd theCommand = new EPPDomainUpdateCmd("example.tv");
        theCommand.setTransId("ABC-12345-XYZ-1");
        EPPSecDNSExtKeyData keyData = new EPPSecDNSExtKeyData();
        keyData.setFlags(257);
        keyData.setProtocol(3);
        keyData.setAlg(5);
        keyData.setPubKey("AQPmsXk3Q1ngNSzsH1lrX63mRIhtwkkK+5ZjvxykBCV1NYne83+8RXkBElGb/YJ1n4TacMUspoZap7caJj7MdOaADKmzB2ci0vwpubNyW0t2AnaQqpy1ce+07Y8RkbTC6xCeEw1UQZ73PzIOOvJDdjwPxWaO9F7zSxnGpGt0WtuItQ==");
        EPPSecDNSExtKeyData keyData2 = new EPPSecDNSExtKeyData(257, 3, 5, "AQOxXpFbRp7+zPBoTt6zL7Af0aEKzpS4JbVB5ofk5E5HpXuUmU+Hnt9hm2kMph6LZdEEL142nq0HrgiETFCsN/YM4Zn+meRkELLpCG93Cu/HhwvxfaZenUAAA6Vb9FwXQ1EMYRW05K/gh2Gew5Sk/0o6Ev7DKG2YiDJYA17QsaZtFw==");
        EPPSecDNSExtDsData dsData = new EPPSecDNSExtDsData();
        dsData.setKeyTag(34095);
        dsData.setAlg(5);
        dsData.setDigestType(1);
        dsData.setDigest("6BD4FFFF11566D6E6A5BA44ED0018797564AA289");
        dsData.setMaxSigLife(604800);
        dsData.setKeyData(keyData);
        EPPSecDNSExtDsData dsData2 = new EPPSecDNSExtDsData(10563, 5, 1, "9C20674BFF957211D129B0DFE9410AF753559D4B", 604800, keyData2);
        Vector<EPPSecDNSExtDsData> addDsDataVec = new Vector<EPPSecDNSExtDsData>();
        addDsDataVec.add(dsData);
        addDsDataVec.add(dsData2);
        Vector<EPPSecDNSExtDsData> chgDsDataVec = new Vector<EPPSecDNSExtDsData>();
        chgDsDataVec.add(dsData);
        Integer keyTag = 34095;
        Integer keyTag2 = 10563;
        Vector<Integer> remKeyTagVec = new Vector<Integer>();
        remKeyTagVec.add(keyTag);
        remKeyTagVec.add(keyTag2);
        EPPSecDNSExtUpdate update = new EPPSecDNSExtUpdate();
        update.setAdd(addDsDataVec);
        update.setUrgent(true);
        theCommand.addExtension(update);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand = new EPPDomainUpdateCmd("example.tv");
        theCommand.setTransId("ABC-12345-XYZ-2");
        update = new EPPSecDNSExtUpdate();
        update.setChg(chgDsDataVec);
        update.setUrgent(false);
        theCommand.addExtension(update);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand = new EPPDomainUpdateCmd("example.tv");
        theCommand.setTransId("ABC-12345-XYZ-3");
        update = new EPPSecDNSExtUpdate();
        update.setRem(remKeyTagVec);
        update.appendRem(keyTag);
        update.appendRem(keyTag2);
        update.appendRem(dsData);
        update.appendRem(dsData2.getKeyTag());
        theCommand.addExtension(update);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        System.out.println("\ndomainUpdate: Negative Test - DNSSEC Update with add & rem");
        theCommand = new EPPDomainUpdateCmd("example.tv");
        theCommand.setTransId("ABC-12345-XYZ-3");
        update = new EPPSecDNSExtUpdate();
        update.setAdd(addDsDataVec);
        update.setRem(remKeyTagVec);
        theCommand.addExtension(update);
        try {
            Document document = EPPCodec.getInstance().encode(theCommand);
        }
        catch (EPPEncodeException ex2) {
            Assert.assertEquals((String)"EPPSecDNSExtUpdate invalid state: com.verisign.epp.codec.gen.EPPCodecException: Only one add, chg, or rem is allowed", (String)ex2.getMessage());
        }
        System.out.println("\ndomainUpdate: Negative Test - DNSSEC Update with chg & rem");
        theCommand = new EPPDomainUpdateCmd("example.tv");
        theCommand.setTransId("ABC-12345-XYZ-4");
        update = new EPPSecDNSExtUpdate();
        update.setChg(chgDsDataVec);
        update.setRem(remKeyTagVec);
        theCommand.addExtension(update);
        try {
            ex2 = EPPCodec.getInstance().encode(theCommand);
        }
        catch (EPPEncodeException ex3) {
            Assert.assertEquals((String)"EPPSecDNSExtUpdate invalid state: com.verisign.epp.codec.gen.EPPCodecException: Only one add, chg, or rem is allowed", (String)ex3.getMessage());
        }
        System.out.println("\ndomainUpdate: Negative Test - DNSSEC Update with add & chg");
        theCommand = new EPPDomainUpdateCmd("example.tv");
        theCommand.setTransId("ABC-12345-XYZ-5");
        update = new EPPSecDNSExtUpdate();
        update.setAdd(addDsDataVec);
        update.setChg(chgDsDataVec);
        theCommand.addExtension(update);
        try {
            ex2 = EPPCodec.getInstance().encode(theCommand);
        }
        catch (EPPEncodeException ex4) {
            Assert.assertEquals((String)"EPPSecDNSExtUpdate invalid state: com.verisign.epp.codec.gen.EPPCodecException: Only one add, chg, or rem is allowed", (String)ex4.getMessage());
        }
        System.out.println("\ndomainUpdate: Negative Test - DNSSEC Update with add & chg & rem");
        update = new EPPSecDNSExtUpdate();
        update.setAdd(addDsDataVec);
        update.setChg(chgDsDataVec);
        update.setRem(remKeyTagVec);
        theCommand.addExtension(update);
        try {
            ex2 = EPPCodec.getInstance().encode(theCommand);
        }
        catch (EPPEncodeException ex5) {
            Assert.assertEquals((String)"EPPSecDNSExtUpdate invalid state: com.verisign.epp.codec.gen.EPPCodecException: Only one add, chg, or rem is allowed", (String)ex5.getMessage());
        }
        EPPCodecTst.printEnd("testDomainUpdate");
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static Test suite() {
        EPPCodecTst.initEnvironment();
        TestSuite suite = new TestSuite(EPPSecDNSExtTst.class);
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.host.EPPHostMapFactory");
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.domain.EPPDomainMapFactory");
            EPPFactory.getInstance().addExtFactory(EPPSecDNSExtFactory.class.getName());
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding EPPDomainMapFactory or EPPSecDNSExtFactory to EPPCodec: " + e));
        }
        return suite;
    }

    public static void main(String[] args) {
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPSecDNSExtTst Thread " + i, EPPSecDNSExtTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPSecDNSExtTst.suite());
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }
}

