/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.secdnsext.v10;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPSecDNSExtKeyData
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPSecDNSExtKeyData.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    static final String ELM_NAME = "secDNS:keyData";
    private static final String ELM_FLAGS = "secDNS:flags";
    private static final String ELM_PROTOCOL = "secDNS:protocol";
    private static final String ELM_ALG = "secDNS:alg";
    private static final String ELM_PUB_KEY = "secDNS:pubKey";
    public static final int DEFAULT_PROTOCOL = 3;
    public static final int FLAGS_ZONE_KEY = 256;
    public static final int FLAGS_ZONE_KEY_SEP = 257;
    private static final int UNSPEC_INT = -1;
    public static final int UNSPEC_FLAGS = -1;
    public static final int MIN_FLAGS = 0;
    public static final int MAX_FLAGS = 65535;
    public static final int UNSPEC_PROTOCOL = -1;
    public static final int MIN_PROTOCOL = 0;
    public static final int MAX_PROTOCOL = 255;
    public static final int UNSPEC_ALG = -1;
    public static final int MIN_ALG = 0;
    public static final int MAX_ALG = 255;
    private int flags = -1;
    private int protocol = 3;
    private int alg = -1;
    private String pubKey = null;

    public EPPSecDNSExtKeyData() {
    }

    public EPPSecDNSExtKeyData(EPPSecDNSExtKeyData keyData) {
        this(keyData.getFlags(), keyData.getProtocol(), keyData.getAlg(), keyData.getPubKey());
    }

    public EPPSecDNSExtKeyData(int flags, int protocol, int alg, String pubKey) {
        this.setFlags(flags);
        this.setProtocol(protocol);
        this.setAlg(alg);
        this.setPubKey(pubKey);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error((Object)("EPPSecDNSExtKeyData.encode(): Invalid state on encode: " + e));
            throw new EPPEncodeException("EPPSecDNSExtKeyData invalid state: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:secDNS-1.0", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.flags + "", "urn:ietf:params:xml:ns:secDNS-1.0", ELM_FLAGS);
        EPPUtil.encodeString(aDocument, root, this.protocol + "", "urn:ietf:params:xml:ns:secDNS-1.0", ELM_PROTOCOL);
        EPPUtil.encodeString(aDocument, root, this.alg + "", "urn:ietf:params:xml:ns:secDNS-1.0", ELM_ALG);
        EPPUtil.encodeString(aDocument, root, this.pubKey, "urn:ietf:params:xml:ns:secDNS-1.0", ELM_PUB_KEY);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        Integer flagsInt = EPPUtil.decodeInteger(aElement, "urn:ietf:params:xml:ns:secDNS-1.0", ELM_FLAGS);
        this.flags = flagsInt == null ? -1 : flagsInt;
        Integer protocolInt = EPPUtil.decodeInteger(aElement, "urn:ietf:params:xml:ns:secDNS-1.0", ELM_PROTOCOL);
        this.protocol = protocolInt == null ? -1 : protocolInt;
        Integer algInt = EPPUtil.decodeInteger(aElement, "urn:ietf:params:xml:ns:secDNS-1.0", ELM_ALG);
        this.alg = algInt == null ? -1 : algInt;
        this.setPubKey(EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:secDNS-1.0", ELM_PUB_KEY));
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPSecDNSExtKeyData)) {
            return false;
        }
        EPPSecDNSExtKeyData theComp = (EPPSecDNSExtKeyData)aObject;
        if (this.flags != theComp.flags) {
            return false;
        }
        if (this.protocol != theComp.protocol) {
            return false;
        }
        if (this.alg != theComp.alg) {
            return false;
        }
        return this.pubKey != null ? this.pubKey.equals(theComp.pubKey) : theComp.pubKey == null;
    }

    void validateState() throws EPPCodecException {
        if (this.flags == -1) {
            throw new EPPCodecException("EPPSecDNSExtKeyData required element flags is not set");
        }
        if (this.flags < 0 && this.flags > 65535) {
            throw new EPPCodecException("EPPSecDNSExtKeyData flags of " + this.flags + " is out of range, must be between " + 0 + " and " + 65535);
        }
        if (this.protocol == -1) {
            throw new EPPCodecException("EPPSecDNSExtKeyData required element protocol is not set");
        }
        if (this.protocol < 0 && this.flags > 255) {
            throw new EPPCodecException("EPPSecDNSExtKeyData protocol of " + this.protocol + " is out of range, must be between " + 0 + " and " + 255);
        }
        if (this.alg == -1) {
            throw new EPPCodecException("EPPSecDNSExtKeyData required element alg is not set");
        }
        if (this.alg < 0 && this.alg > 255) {
            throw new EPPCodecException("EPPSecDNSExtKeyData alg of " + this.alg + " is out of range, must be between " + 0 + " and " + 255);
        }
        if (this.pubKey == null) {
            throw new EPPCodecException("EPPSecDNSExtKeyData required element pubKey is not set");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPSecDNSExtKeyData clone = null;
        clone = (EPPSecDNSExtKeyData)super.clone();
        clone.flags = this.flags;
        clone.protocol = this.protocol;
        clone.alg = this.alg;
        clone.pubKey = this.pubKey;
        return clone;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public int getProtocol() {
        return this.protocol;
    }

    public void setProtocol(int protocol) {
        this.protocol = protocol;
    }

    public int getAlg() {
        return this.alg;
    }

    public void setAlg(int alg) {
        this.alg = alg;
    }

    public String getPubKey() {
        return this.pubKey;
    }

    public void setPubKey(String pubKey) {
        this.pubKey = EPPUtil.removeWhitespace(pubKey);
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:secDNS-1.0";
    }
}

