/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.rgpext;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.rgpext.EPPRgpExtReportText;
import com.verisign.epp.util.EPPCatFactory;
import java.util.Date;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRgpExtReport
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPRgpExtReport.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_NAME = "rgp:report";
    public static final String ELM_PRE_DATA = "rgp:preData";
    public static final String ELM_POST_DATA = "rgp:postData";
    public static final String ELM_PRE_WHOIS = "rgp:preWhois";
    public static final String ELM_POST_WHOIS = "rgp:postWhois";
    public static final String ELM_DEL_TIME = "rgp:delTime";
    public static final String ELM_RES_TIME = "rgp:resTime";
    public static final String ELM_OTHER = "rgp:other";
    private String preData;
    private String postData;
    private Date deleteTime;
    private Date restoreTime;
    private EPPRgpExtReportText statement1;
    private EPPRgpExtReportText statement2;
    private EPPRgpExtReportText restoreReason;
    private String other;

    public EPPRgpExtReport() {
    }

    public EPPRgpExtReport(String aPreData, String aPostData, Date aDeleteTime, Date aRestoreTime, EPPRgpExtReportText aRestoreReason, EPPRgpExtReportText aStatement1) {
        this.preData = aPreData;
        this.postData = aPostData;
        this.deleteTime = aDeleteTime;
        this.restoreTime = aRestoreTime;
        this.restoreReason = aRestoreReason;
        this.statement1 = aStatement1;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error((Object)("EPPRgpExtReport.encode(): Invalid state on encode: " + e));
            throw new EPPEncodeException("EPPRgpExtReport invalid state: " + e);
        }
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPRgpExtReport.encode(Document)");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:rgp-1.0", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.preData, "urn:ietf:params:xml:ns:rgp-1.0", ELM_PRE_DATA);
        EPPUtil.encodeString(aDocument, root, this.postData, "urn:ietf:params:xml:ns:rgp-1.0", ELM_POST_DATA);
        EPPUtil.encodeTimeInstant(aDocument, root, this.deleteTime, "urn:ietf:params:xml:ns:rgp-1.0", ELM_DEL_TIME);
        EPPUtil.encodeTimeInstant(aDocument, root, this.restoreTime, "urn:ietf:params:xml:ns:rgp-1.0", ELM_RES_TIME);
        EPPUtil.encodeComp(aDocument, root, this.restoreReason);
        EPPUtil.encodeComp(aDocument, root, this.statement1);
        EPPUtil.encodeComp(aDocument, root, this.statement2);
        EPPUtil.encodeString(aDocument, root, this.other, "urn:ietf:params:xml:ns:rgp-1.0", ELM_OTHER);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.preData = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:rgp-1.0", ELM_PRE_DATA);
        if (this.preData == null) {
            this.preData = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:rgp-1.0", ELM_PRE_WHOIS);
        }
        this.postData = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:rgp-1.0", ELM_POST_DATA);
        if (this.postData == null) {
            this.postData = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:rgp-1.0", ELM_POST_WHOIS);
        }
        this.deleteTime = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:rgp-1.0", ELM_DEL_TIME);
        this.restoreTime = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:rgp-1.0", ELM_RES_TIME);
        this.restoreReason = (EPPRgpExtReportText)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:rgp-1.0", "resReason", EPPRgpExtReportText.class);
        Vector statements = EPPUtil.decodeCompVector(aElement, "urn:ietf:params:xml:ns:rgp-1.0", "statement", EPPRgpExtReportText.class);
        if (statements != null) {
            if (statements.size() == 1) {
                this.statement1 = (EPPRgpExtReportText)statements.elementAt(0);
            } else {
                this.statement1 = (EPPRgpExtReportText)statements.elementAt(0);
                this.statement2 = (EPPRgpExtReportText)statements.elementAt(1);
            }
        }
        this.other = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:rgp-1.0", ELM_OTHER);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRgpExtReport)) {
            return false;
        }
        EPPRgpExtReport theComp = (EPPRgpExtReport)aObject;
        if (!(this.preData != null ? this.preData.equals(theComp.preData) : theComp.preData == null)) {
            return false;
        }
        if (!(this.postData != null ? this.postData.equals(theComp.postData) : theComp.postData == null)) {
            return false;
        }
        if (!(this.deleteTime != null ? this.deleteTime.equals(theComp.deleteTime) : theComp.deleteTime == null)) {
            return false;
        }
        if (!(this.restoreTime != null ? this.restoreTime.equals(theComp.restoreTime) : theComp.restoreTime == null)) {
            return false;
        }
        if (!(this.restoreReason != null ? this.restoreReason.equals(theComp.restoreReason) : theComp.restoreReason == null)) {
            return false;
        }
        if (!(this.statement1 != null ? this.statement1.equals(theComp.statement1) : theComp.statement1 == null)) {
            return false;
        }
        return this.statement2 != null ? this.statement2.equals(theComp.statement2) : theComp.statement2 == null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRgpExtReport clone = null;
        clone = (EPPRgpExtReport)super.clone();
        if (this.deleteTime != null) {
            clone.deleteTime = (Date)this.deleteTime.clone();
        }
        if (this.restoreTime != null) {
            clone.restoreTime = (Date)this.restoreTime.clone();
        }
        clone.preData = this.preData;
        clone.postData = this.postData;
        if (this.restoreReason != null) {
            clone.restoreReason = (EPPRgpExtReportText)this.restoreReason.clone();
        }
        if (this.statement1 != null) {
            clone.statement1 = (EPPRgpExtReportText)this.statement1.clone();
        }
        if (this.statement2 != null) {
            clone.statement2 = (EPPRgpExtReportText)this.statement2.clone();
        }
        return clone;
    }

    void validateState() throws EPPCodecException {
        if (this.preData == null) {
            throw new EPPCodecException("preData required attribute is not set");
        }
        if (this.postData == null) {
            throw new EPPCodecException("postData required attribute is not set");
        }
        if (this.deleteTime == null) {
            throw new EPPCodecException("deleteTime required attribute is not set");
        }
        if (this.restoreTime == null) {
            throw new EPPCodecException("restoreTime required attribute is not set");
        }
        if (this.restoreReason == null) {
            throw new EPPCodecException("restoreReason required attribute is not set");
        }
        if (this.statement1 == null) {
            throw new EPPCodecException("statement1 required attribute is not set");
        }
    }

    public String getPreWhois() {
        return this.preData;
    }

    public void setPreWhois(String preWhois) {
        this.preData = preWhois;
    }

    public String getPreData() {
        return this.preData;
    }

    public void setPreData(String aPreData) {
        this.preData = aPreData;
    }

    public String getPostWhois() {
        return this.postData;
    }

    public void setPostWhois(String postWhois) {
        this.postData = postWhois;
    }

    public String getPostData() {
        return this.postData;
    }

    public void setPostData(String aPostData) {
        this.postData = aPostData;
    }

    public Date getDeleteTime() {
        return this.deleteTime;
    }

    public void setDeleteTime(Date deleteTime) {
        this.deleteTime = deleteTime;
    }

    public Date getRestoreTime() {
        return this.restoreTime;
    }

    public void setRestoreTime(Date restoreTime) {
        this.restoreTime = restoreTime;
    }

    public EPPRgpExtReportText getStatement1() {
        return this.statement1;
    }

    public void setStatement1(EPPRgpExtReportText statement1) {
        if (statement1 != null) {
            statement1.setLocalName("statement");
            this.statement1 = statement1;
        }
    }

    public EPPRgpExtReportText getStatement2() {
        return this.statement2;
    }

    public void setStatement2(EPPRgpExtReportText statement2) {
        if (statement2 != null) {
            statement2.setLocalName("statement");
            this.statement2 = statement2;
        }
    }

    public EPPRgpExtReportText getRestoreReason() {
        return this.restoreReason;
    }

    public void setRestoreReason(EPPRgpExtReportText restoreReason) {
        if (restoreReason != null) {
            restoreReason.setLocalName("resReason");
            this.restoreReason = restoreReason;
        }
    }

    public String getOther() {
        return this.other;
    }

    public void setOther(String other) {
        this.other = other;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:rgp-1.0";
    }
}

