/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.relateddomainext;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtDomain;
import com.verisign.epp.util.EPPCatFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRelatedDomainExtCreate
implements EPPCodecComponent {
    private static final long serialVersionUID = 1L;
    private static Logger cat = Logger.getLogger((String)EPPRelatedDomainExtCreate.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_NAME = "relDom:create";
    private List<EPPRelatedDomainExtDomain> domains = null;

    public EPPRelatedDomainExtCreate() {
    }

    public EPPRelatedDomainExtCreate(List<EPPRelatedDomainExtDomain> aDomains) {
        this.domains = aDomains;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRelatedDomainExtCreate theClone = new EPPRelatedDomainExtCreate();
        if (this.domains != null) {
            theClone.domains = new ArrayList<EPPRelatedDomainExtDomain>();
            for (EPPRelatedDomainExtDomain domain : this.domains) {
                if (domain != null) {
                    theClone.domains.add((EPPRelatedDomainExtDomain)domain.clone());
                    continue;
                }
                theClone.domains.add(null);
            }
        } else {
            theClone.domains = null;
        }
        return theClone;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.domains = EPPUtil.decodeCompList(aElement, "http://www.verisign.com/epp/relatedDomain-1.0", "relDom:domain", EPPRelatedDomainExtDomain.class);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null in EPPRelatedDomainExtCreate.encode(Document)");
        }
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error((Object)("EPPRelatedDomainExtCreate.encode(): Invalid state on encode: " + e));
            throw new EPPEncodeException("EPPRelatedDomainExtCreate invalid state: " + e);
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/relatedDomain-1.0", ELM_NAME);
        EPPUtil.encodeCompList(aDocument, root, this.domains);
        return root;
    }

    public boolean equals(Object aObj) {
        if (!(aObj instanceof EPPRelatedDomainExtCreate)) {
            return false;
        }
        EPPRelatedDomainExtCreate theComp = (EPPRelatedDomainExtCreate)aObj;
        if (!EPPUtil.equalLists(this.domains, theComp.domains)) {
            cat.error((Object)"EPPRelatedDomainExtCreate.equals(): related domains not equal");
            return false;
        }
        return true;
    }

    public void addDomain(EPPRelatedDomainExtDomain aDomain) {
        if (this.domains == null) {
            this.domains = new ArrayList<EPPRelatedDomainExtDomain>();
        }
        this.domains.add(aDomain);
    }

    public boolean hasDomains() {
        return this.domains != null && this.domains.size() > 0;
    }

    public List<EPPRelatedDomainExtDomain> getDomains() {
        return this.domains;
    }

    public void setDomains(List<EPPRelatedDomainExtDomain> aRelatedDomains) {
        this.domains = aRelatedDomains;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "http://www.verisign.com/epp/relatedDomain-1.0";
    }

    private void validateState() throws EPPCodecException {
        if (this.domains == null || this.domains.size() == 0) {
            throw new EPPCodecException("EPPRelatedDomainExtCreate contains no  elements.");
        }
        for (EPPRelatedDomainExtDomain domain : this.domains) {
            if (domain == null) {
                throw new EPPCodecException("EPPRelatedDomainExtCreate: contains null EPPRelatedDomainExtDomain element.");
            }
            domain.validateStateForCreate();
        }
    }
}

