/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v02;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.v02.EPPRegistryZoneName;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.Date;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryZoneSummary
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPRegistryZoneSummary.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "zone";
    public static final String ELM_NAME = "registry:zone";
    static final String ELM_CREATE_DATE = "crDate";
    static final String ELM_UPDATE_DATE = "upDate";
    public static final String ATTR_ACCESSIBLE = "accessible";
    private EPPRegistryZoneName name;
    private Date createDate;
    private Date updateDate;
    boolean accessible = true;

    public EPPRegistryZoneSummary() {
    }

    public EPPRegistryZoneSummary(String aName, boolean aAccessible, Date aCreateDate) {
        this();
        this.setName(aName);
        this.accessible = aAccessible;
        this.createDate = aCreateDate;
    }

    public EPPRegistryZoneSummary(EPPRegistryZoneName aName, boolean aAccessible, Date aCreateDate) {
        this();
        this.setName(aName);
        this.accessible = aAccessible;
        this.createDate = aCreateDate;
    }

    public EPPRegistryZoneSummary(String aName, boolean aAccessible, Date aCreateDate, Date aUpdateDate) {
        this(aName, aAccessible, aCreateDate);
        this.updateDate = aUpdateDate;
    }

    public EPPRegistryZoneSummary(EPPRegistryZoneName aName, boolean aAccessible, Date aCreateDate, Date aUpdateDate) {
        this(aName, aAccessible, aCreateDate);
        this.updateDate = aUpdateDate;
    }

    void validateState() throws EPPCodecException {
        if (this.name == null) {
            throw new EPPCodecException("name required attribute is not set");
        }
        if (this.createDate == null) {
            throw new EPPCodecException("createDate required attribute is not set");
        }
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error((Object)(this.getClass().getName() + ".encode(): Invalid state on encode: " + e));
            throw new EPPEncodeException("Invalid state on " + this.getClass().getName() + ".encode(): " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.2", ELM_NAME);
        EPPUtil.encodeComp(aDocument, root, this.name);
        EPPUtil.encodeTimeInstant(aDocument, root, this.createDate, "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:crDate");
        if (this.updateDate != null) {
            EPPUtil.encodeTimeInstant(aDocument, root, this.updateDate, "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:upDate");
        }
        EPPUtil.encodeBooleanAttr(root, ATTR_ACCESSIBLE, this.accessible);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.name = (EPPRegistryZoneName)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", "name", EPPRegistryZoneName.class);
        this.createDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", ELM_CREATE_DATE);
        this.updateDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", ELM_UPDATE_DATE);
        this.accessible = aElement.getAttribute(ATTR_ACCESSIBLE) != null ? EPPUtil.decodeBooleanAttr(aElement, ATTR_ACCESSIBLE) : true;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryZoneSummary)) {
            return false;
        }
        EPPRegistryZoneSummary theComp = (EPPRegistryZoneSummary)aObject;
        if (!EqualityUtil.equals(this.name, theComp.name)) {
            cat.error((Object)"EPPRegistryZoneSummary.equals(): name not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.createDate, theComp.createDate)) {
            cat.error((Object)"EPPRegistryZoneSummary.equals(): createDate not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.updateDate, theComp.updateDate)) {
            cat.error((Object)"EPPRegistryZoneSummary.equals(): updateDate not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.accessible, theComp.accessible)) {
            cat.error((Object)"EPPRegistryZoneSummary.equals(): accessible not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryZoneSummary clone = (EPPRegistryZoneSummary)super.clone();
        if (this.name != null) {
            clone.name = (EPPRegistryZoneName)this.name.clone();
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public EPPRegistryZoneName getName() {
        return this.name;
    }

    public void setName(EPPRegistryZoneName aName) {
        this.name = aName;
    }

    public void setName(String aName) {
        this.name = new EPPRegistryZoneName(aName, EPPRegistryZoneName.Form.aLabel);
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public boolean isAccessible() {
        return this.accessible;
    }

    public void setAccessible(boolean aAccessible) {
        this.accessible = aAccessible;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:registry-0.2";
    }
}

