/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v02;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.v02.EPPRegistryZone;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryZoneData
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPRegistryZoneData.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_NAME = "registry:zone";
    public static final String ATTR_ACCESSIBLE = "accessible";
    EPPRegistryZone zone = null;
    boolean accessible = true;

    public EPPRegistryZoneData() {
    }

    public EPPRegistryZoneData(EPPRegistryZone aZone, boolean aAccessible) {
        this.zone = aZone;
        this.accessible = aAccessible;
    }

    public EPPRegistryZone getZone() {
        return this.zone;
    }

    public void setZone(EPPRegistryZone aZone) {
        this.zone = aZone;
    }

    public boolean isAccessible() {
        return this.accessible;
    }

    public void setAccessible(boolean aAccessible) {
        this.accessible = aAccessible;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.zone == null) {
            throw new EPPEncodeException("The zone is null");
        }
        Element theRootElm = this.zone.encode(aDocument);
        EPPUtil.encodeBooleanAttr(theRootElm, ATTR_ACCESSIBLE, this.accessible);
        return theRootElm;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.zone = new EPPRegistryZone();
        this.zone.decode(aElement);
        this.accessible = aElement.getAttribute(ATTR_ACCESSIBLE) != null ? EPPUtil.decodeBooleanAttr(aElement, ATTR_ACCESSIBLE) : true;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryZoneData)) {
            return false;
        }
        EPPRegistryZoneData theComp = (EPPRegistryZoneData)aObject;
        if (!EqualityUtil.equals(this.accessible, theComp.accessible)) {
            cat.error((Object)"EPPRegistryZoneData.equals(): accessible not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryZoneData clone = (EPPRegistryZoneData)super.clone();
        if (this.zone != null) {
            clone.zone = (EPPRegistryZone)this.zone.clone();
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:registry-0.2";
    }
}

