/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v02;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.v02.EPPRegistryZoneName;
import com.verisign.epp.util.EqualityUtil;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPRegistryCheckResult
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger(EPPRegistryCheckResult.class);
    public static final String ELM_LOCALNAME = "cd";
    public static final String ELM_NAME = "registry:cd";
    private static final String ELM_REGISTRY_REASON = "reason";
    private static final String ATTR_AVAIL = "avail";
    private static final String ATTR_LANG = "lang";
    private static final String VALUE_LANG = "en";
    private String language = "en";
    private EPPRegistryZoneName name;
    private Boolean available;
    private String reason;

    public EPPRegistryCheckResult() {
        this.name = null;
        this.available = Boolean.TRUE;
    }

    public EPPRegistryCheckResult(String aName, Boolean aAvailable) {
        this.setName(aName);
        this.available = aAvailable;
    }

    public EPPRegistryCheckResult(EPPRegistryZoneName aName, Boolean aAvailable) {
        this.setName(aName);
        this.available = aAvailable;
    }

    public EPPRegistryCheckResult(String aName, Boolean aAvailable, String aReason) {
        this.setName(aName);
        this.available = aAvailable;
        this.reason = aReason;
    }

    public EPPRegistryCheckResult(EPPRegistryZoneName aName, Boolean aAvailable, String aReason) {
        this.setName(aName);
        this.available = aAvailable;
        this.reason = aReason;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.name == null) {
            throw new EPPEncodeException("Zone name required element is not set");
        }
        if (this.available == null) {
            throw new EPPEncodeException("Zone available required attribute is not set");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.2", ELM_NAME);
        Element nameElm = this.name.encode(aDocument);
        root.appendChild(nameElm);
        EPPUtil.encodeBooleanAttr(nameElm, ATTR_AVAIL, this.available);
        if (this.reason != null) {
            Element reasonElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.2", "registry:reason");
            root.appendChild(reasonElm);
            if (!this.language.equals(VALUE_LANG)) {
                reasonElm.setAttribute(ATTR_LANG, this.language);
            }
            Text aReason = aDocument.createTextNode(this.reason);
            reasonElm.appendChild(aReason);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        Element theNameElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", "name");
        this.name = new EPPRegistryZoneName();
        this.name.decode(theNameElm);
        this.available = EPPUtil.decodeBooleanAttr(theNameElm, ATTR_AVAIL);
        Element theReasonElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", ELM_REGISTRY_REASON);
        if (theReasonElm != null) {
            this.reason = theReasonElm.getFirstChild().getNodeValue();
            String theLang = theReasonElm.getAttribute(ATTR_LANG);
            if (theLang.length() > 0 && !theLang.equals(VALUE_LANG)) {
                this.setLanguage(theLang);
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryCheckResult clone = null;
        clone = (EPPRegistryCheckResult)super.clone();
        if (this.name != null) {
            clone.name = (EPPRegistryZoneName)this.name.clone();
        }
        return clone;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryCheckResult)) {
            return false;
        }
        EPPRegistryCheckResult theComp = (EPPRegistryCheckResult)aObject;
        if (!EqualityUtil.equals(this.name, theComp.name)) {
            cat.error((Object)"EPPRegistryCheckResult.equals(): name not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.available, theComp.available)) {
            cat.error((Object)"EPPRegistryCheckResult.equals(): available not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.language, theComp.language)) {
            cat.error((Object)"EPPRegistryCheckResult.equals(): language not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.reason, theComp.reason)) {
            cat.error((Object)"EPPRegistryCheckResult.equals(): reason not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String aLanguage) {
        this.language = aLanguage;
    }

    public EPPRegistryZoneName getName() {
        return this.name;
    }

    public void setName(EPPRegistryZoneName aName) {
        this.name = aName;
    }

    public void setName(String aName) {
        this.name = new EPPRegistryZoneName(aName, EPPRegistryZoneName.Form.aLabel);
    }

    public Boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(Boolean aAvailable) {
        this.available = aAvailable;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String aReason) {
        this.reason = aReason;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:registry-0.2";
    }
}

