/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v02;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EqualityUtil;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class EPPRegistryAbstractMinMax
implements EPPCodecComponent {
    protected static final String ELM_MIN_LENGTH = "minLength";
    protected static final String ELM_MAX_LENGTH = "maxLength";
    protected static final String ELM_MIN = "min";
    protected static final String ELM_MAX = "max";
    private Integer min = null;
    private Integer max = null;

    protected abstract String getRootName();

    protected abstract String getElmMin();

    protected abstract String getElmMax();

    protected abstract Logger getLogger();

    public EPPRegistryAbstractMinMax() {
    }

    public EPPRegistryAbstractMinMax(Integer aMin, Integer aMax) {
        this();
        this.min = aMin;
        this.max = aMax;
    }

    public EPPRegistryAbstractMinMax(int aMin, int aMax) {
        this((Integer)aMin, (Integer)aMax);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        this.validateState();
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.2", "registry:" + this.getRootName());
        EPPUtil.encodeString(aDocument, root, this.min.toString(), "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:" + this.getElmMin());
        if (this.max != null) {
            EPPUtil.encodeString(aDocument, root, this.max.toString(), "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:" + this.getElmMax());
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.min = EPPUtil.decodeInteger(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", this.getElmMin());
        this.max = EPPUtil.decodeInteger(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", this.getElmMax());
    }

    protected void validateState() throws EPPEncodeException {
        if (this.min == null || this.min < 0) {
            throw new EPPEncodeException("Invalid state on " + this.getClass().getName() + ".encode: min is required and should be greater than or equal to 0");
        }
        if (this.max != null && this.max < this.min) {
            throw new EPPEncodeException("Invalid state on " + this.getClass().getName() + ".encode: max is required and should be greater than min");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryAbstractMinMax)) {
            return false;
        }
        EPPRegistryAbstractMinMax theComp = (EPPRegistryAbstractMinMax)aObject;
        if (!EqualityUtil.equals(this.min, theComp.min)) {
            this.getLogger().error((Object)"EPPRegistryAbstractMinMax.equals(): min not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.max, theComp.max)) {
            this.getLogger().error((Object)"EPPRegistryAbstractMinMax.equals(): max not equal");
            return false;
        }
        return true;
    }

    public Integer getMin() {
        return this.min;
    }

    public void setMin(Integer aMin) {
        this.min = aMin;
    }

    public Integer getMax() {
        return this.max;
    }

    public void setMax(Integer aMax) {
        this.max = aMax;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:registry-0.2";
    }

    public String toString() {
        return EPPUtil.toString(this);
    }
}

