/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v01;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPRegistryZoneName
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPRegistryZoneName.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private String elmRootLocalName = "name";
    public static final String ELM_ZONE_NAME = "name";
    public static final String ELM_ZONE = "zone";
    public static final String ATTR_FORM = "form";
    private String name;
    private Form form = Form.aLabel;

    public EPPRegistryZoneName() {
    }

    public EPPRegistryZoneName(String aName) {
        this.name = aName;
    }

    public EPPRegistryZoneName(String aName, Form aForm) {
        this.name = aName;
        this.form = aForm;
    }

    void validateState() throws EPPCodecException {
        if (this.elmRootLocalName == null) {
            throw new EPPCodecException("elmRootLocalName required attribute is not set");
        }
        if (this.name == null) {
            throw new EPPCodecException("name required attribute is not set");
        }
        if (this.form == null) {
            throw new EPPCodecException("form required attribute is not set");
        }
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error((Object)(this.getClass().getName() + ".encode(): Invalid state on encode: " + e));
            throw new EPPEncodeException("Invalid state on " + this.getClass().getName() + ".encode(): " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.1", "registry:" + this.elmRootLocalName);
        Text theNameText = aDocument.createTextNode(this.name);
        root.appendChild(theNameText);
        root.setAttribute(ATTR_FORM, this.form.toString());
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.elmRootLocalName = aElement.getLocalName();
        this.name = EPPUtil.decodeStringValue(aElement);
        String theFormStr = aElement.getAttribute(ATTR_FORM);
        this.form = theFormStr == null ? Form.aLabel : Form.valueOf(theFormStr);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryZoneName)) {
            return false;
        }
        EPPRegistryZoneName theComp = (EPPRegistryZoneName)aObject;
        if (!EqualityUtil.equals(this.elmRootLocalName, theComp.elmRootLocalName)) {
            cat.error((Object)"EPPRegistryZoneName.equals(): elmRootLocalName not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.name, theComp.name)) {
            cat.error((Object)"EPPRegistryZoneName.equals(): name not equal");
            return false;
        }
        if (!EqualityUtil.equals((Object)this.form, (Object)theComp.form)) {
            cat.error((Object)"EPPRegistryZoneName.equals(): form not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryZoneName clone = (EPPRegistryZoneName)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public String getRootName() {
        return this.elmRootLocalName;
    }

    public void setRootName(String aRootName) {
        this.elmRootLocalName = aRootName == null ? ELM_ZONE_NAME : aRootName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public Form getForm() {
        return this.form;
    }

    public void setForm(Form aForm) {
        this.form = aForm;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:registry-0.1";
    }

    public static enum Form {
        aLabel,
        uLabel;

    }
}

