/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v01;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.v01.EPPRegistryExternalHost;
import com.verisign.epp.codec.registry.v01.EPPRegistryInternalHost;
import com.verisign.epp.codec.registry.v01.EPPRegistryRegex;
import com.verisign.epp.codec.registry.v01.EPPRegistrySupportedStatus;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryHost
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPRegistryHost.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "host";
    public static final String ELM_NAME = "registry:host";
    public static final String ELM_REGEX = "nameRegex";
    public static final String ELM_MAX_CHECK = "maxCheckHost";
    public static final String ELM_AUTH_INFO_REGEX = "authInfoRegex";
    private EPPRegistryInternalHost internal = null;
    private EPPRegistryExternalHost external = null;
    private List nameRegex = new ArrayList();
    private Integer maxCheckHost = null;
    private EPPRegistrySupportedStatus supportedStatus = null;

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPRegistryHost.encode: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.1", ELM_NAME);
        EPPUtil.encodeComp(aDocument, root, this.internal);
        EPPUtil.encodeComp(aDocument, root, this.external);
        if (this.nameRegex != null && this.nameRegex.size() > 0) {
            EPPUtil.encodeCompList(aDocument, root, this.nameRegex);
        }
        EPPUtil.encodeString(aDocument, root, this.maxCheckHost.toString(), "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:maxCheckHost");
        if (this.supportedStatus != null) {
            EPPUtil.encodeComp(aDocument, root, this.supportedStatus);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.internal = (EPPRegistryInternalHost)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:internal", EPPRegistryInternalHost.class);
        this.external = (EPPRegistryExternalHost)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:external", EPPRegistryExternalHost.class);
        this.setNameRegex(EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_REGEX, EPPRegistryRegex.class));
        this.maxCheckHost = EPPUtil.decodeInteger(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_MAX_CHECK);
        this.supportedStatus = (EPPRegistrySupportedStatus)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:supportedStatus", EPPRegistrySupportedStatus.class);
    }

    void validateState() throws EPPCodecException {
        if (this.internal == null) {
            throw new EPPCodecException("internal required element is not set");
        }
        if (this.external == null) {
            throw new EPPCodecException("external required element is not set");
        }
        if (this.maxCheckHost == null || this.maxCheckHost <= 0) {
            throw new EPPCodecException("maxCheckHost is required and should be greater than 0");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryHost clone = (EPPRegistryHost)super.clone();
        if (this.internal != null) {
            clone.internal = (EPPRegistryInternalHost)this.internal.clone();
        }
        if (this.external != null) {
            clone.external = (EPPRegistryExternalHost)this.external.clone();
        }
        if (this.nameRegex != null) {
            clone.nameRegex = (List)((ArrayList)this.nameRegex).clone();
        }
        if (this.supportedStatus != null) {
            clone.supportedStatus = (EPPRegistrySupportedStatus)this.supportedStatus.clone();
        }
        return clone;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryHost)) {
            return false;
        }
        EPPRegistryHost theComp = (EPPRegistryHost)aObject;
        if (!EqualityUtil.equals(this.internal, theComp.internal)) {
            cat.error((Object)"EPPRegistryHost.equals(): internal not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.external, theComp.external)) {
            cat.error((Object)"EPPRegistryHost.equals(): external not equal");
            return false;
        }
        if (!(this.nameRegex != null ? EPPUtil.equalLists(this.nameRegex, theComp.nameRegex) : theComp.nameRegex == null)) {
            cat.error((Object)"EPPRegistryHost.equals(): nameRegex not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.maxCheckHost, theComp.maxCheckHost)) {
            cat.error((Object)"EPPRegistryHost.equals(): maxCheckHost not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.maxCheckHost, theComp.maxCheckHost)) {
            cat.error((Object)"EPPRegistryHost.equals(): maxCheckHost not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.supportedStatus, theComp.supportedStatus)) {
            cat.error((Object)"EPPRegistryHost.equals(): supportedStatus not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public EPPRegistryInternalHost getInternal() {
        return this.internal;
    }

    public void setInternal(EPPRegistryInternalHost aInternal) {
        this.internal = aInternal;
    }

    public EPPRegistryExternalHost getExternal() {
        return this.external;
    }

    public void setExternal(EPPRegistryExternalHost aExternal) {
        this.external = aExternal;
    }

    public List getNameRegex() {
        return this.nameRegex;
    }

    public void setNameRegex(List aNameRegex) {
        if (aNameRegex != null) {
            for (EPPRegistryRegex regex : aNameRegex) {
                if (regex == null) continue;
                regex.setRootName(ELM_REGEX);
            }
        }
        this.nameRegex = aNameRegex;
    }

    public void addNameRegex(EPPRegistryRegex aRegex) {
        if (aRegex == null) {
            return;
        }
        aRegex.setRootName(ELM_REGEX);
        if (this.nameRegex == null) {
            this.nameRegex = new ArrayList();
        }
        this.nameRegex.add(aRegex);
    }

    public Integer getMaxCheckHost() {
        return this.maxCheckHost;
    }

    public void setMaxCheckHost(Integer aMaxCheckHost) {
        this.maxCheckHost = aMaxCheckHost;
    }

    public EPPRegistrySupportedStatus getSupportedStatus() {
        return this.supportedStatus;
    }

    public void setSupportedStatus(EPPRegistrySupportedStatus aSupportedStatus) {
        this.supportedStatus = aSupportedStatus;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:registry-0.1";
    }
}

