/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v01;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.v01.EPPRegistryKey;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryDS
extends EPPRegistryKey {
    private static Logger cat = Logger.getLogger(EPPRegistryDS.class);
    public static final String ELM_LOCALNAME = "dsDataInterface";
    public static final String ELM_NAME = "registry:dsDataInterface";
    public static final String ELM_DIGEST = "digestType";
    private List<String> digestTypes = new ArrayList<String>();

    public EPPRegistryDS() {
    }

    public EPPRegistryDS(Integer aMin, Integer aMax, List<String> aAlgorithms, List<String> aDigestTypes) {
        super(aMin, aMax, aAlgorithms);
        this.digestTypes = aDigestTypes;
    }

    public EPPRegistryDS(int aMin, int aMax, List<String> aAlgorithms, List<String> aDigestTypes) {
        this((Integer)aMin, (Integer)aMax, aAlgorithms, aDigestTypes);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root = super.encode(aDocument);
        if (this.digestTypes != null && this.digestTypes.size() > 0) {
            EPPUtil.encodeList(aDocument, root, this.digestTypes, "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:digestType");
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        super.decode(aElement);
        this.digestTypes = EPPUtil.decodeList(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_DIGEST);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryDS clone = (EPPRegistryDS)super.clone();
        if (this.digestTypes != null) {
            clone.digestTypes = (List)((ArrayList)this.digestTypes).clone();
        }
        return clone;
    }

    @Override
    public boolean equals(Object aObject) {
        if (!super.equals(aObject)) {
            return false;
        }
        if (!(aObject instanceof EPPRegistryDS)) {
            return false;
        }
        EPPRegistryDS theComp = (EPPRegistryDS)aObject;
        if (!(this.digestTypes != null ? EPPUtil.equalLists(this.digestTypes, theComp.digestTypes) : theComp.digestTypes == null)) {
            cat.error((Object)"EPPRegistryDS.equals(): digestTypes not equal");
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public List<String> getDigestTypes() {
        return this.digestTypes;
    }

    public void setDigestTypes(List<String> aDigestTypes) {
        this.digestTypes = aDigestTypes == null ? new ArrayList<String>() : aDigestTypes;
    }

    public void addDigestType(String digestType) {
        if (this.digestTypes == null) {
            this.digestTypes = new ArrayList<String>();
        }
        this.digestTypes.add(digestType);
    }

    @Override
    protected String getRootName() {
        return ELM_LOCALNAME;
    }
}

