/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v01;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.v01.EPPRegistryPostal;
import com.verisign.epp.codec.registry.v01.EPPRegistryRegex;
import com.verisign.epp.codec.registry.v01.EPPRegistrySupportedStatus;
import com.verisign.epp.codec.registry.v01.EPPRegistryTransferHoldPeriodType;
import com.verisign.epp.util.EqualityUtil;
import java.security.InvalidParameterException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryContact
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger(EPPRegistryContact.class);
    public static final String ELM_LOCALNAME = "contact";
    public static final String ELM_NAME = "registry:contact";
    public static final String ELM_CONTACT_ID_REGEX = "contactIdRegex";
    public static final String ELM_SHARE_POLICY = "sharePolicy";
    public static final String ELM_POSTAL_INFO_TYPE_SUPPORT = "postalInfoTypeSupport";
    public static final String ELM_MAX_CHECK = "maxCheckContact";
    public static final String ELM_AUTH_INFO_REGEX = "authInfoRegex";
    public static final String ELM_CUSTOM_DATA = "customData";
    public static final String ELM_CUSTOM_CLIENT_DISCLOSURE_SUPPORTED = "clientDisclosureSupported";
    private EPPRegistryRegex contactIdRegex = null;
    private SharePolicy sharePolicy = null;
    private PostalInfoTypeSupport postalInfoTypeSupport = null;
    private EPPRegistryPostal postalInfo = null;
    private Integer maxCheckContact = null;
    private EPPRegistryRegex authInfoRegex = null;
    private Boolean clientDisclosureSupported = Boolean.FALSE;
    private EPPRegistryTransferHoldPeriodType transferHoldPeriod = null;
    private EPPRegistrySupportedStatus supportedStatus = null;

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPRegistryContact.encode: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.1", ELM_NAME);
        EPPUtil.encodeComp(aDocument, root, this.contactIdRegex);
        if (this.hasSharePolicy()) {
            EPPUtil.encodeString(aDocument, root, this.sharePolicy.toString(), "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:sharePolicy");
        }
        EPPUtil.encodeString(aDocument, root, this.postalInfoTypeSupport.toString(), "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:postalInfoTypeSupport");
        EPPUtil.encodeComp(aDocument, root, this.postalInfo);
        EPPUtil.encodeString(aDocument, root, this.maxCheckContact.toString(), "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:maxCheckContact");
        if (this.authInfoRegex != null) {
            EPPUtil.encodeComp(aDocument, root, this.authInfoRegex);
        }
        if (this.clientDisclosureSupported == null) {
            this.clientDisclosureSupported = Boolean.FALSE;
        }
        EPPUtil.encodeString(aDocument, root, this.clientDisclosureSupported.toString(), "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:clientDisclosureSupported");
        if (this.supportedStatus != null) {
            EPPUtil.encodeComp(aDocument, root, this.supportedStatus);
        }
        EPPUtil.encodeComp(aDocument, root, this.transferHoldPeriod);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.setContactIdRegex((EPPRegistryRegex)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_CONTACT_ID_REGEX, EPPRegistryRegex.class));
        String theSharePolicyStr = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_SHARE_POLICY);
        this.sharePolicy = theSharePolicyStr == null ? null : SharePolicy.valueOf(theSharePolicyStr);
        this.postalInfoTypeSupport = PostalInfoTypeSupport.getSupport(EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_POSTAL_INFO_TYPE_SUPPORT));
        this.postalInfo = (EPPRegistryPostal)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:postalInfo", EPPRegistryPostal.class);
        this.maxCheckContact = EPPUtil.decodeInteger(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_MAX_CHECK);
        this.setAuthInfoRegex((EPPRegistryRegex)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_AUTH_INFO_REGEX, EPPRegistryRegex.class));
        this.clientDisclosureSupported = EPPUtil.decodeBoolean(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_CUSTOM_CLIENT_DISCLOSURE_SUPPORTED);
        if (this.clientDisclosureSupported == null) {
            this.clientDisclosureSupported = Boolean.FALSE;
        }
        this.supportedStatus = (EPPRegistrySupportedStatus)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:supportedStatus", EPPRegistrySupportedStatus.class);
        this.transferHoldPeriod = (EPPRegistryTransferHoldPeriodType)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", "transferHoldPeriod", EPPRegistryTransferHoldPeriodType.class);
    }

    void validateState() throws EPPCodecException {
        if (this.postalInfoTypeSupport == null) {
            throw new EPPCodecException("postalInfoTypeSupport required element is not set");
        }
        if (this.postalInfo == null) {
            throw new EPPCodecException("postalInfo required element is not set");
        }
        if (this.maxCheckContact == null || this.maxCheckContact <= 0) {
            throw new EPPCodecException("maxCheckContact is required and should be greater than 0");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryContact clone = (EPPRegistryContact)super.clone();
        if (this.contactIdRegex != null) {
            clone.contactIdRegex = (EPPRegistryRegex)this.contactIdRegex.clone();
        }
        if (this.authInfoRegex != null) {
            clone.authInfoRegex = (EPPRegistryRegex)this.authInfoRegex.clone();
        }
        if (this.supportedStatus != null) {
            clone.supportedStatus = (EPPRegistrySupportedStatus)this.supportedStatus.clone();
        }
        if (this.transferHoldPeriod != null) {
            clone.transferHoldPeriod = (EPPRegistryTransferHoldPeriodType)this.transferHoldPeriod.clone();
        }
        return clone;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryContact)) {
            return false;
        }
        EPPRegistryContact other = (EPPRegistryContact)aObject;
        if (!EqualityUtil.equals(this.contactIdRegex, other.contactIdRegex)) {
            cat.error((Object)"EPPRegistryContact.equals(): contactIdRegex not equal");
            return false;
        }
        if (!EqualityUtil.equals((Object)this.sharePolicy, (Object)other.sharePolicy)) {
            cat.error((Object)"EPPRegistryContact.equals(): sharePolicy not equal");
            return false;
        }
        if (!EqualityUtil.equals((Object)this.postalInfoTypeSupport, (Object)other.postalInfoTypeSupport)) {
            cat.error((Object)"EPPRegistryContact.equals(): postalInfoTypeSupport not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.postalInfo, other.postalInfo)) {
            cat.error((Object)"EPPRegistryContact.equals(): postalInfo not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.maxCheckContact, other.maxCheckContact)) {
            cat.error((Object)"EPPRegistryContact.equals(): maxCheckContact not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.authInfoRegex, other.authInfoRegex)) {
            cat.error((Object)"EPPRegistryContact.equals(): authInfoRegex not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.supportedStatus, other.supportedStatus)) {
            cat.error((Object)"EPPRegistryContact.equals(): supportedStatus not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.transferHoldPeriod, other.transferHoldPeriod)) {
            cat.error((Object)"EPPRegistryContact.equals(): transferHoldPeriod not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public EPPRegistryRegex getContactIdRegex() {
        return this.contactIdRegex;
    }

    public void setContactIdRegex(EPPRegistryRegex aContactIdRegex) {
        if (aContactIdRegex != null) {
            aContactIdRegex.setRootName(ELM_CONTACT_ID_REGEX);
        }
        this.contactIdRegex = aContactIdRegex;
    }

    public boolean hasSharePolicy() {
        return this.sharePolicy != null;
    }

    public SharePolicy getSharePolicy() {
        return this.sharePolicy;
    }

    public void setSharePolicy(SharePolicy aSharePolicy) {
        this.sharePolicy = aSharePolicy;
    }

    public PostalInfoTypeSupport getPostalInfoTypeSupport() {
        return this.postalInfoTypeSupport;
    }

    public void setIntPostalInfoTypeSupport(PostalInfoTypeSupport aPostalInfoTypeSupport) {
        this.postalInfoTypeSupport = aPostalInfoTypeSupport;
    }

    public Integer getMaxCheckContact() {
        return this.maxCheckContact;
    }

    public void setMaxCheckContact(Integer maxCheckContact) {
        this.maxCheckContact = maxCheckContact;
    }

    public EPPRegistryRegex getAuthInfoRegex() {
        return this.authInfoRegex;
    }

    public void setAuthInfoRegex(EPPRegistryRegex authInfoRegex) {
        if (authInfoRegex != null) {
            authInfoRegex.setRootName(ELM_AUTH_INFO_REGEX);
        }
        this.authInfoRegex = authInfoRegex;
    }

    public EPPRegistryPostal getPostalInfo() {
        return this.postalInfo;
    }

    public void setPostalInfo(EPPRegistryPostal postalInfo) {
        this.postalInfo = postalInfo;
    }

    public Boolean getClientDisclosureSupported() {
        return this.clientDisclosureSupported;
    }

    public void setClientDisclosureSupported(Boolean clientDisclosureSupported) {
        this.clientDisclosureSupported = clientDisclosureSupported;
    }

    public EPPRegistrySupportedStatus getSupportedStatus() {
        return this.supportedStatus;
    }

    public void setSupportedStatus(EPPRegistrySupportedStatus supportedStatus) {
        this.supportedStatus = supportedStatus;
    }

    public EPPRegistryTransferHoldPeriodType getTransferHoldPeriod() {
        return this.transferHoldPeriod;
    }

    public void setTransferHoldPeriod(EPPRegistryTransferHoldPeriodType transferHoldPeriod) {
        this.transferHoldPeriod = transferHoldPeriod;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:registry-0.1";
    }

    public static enum PostalInfoTypeSupport {
        locSupport("loc"),
        intSupport("int"),
        locOrIntSupport("locOrInt"),
        locAndIntSupport("locAndInt");

        private final String supportStr;

        private PostalInfoTypeSupport(String aSupportStr) {
            this.supportStr = aSupportStr;
        }

        public static PostalInfoTypeSupport getSupport(String aSupportStr) {
            if (aSupportStr == null) {
                throw new InvalidParameterException("null PostalInfoTypeSupport enum value is not valid.");
            }
            if (aSupportStr.equals(PostalInfoTypeSupport.locSupport.supportStr)) {
                return locSupport;
            }
            if (aSupportStr.equals(PostalInfoTypeSupport.intSupport.supportStr)) {
                return intSupport;
            }
            if (aSupportStr.equals(PostalInfoTypeSupport.locOrIntSupport.supportStr)) {
                return locOrIntSupport;
            }
            if (aSupportStr.equals(PostalInfoTypeSupport.locAndIntSupport.supportStr)) {
                return locAndIntSupport;
            }
            throw new InvalidParameterException("PostalInfoTypeSupport enum value of " + aSupportStr + " is not valid.");
        }

        public String toString() {
            return this.supportStr;
        }
    }

    public static enum SharePolicy {
        perZone,
        perSystem;

    }
}

