/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v01;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class EPPRegistryBatchJob
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPRegistryBatchJob.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String DEFAULT_SCHEDULE_TZ = "UTC";
    public static final String ELM_LOCALNAME = "batchJob";
    public static final String ELM_NAME = "registry:batchJob";
    static final String ELM_JOB_NAME = "name";
    static final String ELM_DESCRIPTION = "description";
    static final String ELM_SCHEDULE = "schedule";
    static final String ATTR_TZ = "tz";
    private String name = null;
    private String description = null;
    private String schedule = null;
    private String scheduleTimeZone = "UTC";

    public EPPRegistryBatchJob() {
    }

    public EPPRegistryBatchJob(String aName, String aSchedule) {
        this.name = aName;
        this.schedule = aSchedule;
    }

    public EPPRegistryBatchJob(String aName, String aSchedule, String aDescription) {
        this(aName, aSchedule);
        this.description = aDescription;
    }

    public EPPRegistryBatchJob(String aName, String aSchedule, String aDescription, String aScheduleTimeZone) {
        this(aName, aSchedule, aDescription);
        this.setScheduleTimeZone(aScheduleTimeZone);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.name == null) {
            throw new EPPEncodeException("EPPRegistryBatchJob name is null");
        }
        if (this.schedule == null) {
            throw new EPPEncodeException("EPPRegistryBatchJob schedule is null");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.1", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.name, "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:name");
        if (this.description != null) {
            EPPUtil.encodeString(aDocument, root, this.description, "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:description");
        }
        Element theScheduleElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.1", "registry:schedule");
        Text theScheduleText = aDocument.createTextNode(String.valueOf(this.schedule));
        theScheduleElm.appendChild(theScheduleText);
        root.appendChild(theScheduleElm);
        theScheduleElm.setAttribute(ATTR_TZ, this.scheduleTimeZone);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.name = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_JOB_NAME);
        this.description = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_DESCRIPTION);
        Element theScheduleElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_SCHEDULE);
        Node theScheduleText = theScheduleElm.getFirstChild();
        if (theScheduleText != null) {
            this.schedule = theScheduleText.getNodeValue();
        }
        this.setScheduleTimeZone(theScheduleElm.getAttribute(ATTR_TZ));
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryBatchJob)) {
            return false;
        }
        EPPRegistryBatchJob theComp = (EPPRegistryBatchJob)aObject;
        if (!EqualityUtil.equals(this.name, theComp.name)) {
            cat.error((Object)"EPPRegistryBatchJob.equals(): name not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.description, theComp.description)) {
            cat.error((Object)"EPPRegistryBatchJob.equals(): description not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.schedule, theComp.schedule)) {
            cat.error((Object)"EPPRegistryBatchJob.equals(): schedule not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.scheduleTimeZone, theComp.scheduleTimeZone)) {
            cat.error((Object)"EPPRegistryBatchJob.equals(): scheduleTimeZone not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String aDescription) {
        this.description = aDescription;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public void setSchedule(String aSchedule) {
        this.schedule = aSchedule;
    }

    public String getScheduleTimeZone() {
        return this.scheduleTimeZone;
    }

    public void setScheduleTimeZone(String aScheduleTimeZone) {
        this.scheduleTimeZone = aScheduleTimeZone == null ? DEFAULT_SCHEDULE_TZ : aScheduleTimeZone;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:registry-0.1";
    }
}

