/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistrySupportedStatus
implements EPPCodecComponent {
    private static final long serialVersionUID = 8543267756169534269L;
    public static final String ELM_NAME = "registry:supportedStatus";
    public static final String ELM_NAME_STATUS = "registry:status";
    private List statuses = new ArrayList();

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPRegistrySupportedStatus.encode: " + e);
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", ELM_NAME);
        EPPUtil.encodeList(aDocument, root, this.statuses, "http://www.verisign.com/epp/registry-1.0", ELM_NAME_STATUS);
        return root;
    }

    void validateState() throws EPPCodecException {
        if (this.statuses == null || this.statuses.size() <= 0) {
            throw new EPPCodecException("statuses is required");
        }
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.statuses = EPPUtil.decodeList(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_NAME_STATUS);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistrySupportedStatus clone = (EPPRegistrySupportedStatus)super.clone();
        if (this.statuses != null) {
            clone.statuses = (List)((ArrayList)this.statuses).clone();
        }
        return clone;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistrySupportedStatus)) {
            return false;
        }
        EPPRegistrySupportedStatus theComp = (EPPRegistrySupportedStatus)aObject;
        return this.statuses != null ? EPPUtil.equalLists(this.statuses, theComp.statuses) : theComp.statuses == null;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public List getStatuses() {
        return this.statuses;
    }

    public void setStatuses(List statuses) {
        this.statuses = statuses;
    }

    public void addStatus(String status) {
        if (this.statuses == null) {
            this.statuses = new ArrayList();
        }
        this.statuses.add(status);
    }

    @Override
    public String getNamespace() {
        return "http://www.verisign.com/epp/registry-1.0";
    }

    public class Status {
        public static final String DOMAIN_CLIENTDELETEPROHIBITED = "clientDeleteProhibited";
        public static final String DOMAIN_SERVERDELETEPROHIBITED = "serverDeleteProhibited";
        public static final String DOMAIN_CLIENTHOLD = "clientHold";
        public static final String DOMAIN_SERVERHOLD = "serverHold";
        public static final String DOMAIN_CLIENTRENEWPROHIBITED = "clientRenewProhibited";
        public static final String DOMAIN_SERVERRENEWPROHIBITED = "serverRenewProhibited";
        public static final String DOMAIN_CLIENTTRANSFERPROHIBITED = "clientTransferProhibited";
        public static final String DOMAIN_SERVERTRANSFERPROHIBITED = "serverTransferProhibited";
        public static final String DOMAIN_CLIENTUPDATEPROHIBITED = "clientUpdateProhibited";
        public static final String DOMAIN_SERVERUPDATEPROHIBITED = "serverUpdateProhibited";
        public static final String DOMAIN_INACTIVE = "inactive";
        public static final String DOMAIN_OK = "ok";
        public static final String DOMAIN_PENDINGCREATE = "pendingCreate";
        public static final String DOMAIN_PENDINGDELETE = "pendingDelete";
        public static final String DOMAIN_PENDINGRENEW = "pendingRenew";
        public static final String DOMAIN_PENDINGTRANSFER = "pendingTransfer";
        public static final String DOMAIN_PENDINGUPDATE = "pendingUpdate";
        public static final String HOST_CLIENTDELETEPROHIBITED = "clientDeleteProhibited";
        public static final String HOST_SERVERDELETEPROHIBITED = "serverDeleteProhibited";
        public static final String HOST_CLIENTUPDATEPROHIBITED = "clientUpdateProhibited";
        public static final String HOST_SERVERUPDATEPROHIBITED = "serverUpdateProhibited";
        public static final String HOST_LINKED = "linked";
        public static final String HOST_OK = "ok";
        public static final String HOST_PENDINGCREATE = "pendingCreate";
        public static final String HOST_PENDINGDELETE = "pendingDelete";
        public static final String HOST_PENDINGTRANSFER = "pendingTransfer";
        public static final String HOST_PENDINGUPDATE = "pendingUpdate";
        public static final String CONTACT_CLIENTDELETEPROHIBITED = "clientDeleteProhibited";
        public static final String CONTACT_SERVERDELETEPROHIBITED = "serverDeleteProhibited";
        public static final String CONTACT_CLIENTTRANSFERPROHIBITED = "clientTransferProhibited";
        public static final String CONTACT_SERVERTRANSFERPROHIBITED = "serverTransferProhibited";
        public static final String CONTACT_CLIENTUPDATEPROHIBITED = "clientUpdateProhibited";
        public static final String CONTACT_SERVERUPDATEPROHIBITED = "serverUpdateProhibited";
        public static final String CONTACT_LINKED = "linked";
        public static final String CONTACT_OK = "ok";
        public static final String CONTACT_PENDINGCREATE = "pendingCreate";
        public static final String CONTACT_PENDINGDELETE = "pendingDelete";
        public static final String CONTACT_PENDINGTRANSFER = "pendingTransfer";
        public static final String CONTACT_PENDINGUPDATE = "pendingUpdate";
    }
}

