/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.EPPRegistryDefaultPeriodType;
import com.verisign.epp.codec.registry.EPPRegistryMaxPeriodType;
import com.verisign.epp.codec.registry.EPPRegistryMinPeriodType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryMinMaxPeriod
implements EPPCodecComponent {
    private static final long serialVersionUID = -3291192948356470780L;
    public static final String ELM_NAME = "registry:length";
    private EPPRegistryMinPeriodType min;
    private EPPRegistryMaxPeriodType max;
    private EPPRegistryDefaultPeriodType defaultLength;
    private String rootName = "registry:length";

    public EPPRegistryMinMaxPeriod() {
    }

    public EPPRegistryMinMaxPeriod(Integer lMin, String uMin, Integer lMax, String uMax, Integer lDefault, String uDefault) {
        this();
        this.min = new EPPRegistryMinPeriodType(lMin, uMin);
        this.max = new EPPRegistryMaxPeriodType(lMax, uMax);
        this.defaultLength = new EPPRegistryDefaultPeriodType(lDefault, uDefault);
    }

    public EPPRegistryMinMaxPeriod(int min, String minUnit, int max, String maxUnit, int defaultLength, String defaultLengthUnit) {
        this((Integer)min, minUnit, (Integer)max, maxUnit, (Integer)defaultLength, defaultLengthUnit);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPRegistryMinMaxPeriod.encode: " + e);
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", this.getRootName());
        EPPUtil.encodeComp(aDocument, root, this.min);
        EPPUtil.encodeComp(aDocument, root, this.max);
        EPPUtil.encodeComp(aDocument, root, this.defaultLength);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.setMin((EPPRegistryMinPeriodType)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:min", EPPRegistryMinPeriodType.class));
        this.setMax((EPPRegistryMaxPeriodType)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:max", EPPRegistryMaxPeriodType.class));
        this.setDefaultLength((EPPRegistryDefaultPeriodType)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:default", EPPRegistryDefaultPeriodType.class));
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryMinMaxPeriod clone = (EPPRegistryMinMaxPeriod)super.clone();
        if (this.min != null) {
            clone.min = (EPPRegistryMinPeriodType)this.min.clone();
        }
        if (this.max != null) {
            clone.max = (EPPRegistryMaxPeriodType)this.max.clone();
        }
        if (this.defaultLength != null) {
            clone.defaultLength = (EPPRegistryDefaultPeriodType)this.defaultLength.clone();
        }
        return clone;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryMinMaxPeriod)) {
            return false;
        }
        EPPRegistryMinMaxPeriod theComp = (EPPRegistryMinMaxPeriod)aObject;
        if (!(this.min != null ? this.min.equals(theComp.min) : theComp.min == null)) {
            return false;
        }
        if (!(this.max != null ? this.max.equals(theComp.max) : theComp.max == null)) {
            return false;
        }
        if (!(this.defaultLength != null ? this.defaultLength.equals(theComp.defaultLength) : theComp.defaultLength == null)) {
            return false;
        }
        return this.rootName != null ? this.rootName.equals(theComp.rootName) : theComp.rootName == null;
    }

    void validateState() throws EPPCodecException {
        if (this.rootName == null || this.rootName.trim().length() == 0) {
            throw new EPPCodecException("rootName is not set");
        }
        if (this.min == null) {
            throw new EPPCodecException("min element is not set");
        }
        this.min.validateState();
        if (this.max == null) {
            throw new EPPCodecException("max element is not set");
        }
        this.max.validateState();
        if (this.defaultLength == null) {
            throw new EPPCodecException("defaultLength element is not set");
        }
        this.defaultLength.validateState();
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public EPPRegistryMinPeriodType getMin() {
        return this.min;
    }

    public void setMin(EPPRegistryMinPeriodType min) {
        this.min = min;
    }

    public EPPRegistryMaxPeriodType getMax() {
        return this.max;
    }

    public void setMax(EPPRegistryMaxPeriodType max) {
        this.max = max;
    }

    public String getRootName() {
        return this.rootName;
    }

    public void setRootName(String rootName) {
        this.rootName = rootName;
    }

    public EPPRegistryDefaultPeriodType getDefaultLength() {
        return this.defaultLength;
    }

    public void setDefaultLength(EPPRegistryDefaultPeriodType defaultLength) {
        this.defaultLength = defaultLength;
    }

    @Override
    public String getNamespace() {
        return "http://www.verisign.com/epp/registry-1.0";
    }
}

