/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryMinMaxLength
implements EPPCodecComponent {
    private static final long serialVersionUID = -2336341337762947833L;
    public static final String ELM_MIN = "registry:min";
    public static final String ELM_MAX = "registry:max";
    public static final String ELM_MIN_LENGTH = "registry:minLength";
    public static final String ELM_MAX_LENGTH = "registry:maxLength";
    protected String elmMin = "registry:minLength";
    protected String elmMax = "registry:maxLength";
    protected Integer min = null;
    protected Integer max = null;
    protected String rootName = null;

    public EPPRegistryMinMaxLength() {
    }

    public EPPRegistryMinMaxLength(Integer min, Integer max) {
        this();
        this.min = min;
        this.max = max;
    }

    public EPPRegistryMinMaxLength(int min, int max) {
        this((Integer)min, (Integer)max);
    }

    public EPPRegistryMinMaxLength(String rootName, Integer min, Integer max) {
        this(min, max);
        this.rootName = rootName;
    }

    public EPPRegistryMinMaxLength(String rootName, int min, int max) {
        this(rootName, (Integer)min, (Integer)max);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.rootName == null) {
            throw new EPPEncodeException("Invalid state on " + this.getClass().getName() + ".encode: rootName is not set");
        }
        this.validateState();
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", this.getRootName());
        EPPUtil.encodeString(aDocument, root, this.min.toString(), "http://www.verisign.com/epp/registry-1.0", this.elmMin);
        if (this.max != null) {
            EPPUtil.encodeString(aDocument, root, this.max.toString(), "http://www.verisign.com/epp/registry-1.0", this.elmMax);
        }
        return root;
    }

    protected void validateState() throws EPPEncodeException {
        if (this.min == null || this.min < 0) {
            throw new EPPEncodeException("Invalid state on " + this.getClass().getName() + ".encode: min is required and should be greater than or equal to 0");
        }
        if (this.max != null && this.max < this.min) {
            throw new EPPEncodeException("Invalid state on " + this.getClass().getName() + ".encode: max is required and should be greater than min");
        }
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.min = EPPUtil.decodeInteger(aElement, "http://www.verisign.com/epp/registry-1.0", this.elmMin);
        this.max = EPPUtil.decodeInteger(aElement, "http://www.verisign.com/epp/registry-1.0", this.elmMax);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return (EPPRegistryMinMaxLength)super.clone();
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryMinMaxLength)) {
            return false;
        }
        EPPRegistryMinMaxLength theComp = (EPPRegistryMinMaxLength)aObject;
        if (!(this.elmMin != null ? this.elmMin.equals(theComp.elmMin) : theComp.elmMin == null)) {
            return false;
        }
        if (!(this.elmMax != null ? this.elmMax.equals(theComp.elmMax) : theComp.elmMax == null)) {
            return false;
        }
        if (!(this.min != null ? this.min.equals(theComp.min) : theComp.min == null)) {
            return false;
        }
        if (!(this.max != null ? this.max.equals(theComp.max) : theComp.max == null)) {
            return false;
        }
        return this.rootName != null ? this.rootName.equals(theComp.rootName) : theComp.rootName == null;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public Integer getMin() {
        return this.min;
    }

    public void setMin(Integer min) {
        this.min = min;
    }

    public Integer getMax() {
        return this.max;
    }

    public void setMax(Integer max) {
        this.max = max;
    }

    public String getRootName() {
        return this.rootName;
    }

    public void setRootName(String aRootName) {
        this.rootName = aRootName;
    }

    public String getElmMin() {
        return this.elmMin;
    }

    public void setElmMin(String elmMin) {
        this.elmMin = elmMin;
    }

    public String getElmMax() {
        return this.elmMax;
    }

    public void setElmMax(String elmMax) {
        this.elmMax = elmMax;
    }

    @Override
    public String getNamespace() {
        return "http://www.verisign.com/epp/registry-1.0";
    }
}

