/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryMaxSig
implements EPPCodecComponent {
    private static final long serialVersionUID = 4505254498272997391L;
    public static final String ELM_NAME = "registry:maxSigLife";
    public static final String ELM_CLIENT_DEFINED = "registry:clientDefined";
    public static final String ELM_DEFAULT = "registry:default";
    public static final String ELM_MIN = "registry:min";
    public static final String ELM_MAX = "registry:max";
    private Boolean clientDefined = Boolean.FALSE;
    private Integer defaultLife;
    private Integer min = null;
    private Integer max = null;

    public EPPRegistryMaxSig() {
    }

    public EPPRegistryMaxSig(Boolean clientDefined, Integer defaultLife, Integer min, Integer max) {
        this.clientDefined = clientDefined;
        this.defaultLife = defaultLife;
        this.min = min;
        this.max = max;
    }

    public EPPRegistryMaxSig(boolean clientDefined, int defaultLife, int min, int max) {
        this((Boolean)clientDefined, (Integer)defaultLife, (Integer)min, (Integer)max);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPRegistryMaxSig.encode: " + e);
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", ELM_NAME);
        if (this.clientDefined == null) {
            this.clientDefined = Boolean.FALSE;
        }
        EPPUtil.encodeString(aDocument, root, this.clientDefined.toString(), "http://www.verisign.com/epp/registry-1.0", ELM_CLIENT_DEFINED);
        if (this.defaultLife != null) {
            EPPUtil.encodeString(aDocument, root, this.defaultLife.toString(), "http://www.verisign.com/epp/registry-1.0", ELM_DEFAULT);
        }
        if (this.min != null) {
            EPPUtil.encodeString(aDocument, root, this.min.toString(), "http://www.verisign.com/epp/registry-1.0", ELM_MIN);
        }
        if (this.max != null) {
            EPPUtil.encodeString(aDocument, root, this.max.toString(), "http://www.verisign.com/epp/registry-1.0", ELM_MAX);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.clientDefined = EPPUtil.decodeBoolean(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_CLIENT_DEFINED);
        this.defaultLife = EPPUtil.decodeInteger(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_DEFAULT);
        this.min = EPPUtil.decodeInteger(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_MIN);
        this.max = EPPUtil.decodeInteger(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_MAX);
    }

    void validateState() throws EPPCodecException {
        if (!(this.clientDefined != null && this.clientDefined != Boolean.FALSE || this.min == null && this.max == null)) {
            throw new EPPCodecException("None of min or max should be set when clientDefined is set to false");
        }
        if (this.min != null && this.min < 1) {
            throw new EPPCodecException("min, if specified, should be no less than 1");
        }
        if (this.max != null && this.max < 1) {
            throw new EPPCodecException("max, if specified, should be no less than 1");
        }
        if (this.defaultLife != null && this.defaultLife < 1) {
            throw new EPPCodecException("defaultLife, if specified, should be no less than 1");
        }
        if (this.min != null && this.max != null && this.max < this.min) {
            throw new EPPCodecException("max should be no less than min");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return (EPPRegistryMaxSig)super.clone();
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryMaxSig)) {
            return false;
        }
        EPPRegistryMaxSig theComp = (EPPRegistryMaxSig)aObject;
        if (!(this.clientDefined != null ? this.clientDefined.equals(theComp.clientDefined) : theComp.clientDefined == null)) {
            return false;
        }
        if (!(this.defaultLife != null ? this.defaultLife.equals(theComp.defaultLife) : theComp.defaultLife == null)) {
            return false;
        }
        if (!(this.min != null ? this.min.equals(theComp.min) : theComp.min == null)) {
            return false;
        }
        return this.max != null ? this.max.equals(theComp.max) : theComp.max == null;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public Boolean getClientDefined() {
        return this.clientDefined;
    }

    public void setClientDefined(Boolean clientDefined) {
        this.clientDefined = clientDefined;
    }

    public Integer getDefaultLife() {
        return this.defaultLife;
    }

    public void setDefaultLife(Integer defaultLife) {
        this.defaultLife = defaultLife;
    }

    public Integer getMin() {
        return this.min;
    }

    public void setMin(Integer min) {
        this.min = min;
    }

    public Integer getMax() {
        return this.max;
    }

    public void setMax(Integer max) {
        this.max = max;
    }

    @Override
    public String getNamespace() {
        return "http://www.verisign.com/epp/registry-1.0";
    }
}

