/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.EPPRegistryMinMaxLength;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryInternalHost
extends EPPRegistryMinMaxLength {
    private static final long serialVersionUID = 8992068321172964060L;
    public static final String ELM_LOCALNAME = "internal";
    public static final String ELM_NAME = "registry:internal";
    public static final String ELM_SHARE_POLICY = "sharePolicy";
    public static final List VALID_POLICIES = new ArrayList();
    public static final String TYPE_PER_ZONE = "perZone";
    public static final String TYPE_PER_SYSTEM = "perSystem";
    private String sharePolicy = null;

    public EPPRegistryInternalHost() {
        this.rootName = ELM_NAME;
        this.elmMin = "registry:minIP";
        this.elmMax = "registry:maxIP";
    }

    public EPPRegistryInternalHost(Integer min, Integer max, String sharePolicy) {
        this();
        this.min = min;
        this.max = max;
        this.sharePolicy = sharePolicy;
    }

    public EPPRegistryInternalHost(int min, int max, String sharePolicy) {
        this((Integer)min, (Integer)max, sharePolicy);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.sharePolicy != null && !VALID_POLICIES.contains(this.sharePolicy)) {
            throw new EPPEncodeException("Invalid state on EPPRegistryInternalHost.encode: Invalid sharePolicy value. Valid values are: perZone/perSystem");
        }
        Element root = super.encode(aDocument);
        EPPUtil.encodeString(aDocument, root, this.sharePolicy, "http://www.verisign.com/epp/registry-1.0", "registry:sharePolicy");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        super.decode(aElement);
        this.sharePolicy = EPPUtil.decodeString(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_SHARE_POLICY);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return (EPPRegistryInternalHost)super.clone();
    }

    @Override
    public boolean equals(Object aObject) {
        if (!super.equals(aObject)) {
            return false;
        }
        if (!(aObject instanceof EPPRegistryInternalHost)) {
            return false;
        }
        EPPRegistryInternalHost theComp = (EPPRegistryInternalHost)aObject;
        return this.sharePolicy != null ? this.sharePolicy.equals(theComp.sharePolicy) : theComp.sharePolicy == null;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public String getSharePolicy() {
        return this.sharePolicy;
    }

    public void setSharePolicy(String sharePolicy) {
        this.sharePolicy = sharePolicy;
    }

    @Override
    protected void validateState() throws EPPEncodeException {
        if (this.min == null || this.min < 0) {
            throw new EPPEncodeException("Invalid state on " + this.getClass().getName() + ".encode: min is required and should be greater than or equal to 0");
        }
        if (this.max == null || this.max < this.min) {
            throw new EPPEncodeException("Invalid state on " + this.getClass().getName() + ".encode: max is required and should be greater than or equal to min");
        }
    }

    static {
        VALID_POLICIES.add(TYPE_PER_ZONE);
        VALID_POLICIES.add(TYPE_PER_SYSTEM);
    }
}

