/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.EPPRegistryZoneInfo;
import com.verisign.epp.codec.registry.EPPRegistryZoneList;
import com.verisign.epp.util.EPPCatFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryInfoResp
extends EPPResponse {
    private static final long serialVersionUID = -2683693517713467339L;
    static final String ELM_NAME = "registry:infData";
    private EPPRegistryZoneList zoneList = null;
    private EPPRegistryZoneInfo zoneInfo = null;
    private static Logger cat = Logger.getLogger((String)EPPRegistryInfoResp.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());

    public EPPRegistryInfoResp() {
    }

    public EPPRegistryInfoResp(EPPTransId transId, EPPRegistryZoneList zoneList) {
        super(transId);
        this.zoneList = zoneList;
        this.zoneInfo = null;
    }

    public EPPRegistryInfoResp(EPPTransId transId, EPPRegistryZoneInfo zoneInfo) {
        super(transId);
        this.zoneInfo = zoneInfo;
        this.zoneList = null;
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error((Object)("EPPRegistryInfoResp.doEncode(): Invalid state on encode: " + e));
            throw new EPPEncodeException("Invalid state on EPPRegistryInfoResp.encode: " + e);
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", ELM_NAME);
        root.setAttribute("xmlns:registry", "http://www.verisign.com/epp/registry-1.0");
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.verisign.com/epp/registry-1.0 registry-1.0.xsd");
        if (this.zoneList != null) {
            EPPUtil.encodeComp(aDocument, root, this.zoneList);
        }
        if (this.zoneInfo != null) {
            EPPUtil.encodeComp(aDocument, root, this.zoneInfo);
        }
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.zoneList = (EPPRegistryZoneList)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:zoneList", EPPRegistryZoneList.class);
        this.zoneInfo = (EPPRegistryZoneInfo)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:zone", EPPRegistryZoneInfo.class);
    }

    void validateState() throws EPPCodecException {
        if (this.zoneList == null && this.zoneInfo == null || this.zoneList != null && this.zoneInfo != null) {
            throw new EPPCodecException("One and only one zoneList or zoneInfo can exist");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryInfoResp clone = (EPPRegistryInfoResp)super.clone();
        if (this.zoneList != null) {
            clone.zoneList = (EPPRegistryZoneList)this.zoneList.clone();
        }
        if (this.zoneInfo != null) {
            clone.zoneInfo = (EPPRegistryZoneInfo)this.zoneInfo.clone();
        }
        return clone;
    }

    @Override
    public String getType() {
        return ELM_NAME;
    }

    @Override
    public String getNamespace() {
        return "http://www.verisign.com/epp/registry-1.0";
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryInfoResp)) {
            return false;
        }
        EPPRegistryInfoResp theComp = (EPPRegistryInfoResp)aObject;
        if (!(this.zoneList != null ? this.zoneList.equals(theComp.zoneList) : theComp.zoneList == null)) {
            cat.error((Object)"EPPRegistryInfoResp.equals(): zoneList not equal");
            return false;
        }
        if (!(this.zoneInfo != null ? this.zoneInfo.equals(theComp.zoneInfo) : theComp.zoneInfo == null)) {
            cat.error((Object)"EPPRegistryInfoResp.equals(): zoneInfo not equal");
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public EPPRegistryZoneList getZoneList() {
        return this.zoneList;
    }

    public void setZoneList(EPPRegistryZoneList zoneList) {
        this.zoneList = zoneList;
    }

    public EPPRegistryZoneInfo getZoneInfo() {
        return this.zoneInfo;
    }

    public void setZoneInfo(EPPRegistryZoneInfo zoneInfo) {
        this.zoneInfo = zoneInfo;
    }
}

