/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.registry.EPPRegistryPeriodType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryGracePeriod
extends EPPRegistryPeriodType {
    private static final long serialVersionUID = 7887886408519098870L;
    public static final String ELM_NAME = "registry:gracePeriod";
    public static final String ATTR_COMMAND = "command";
    protected String command = null;

    public EPPRegistryGracePeriod() {
        this.rootName = ELM_NAME;
    }

    public EPPRegistryGracePeriod(String command, Integer number, String unit) {
        this();
        this.command = command;
        this.number = number;
        this.unit = unit;
    }

    public EPPRegistryGracePeriod(String command, int number, String unit) {
        this(command, (Integer)number, unit);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root = super.encode(aDocument);
        root.setAttribute(ATTR_COMMAND, this.command);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.command = aElement.getAttribute(ATTR_COMMAND);
        super.decode(aElement);
    }

    @Override
    void validateState() throws EPPCodecException {
        super.validateState();
        if (this.command == null || this.command.trim().length() == 0) {
            throw new EPPCodecException(this.getRootName() + ": command is empty");
        }
    }

    @Override
    public boolean equals(Object aObject) {
        return super.equals(aObject);
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    @Override
    void extraValidate() throws EPPCodecException {
        int n = this.number;
        if (n <= 0) {
            throw new EPPCodecException(this.getRootName() + ": number should be greater than 0");
        }
        if (!("h".equals(this.unit) || "m".equals(this.unit) || "d".equals(this.unit))) {
            throw new EPPCodecException(this.getRootName() + ": invalid unit. Valid values: d/h/m");
        }
    }

    @Override
    public String getNamespace() {
        return "http://www.verisign.com/epp/registry-1.0";
    }
}

