/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryFields
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPRegistryFields.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String TYPE_SHARED = "shared";
    public static final String TYPE_SYNC = "sync";
    public static final String ELM_LOCALNAME = "fields";
    public static final String ELM_NAME = "registry:fields";
    private static final String ELM_FIELD = "field";
    public static final String ATTR_TYPE = "type";
    private String type;
    private List<String> fields = new ArrayList<String>();

    public EPPRegistryFields() {
    }

    public EPPRegistryFields(String aType, List<String> aFields) {
        this.type = aType;
        this.fields = aFields;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String aType) {
        this.type = aType;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public void setFields(List<String> aFields) {
        this.fields = aFields;
    }

    public void addField(String aField) {
        if (this.fields == null) {
            this.fields = new ArrayList<String>();
        }
        this.fields.add(aField);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryFields clone = null;
        clone = (EPPRegistryFields)super.clone();
        return clone;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        String theType = aElement.getAttribute(ATTR_TYPE);
        this.type = theType != null && theType.length() != 0 ? theType : null;
        this.fields = EPPUtil.decodeList(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_FIELD);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null in EPPRegistryFields.encode(Document)");
        }
        if (this.type == null) {
            throw new EPPEncodeException("type is null in EPPRegistryFields.encode(Document)");
        }
        if (this.fields == null || this.fields.isEmpty()) {
            throw new EPPEncodeException("fields is null or empty in EPPRegistryFields.encode(Document)");
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", ELM_NAME);
        root.setAttribute(ATTR_TYPE, this.type);
        EPPUtil.encodeList(aDocument, root, this.fields, "http://www.verisign.com/epp/registry-1.0", "registry:field");
        return root;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryFields)) {
            return false;
        }
        EPPRegistryFields other = (EPPRegistryFields)aObject;
        if (!EqualityUtil.equals(this.type, other.type)) {
            cat.error((Object)"EPPRegistryFields.equals(): type not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.fields, other.fields)) {
            cat.error((Object)"EPPRegistryFields.equals(): fields not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "http://www.verisign.com/epp/registry-1.0";
    }
}

