/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.EPPRegistryCustomData;
import com.verisign.epp.codec.registry.EPPRegistryPostal;
import com.verisign.epp.codec.registry.EPPRegistryRegex;
import com.verisign.epp.codec.registry.EPPRegistrySupportedStatus;
import com.verisign.epp.codec.registry.EPPRegistryTransferHoldPeriodType;
import com.verisign.epp.util.EqualityUtil;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryContact
implements EPPCodecComponent {
    private static final long serialVersionUID = -2835245153428894020L;
    private static Logger cat = Logger.getLogger(EPPRegistryContact.class);
    public static final String TYPE_PER_ZONE = "perZone";
    public static final String TYPE_PER_SYSTEM = "perSystem";
    public static final String ELM_LOCALNAME = "contact";
    public static final String ELM_NAME = "registry:contact";
    public static final String ELM_CONTACT_ID_REGEX = "contactIdRegex";
    public static final String ELM_SHARE_POLICY = "sharePolicy";
    public static final String ELM_INT_SUPPORT = "intSupport";
    public static final String ELM_LOC_SUPPORT = "locSupport";
    public static final String ELM_MAX_CHECK = "maxCheckContact";
    public static final String ELM_AUTH_INFO_REGEX = "authInfoRegex";
    public static final String ELM_CUSTOM_DATA = "customData";
    public static final String ELM_CUSTOM_CLIENT_DISCLOSURE_SUPPORTED = "clientDisclosureSupported";
    private EPPRegistryRegex contactIdRegex = null;
    private String sharePolicy = null;
    private Boolean intSupport = null;
    private Boolean locSupport = null;
    private EPPRegistryPostal postalInfo = null;
    private Integer maxCheckContact = null;
    private EPPRegistryRegex authInfoRegex = null;
    private EPPRegistryCustomData customData = null;
    private Boolean clientDisclosureSupported = Boolean.FALSE;
    private EPPRegistryTransferHoldPeriodType transferHoldPeriod = null;
    private EPPRegistrySupportedStatus supportedStatus = null;

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPRegistryContact.encode: " + e);
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", ELM_NAME);
        EPPUtil.encodeComp(aDocument, root, this.contactIdRegex);
        EPPUtil.encodeString(aDocument, root, this.sharePolicy, "http://www.verisign.com/epp/registry-1.0", "registry:sharePolicy");
        EPPUtil.encodeString(aDocument, root, this.intSupport.toString(), "http://www.verisign.com/epp/registry-1.0", "registry:intSupport");
        EPPUtil.encodeString(aDocument, root, this.locSupport.toString(), "http://www.verisign.com/epp/registry-1.0", "registry:locSupport");
        EPPUtil.encodeComp(aDocument, root, this.postalInfo);
        EPPUtil.encodeString(aDocument, root, this.maxCheckContact.toString(), "http://www.verisign.com/epp/registry-1.0", "registry:maxCheckContact");
        if (this.authInfoRegex != null) {
            EPPUtil.encodeComp(aDocument, root, this.authInfoRegex);
        }
        if (this.clientDisclosureSupported == null) {
            this.clientDisclosureSupported = Boolean.FALSE;
        }
        EPPUtil.encodeString(aDocument, root, this.clientDisclosureSupported.toString(), "http://www.verisign.com/epp/registry-1.0", "registry:clientDisclosureSupported");
        if (this.supportedStatus != null) {
            EPPUtil.encodeComp(aDocument, root, this.supportedStatus);
        }
        EPPUtil.encodeComp(aDocument, root, this.transferHoldPeriod);
        if (this.customData != null) {
            EPPUtil.encodeComp(aDocument, root, this.customData);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.setContactIdRegex((EPPRegistryRegex)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_CONTACT_ID_REGEX, EPPRegistryRegex.class));
        this.sharePolicy = EPPUtil.decodeString(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_SHARE_POLICY);
        this.intSupport = EPPUtil.decodeBoolean(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_INT_SUPPORT);
        this.locSupport = EPPUtil.decodeBoolean(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_LOC_SUPPORT);
        this.postalInfo = (EPPRegistryPostal)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:postalInfo", EPPRegistryPostal.class);
        this.maxCheckContact = EPPUtil.decodeInteger(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_MAX_CHECK);
        this.setAuthInfoRegex((EPPRegistryRegex)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_AUTH_INFO_REGEX, EPPRegistryRegex.class));
        this.clientDisclosureSupported = EPPUtil.decodeBoolean(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_CUSTOM_CLIENT_DISCLOSURE_SUPPORTED);
        if (this.clientDisclosureSupported == null) {
            this.clientDisclosureSupported = Boolean.FALSE;
        }
        this.supportedStatus = (EPPRegistrySupportedStatus)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:supportedStatus", EPPRegistrySupportedStatus.class);
        this.transferHoldPeriod = (EPPRegistryTransferHoldPeriodType)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:transferHoldPeriod", EPPRegistryTransferHoldPeriodType.class);
        this.customData = (EPPRegistryCustomData)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:customData", EPPRegistryCustomData.class);
    }

    void validateState() throws EPPCodecException {
        if (this.intSupport == null) {
            throw new EPPCodecException("intSupport required element is not set");
        }
        if (this.locSupport == null) {
            throw new EPPCodecException("locSupport required element is not set");
        }
        if (this.postalInfo == null) {
            throw new EPPCodecException("postalInfo required element is not set");
        }
        if (this.maxCheckContact == null || this.maxCheckContact <= 0) {
            throw new EPPCodecException("maxCheckContact is required and should be greater than 0");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryContact clone = (EPPRegistryContact)super.clone();
        if (this.contactIdRegex != null) {
            clone.contactIdRegex = (EPPRegistryRegex)this.contactIdRegex.clone();
        }
        if (this.authInfoRegex != null) {
            clone.authInfoRegex = (EPPRegistryRegex)this.authInfoRegex.clone();
        }
        if (this.supportedStatus != null) {
            clone.supportedStatus = (EPPRegistrySupportedStatus)this.supportedStatus.clone();
        }
        if (this.transferHoldPeriod != null) {
            clone.transferHoldPeriod = (EPPRegistryTransferHoldPeriodType)this.transferHoldPeriod.clone();
        }
        return clone;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryContact)) {
            return false;
        }
        EPPRegistryContact other = (EPPRegistryContact)aObject;
        if (!EqualityUtil.equals(this.contactIdRegex, other.contactIdRegex)) {
            cat.error((Object)"EPPRegistryContact.equals(): contactIdRegex not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.sharePolicy, other.sharePolicy)) {
            cat.error((Object)"EPPRegistryContact.equals(): sharePolicy not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.intSupport, other.intSupport)) {
            cat.error((Object)"EPPRegistryContact.equals(): intSupport not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.locSupport, other.locSupport)) {
            cat.error((Object)"EPPRegistryContact.equals(): locSupport not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.postalInfo, other.postalInfo)) {
            cat.error((Object)"EPPRegistryContact.equals(): postalInfo not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.maxCheckContact, other.maxCheckContact)) {
            cat.error((Object)"EPPRegistryContact.equals(): maxCheckContact not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.authInfoRegex, other.authInfoRegex)) {
            cat.error((Object)"EPPRegistryContact.equals(): authInfoRegex not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.supportedStatus, other.supportedStatus)) {
            cat.error((Object)"EPPRegistryContact.equals(): supportedStatus not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.transferHoldPeriod, other.transferHoldPeriod)) {
            cat.error((Object)"EPPRegistryContact.equals(): transferHoldPeriod not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.customData, other.customData)) {
            cat.error((Object)"EPPRegistryContact.equals(): customData not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public EPPRegistryRegex getContactIdRegex() {
        return this.contactIdRegex;
    }

    public void setContactIdRegex(EPPRegistryRegex aContactIdRegex) {
        if (aContactIdRegex != null) {
            aContactIdRegex.setRootName(ELM_CONTACT_ID_REGEX);
        }
        this.contactIdRegex = aContactIdRegex;
    }

    public String getSharePolicy() {
        return this.sharePolicy;
    }

    public void setSharePolicy(String aSharePolicy) {
        this.sharePolicy = aSharePolicy;
    }

    public Boolean getIntSupport() {
        return this.intSupport;
    }

    public void setIntSupport(Boolean intSupport) {
        this.intSupport = intSupport;
    }

    public Boolean getLocSupport() {
        return this.locSupport;
    }

    public void setLocSupport(Boolean locSupport) {
        this.locSupport = locSupport;
    }

    public Integer getMaxCheckContact() {
        return this.maxCheckContact;
    }

    public void setMaxCheckContact(Integer maxCheckContact) {
        this.maxCheckContact = maxCheckContact;
    }

    public EPPRegistryRegex getAuthInfoRegex() {
        return this.authInfoRegex;
    }

    public void setAuthInfoRegex(EPPRegistryRegex authInfoRegex) {
        if (authInfoRegex != null) {
            authInfoRegex.setRootName(ELM_AUTH_INFO_REGEX);
        }
        this.authInfoRegex = authInfoRegex;
    }

    public EPPRegistryCustomData getCustomData() {
        return this.customData;
    }

    public void setCustomData(EPPRegistryCustomData customData) {
        this.customData = customData;
    }

    public EPPRegistryPostal getPostalInfo() {
        return this.postalInfo;
    }

    public void setPostalInfo(EPPRegistryPostal postalInfo) {
        this.postalInfo = postalInfo;
    }

    public Boolean getClientDisclosureSupported() {
        return this.clientDisclosureSupported;
    }

    public void setClientDisclosureSupported(Boolean clientDisclosureSupported) {
        this.clientDisclosureSupported = clientDisclosureSupported;
    }

    public EPPRegistrySupportedStatus getSupportedStatus() {
        return this.supportedStatus;
    }

    public void setSupportedStatus(EPPRegistrySupportedStatus supportedStatus) {
        this.supportedStatus = supportedStatus;
    }

    public EPPRegistryTransferHoldPeriodType getTransferHoldPeriod() {
        return this.transferHoldPeriod;
    }

    public void setTransferHoldPeriod(EPPRegistryTransferHoldPeriodType transferHoldPeriod) {
        this.transferHoldPeriod = transferHoldPeriod;
    }

    @Override
    public String getNamespace() {
        return "http://www.verisign.com/epp/registry-1.0";
    }
}

