/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.orgext;

import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.domain.EPPDomainPeriod;
import com.verisign.epp.codec.domain.EPPDomainStatus;
import com.verisign.epp.codec.domain.EPPDomainUpdateCmd;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.orgext.EPPOrgExtCreate;
import com.verisign.epp.codec.orgext.EPPOrgExtId;
import com.verisign.epp.codec.orgext.EPPOrgExtInfData;
import com.verisign.epp.codec.orgext.EPPOrgExtUpdate;
import com.verisign.epp.util.TestThread;
import java.util.Date;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class EPPOrgExtTst
extends TestCase {
    private static long numIterations = 1L;

    public EPPOrgExtTst(String name) {
        super(name);
    }

    public void testOrgExtCreate() {
        EPPCodecTst.printStart("testOrgExtCreate");
        EPPDomainCreateCmd theDomainCommand1 = new EPPDomainCreateCmd("ABC-12345", "example.com", new EPPAuthInfo("fooBAR"));
        theDomainCommand1.setPeriod(new EPPDomainPeriod("y", 3));
        theDomainCommand1.addServer("ns1.example.com");
        EPPDomainCreateCmd theDomainCommand2 = null;
        try {
            theDomainCommand2 = (EPPDomainCreateCmd)theDomainCommand1.clone();
        }
        catch (CloneNotSupportedException e) {
            Assert.fail((String)("CloneNotSupportedException cloning the EPPDomainCreateCmd: " + e));
        }
        theDomainCommand1.addExtension(new EPPOrgExtCreate(new EPPOrgExtId("reseller", "myreseller")));
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theDomainCommand1);
        System.out.println(theStats);
        EPPOrgExtCreate theExt = new EPPOrgExtCreate();
        theExt.addOrgId(new EPPOrgExtId("reseller", "myreseller"));
        theExt.addOrgId(new EPPOrgExtId("privacyproxy", "myproxy"));
        theDomainCommand2.addExtension(theExt);
        theStats = EPPCodecTst.testEncodeDecode(theDomainCommand2);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testOrgExtCreate");
    }

    public void testOrgExtInfData() {
        EPPCodecTst.printStart("testOrgExtInfData");
        Vector<EPPDomainStatus> statuses = new Vector<EPPDomainStatus>();
        statuses.addElement(new EPPDomainStatus("ok"));
        EPPTransId respTransId = new EPPTransId("ngcl-IvJjzMZc", "test142AWQONJZ");
        EPPDomainInfoResp theResponse1 = new EPPDomainInfoResp(respTransId, "EXAMPLE1-REP", "example.com", "ClientX", statuses, "ClientY", new Date(), new EPPAuthInfo("2fooBAR"));
        theResponse1.setResult(1000);
        EPPDomainInfoResp theResponse2 = null;
        try {
            theResponse2 = (EPPDomainInfoResp)theResponse1.clone();
        }
        catch (CloneNotSupportedException e) {
            Assert.fail((String)("CloneNotSupportedException cloning the EPPDomainInfoResp: " + e));
        }
        EPPOrgExtInfData theExt = new EPPOrgExtInfData();
        theExt.addOrgId(new EPPOrgExtId("reseller", "myreseller"));
        theExt.addOrgId(new EPPOrgExtId("privacyproxy", "myproxy"));
        theResponse1.addExtension(theExt);
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theResponse1);
        System.out.println(theStats);
        theResponse2.addExtension(new EPPOrgExtInfData());
        theStats = EPPCodecTst.testEncodeDecode(theResponse2);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testOrgExtInfData");
    }

    public void testOrgExtUpdate() {
        EPPCodecTst.printStart("testOrgExtUpdate");
        EPPDomainUpdateCmd theDomainCommand = new EPPDomainUpdateCmd("ABC-12345", "example.com", null, null, null);
        EPPOrgExtUpdate theExt = new EPPOrgExtUpdate();
        theExt.addAddOrg(new EPPOrgExtId("reseller", "myreseller"));
        theDomainCommand.addExtension(theExt);
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theDomainCommand);
        System.out.println(theStats);
        theDomainCommand = new EPPDomainUpdateCmd("ABC-12345", "example.com", null, null, null);
        theExt = new EPPOrgExtUpdate();
        theExt.addAddOrg(new EPPOrgExtId("reseller", "myreseller"));
        theExt.addAddOrg(new EPPOrgExtId("privacyproxy", "myproxy"));
        theDomainCommand.addExtension(theExt);
        theStats = EPPCodecTst.testEncodeDecode(theDomainCommand);
        System.out.println(theStats);
        theDomainCommand = new EPPDomainUpdateCmd("ABC-12345", "example.com", null, null, null);
        theExt = new EPPOrgExtUpdate();
        theExt.addRemOrg(new EPPOrgExtId("reseller", "myreseller"));
        theDomainCommand.addExtension(theExt);
        theStats = EPPCodecTst.testEncodeDecode(theDomainCommand);
        System.out.println(theStats);
        theDomainCommand = new EPPDomainUpdateCmd("ABC-12345", "example.com", null, null, null);
        theExt = new EPPOrgExtUpdate();
        theExt.addRemOrg(new EPPOrgExtId("reseller", "myreseller"));
        theExt.addRemOrg(new EPPOrgExtId("privacyproxy", "myproxy"));
        theStats = EPPCodecTst.testEncodeDecode(theDomainCommand);
        System.out.println(theStats);
        theDomainCommand = new EPPDomainUpdateCmd("ABC-12345", "example.com", null, null, null);
        theExt = new EPPOrgExtUpdate();
        theExt.addChgOrg(new EPPOrgExtId("reseller", "myreseller"));
        theDomainCommand.addExtension(theExt);
        theStats = EPPCodecTst.testEncodeDecode(theDomainCommand);
        System.out.println(theStats);
        theDomainCommand = new EPPDomainUpdateCmd("ABC-12345", "example.com", null, null, null);
        theExt = new EPPOrgExtUpdate();
        theExt.addChgOrg(new EPPOrgExtId("reseller", "myreseller"));
        theExt.addChgOrg(new EPPOrgExtId("privacyproxy", "myproxy"));
        theStats = EPPCodecTst.testEncodeDecode(theDomainCommand);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testOrgExtUpdate");
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static Test suite() {
        EPPCodecTst.initEnvironment();
        TestSuite suite = new TestSuite(EPPOrgExtTst.class);
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.host.EPPHostMapFactory");
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.domain.EPPDomainMapFactory");
            EPPFactory.getInstance().addExtFactory("com.verisign.epp.codec.orgext.EPPOrgExtFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding factories to EPPCodec: " + e));
        }
        return suite;
    }

    public static void main(String[] args) {
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPOrgExtTst Thread " + i, EPPOrgExtTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPOrgExtTst.suite());
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }
}

