/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.orgext;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EPPOrgExtId
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPOrgExtId.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "id";
    public static final String ELM_NAME = "orgext:id";
    private static final String ATTR_ROLE = "role";
    private static final String ELM_ORG_ID = "id";
    private String role;
    private String orgId;

    public EPPOrgExtId() {
    }

    public EPPOrgExtId(String aRole) {
        this.setRole(aRole);
    }

    public EPPOrgExtId(String aRole, String aOrgId) {
        this.setRole(aRole);
        this.setOrgId(aOrgId);
    }

    public boolean hasOrgId() {
        return this.orgId != null;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public void setOrgId(String aOrgId) {
        this.orgId = aOrgId;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String aRole) {
        this.role = aRole;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.role == null) {
            throw new EPPEncodeException("Undefined role in EPPOrgExtId");
        }
        if (this.orgId == null) {
            throw new EPPEncodeException("Undefined orgId in EPPOrgExtId");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:orgext-1.0", ELM_NAME);
        root.appendChild(aDocument.createTextNode(this.orgId));
        root.setAttribute(ATTR_ROLE, this.role);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        String theRole;
        Node theTextNode = aElement.getFirstChild();
        if (theTextNode != null) {
            this.orgId = theTextNode.getNodeValue();
        }
        this.role = (theRole = aElement.getAttribute(ATTR_ROLE)) != null && !theRole.isEmpty() ? theRole : null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPOrgExtId clone = (EPPOrgExtId)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPOrgExtId)) {
            return false;
        }
        EPPOrgExtId other = (EPPOrgExtId)aObject;
        if (!EqualityUtil.equals(this.orgId, other.orgId)) {
            cat.error((Object)"EPPOrgExtId.equals(): orgId not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.role, other.role)) {
            cat.error((Object)"EPPOrgExtId.equals(): role not equal");
            return false;
        }
        return true;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:orgext-1.0";
    }
}

