/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.org;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.org.EPPOrgAddress;
import com.verisign.epp.codec.org.EPPOrgCheckCmd;
import com.verisign.epp.codec.org.EPPOrgCheckResp;
import com.verisign.epp.codec.org.EPPOrgCheckResult;
import com.verisign.epp.codec.org.EPPOrgContact;
import com.verisign.epp.codec.org.EPPOrgCreateCmd;
import com.verisign.epp.codec.org.EPPOrgCreateResp;
import com.verisign.epp.codec.org.EPPOrgDeleteCmd;
import com.verisign.epp.codec.org.EPPOrgInfoCmd;
import com.verisign.epp.codec.org.EPPOrgInfoResp;
import com.verisign.epp.codec.org.EPPOrgPostalDefinition;
import com.verisign.epp.codec.org.EPPOrgRole;
import com.verisign.epp.codec.org.EPPOrgRoleStatus;
import com.verisign.epp.codec.org.EPPOrgStatus;
import com.verisign.epp.codec.org.EPPOrgUpdateCmd;
import com.verisign.epp.util.TestThread;
import java.util.GregorianCalendar;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class EPPOrgTst
extends TestCase {
    private static long numIterations = 1L;

    public EPPOrgTst(String name) {
        super(name);
    }

    public void testCheckCommand() {
        EPPCodecTst.printStart("testCheckCommand");
        EPPOrgCheckCmd theCommand = new EPPOrgCheckCmd("ABC-12345", "res1523");
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(theStats);
        theCommand = new EPPOrgCheckCmd("ABC-12345");
        theCommand.addOrgId("res1523");
        theCommand.addOrgId("re1523");
        theCommand.addOrgId("1523res");
        theStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testCheckCommand");
    }

    public void testCheckResponse() {
        EPPCodecTst.printStart("testCheckResponse");
        EPPTransId theTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        EPPOrgCheckResp theResp = new EPPOrgCheckResp(theTransId, new EPPOrgCheckResult("res1523", true));
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theResp);
        System.out.println(theStats);
        theResp = new EPPOrgCheckResp(theTransId);
        theResp.addCheckResult(new EPPOrgCheckResult("res1523", true));
        theResp.addCheckResult(new EPPOrgCheckResult("re1523", "In use"));
        theResp.addCheckResult(new EPPOrgCheckResult("1523res", true));
        theStats = EPPCodecTst.testEncodeDecode(theResp);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testCheckResponse");
    }

    public void testInfoCommand() {
        EPPCodecTst.printStart("testInfoCommand");
        EPPOrgInfoCmd theCommand = new EPPOrgInfoCmd("ABC-12345", "res1523");
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testInfoCommand");
    }

    public void testInfoResponse() {
        EPPCodecTst.printStart("testInfoResponse");
        EPPTransId theTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        EPPOrgInfoResp theResp = new EPPOrgInfoResp(theTransId, "registrar1362");
        theResp.setRoid("registrar1362-REP");
        theResp.addRole(new EPPOrgRole("registrar", EPPOrgRoleStatus.ok, "1362"));
        theResp.addStatus(EPPOrgStatus.ok);
        theResp.setParentId("1523res");
        EPPOrgAddress theAddress = new EPPOrgAddress();
        theAddress.setStreets("124 Example Dr.", "Suite 200");
        theAddress.setCity("Dulles");
        theAddress.setStateProvince("VA");
        theAddress.setPostalCode("20166-6503");
        theAddress.setCountry("US");
        theResp.addPostalInfo(new EPPOrgPostalDefinition(EPPOrgPostalDefinition.Type.INT, "Example Org Inc.", theAddress));
        theResp.setVoice("+1.7035555555");
        theResp.setVoiceExt("1234");
        theResp.setFax("+1.7035555556");
        theResp.setEmail("contact@org.example");
        theResp.setUrl("http://org.example");
        theResp.addContact(new EPPOrgContact("sh8013", EPPOrgContact.Type.ADMINISTRATIVE));
        theResp.addContact(new EPPOrgContact("sh8013", EPPOrgContact.Type.BILLING));
        theResp.addContact(new EPPOrgContact("sh8013", EPPOrgContact.Type.CUSTOM, "customSample"));
        theResp.setClientId("ClientY");
        theResp.setCreatedBy("ClientX");
        theResp.setCreatedDate(new GregorianCalendar(1999, 4, 3, 22, 0).getTime());
        theResp.setLastUpdatedBy("ClientX");
        theResp.setLastUpdatedDate(new GregorianCalendar(1999, 12, 3, 0, 0).getTime());
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theResp);
        System.out.println(theStats);
        theResp = new EPPOrgInfoResp(theTransId, "reseller1523");
        theResp.setRoid("reseller1523-REP");
        EPPOrgRole theRole = new EPPOrgRole("reseller");
        theRole.addStatus(EPPOrgRoleStatus.ok);
        theRole.addStatus(EPPOrgRoleStatus.linked);
        theResp.addRole(theRole);
        theResp.addStatus(EPPOrgStatus.ok);
        theResp.setParentId("registrar1362");
        theAddress = new EPPOrgAddress();
        theAddress.setStreets("124 Example Dr.", "Suite 200");
        theAddress.setCity("Dulles");
        theAddress.setStateProvince("VA");
        theAddress.setPostalCode("20166-6503");
        theAddress.setCountry("US");
        theResp.addPostalInfo(new EPPOrgPostalDefinition(EPPOrgPostalDefinition.Type.INT, "Example Reseller Inc.", theAddress));
        theResp.setFax("+1.7035555556");
        theResp.setUrl("http://organization.example");
        theResp.addContact(new EPPOrgContact("sh8013", EPPOrgContact.Type.ADMINISTRATIVE));
        theResp.setClientId("1362");
        theResp.setCreatedBy("ClientX");
        theResp.setCreatedDate(new GregorianCalendar(1999, 4, 3, 22, 0).getTime());
        theResp.setLastUpdatedBy("ClientX");
        theResp.setLastUpdatedDate(new GregorianCalendar(1999, 12, 3, 0, 0).getTime());
        theStats = EPPCodecTst.testEncodeDecode(theResp);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testInfoResponse");
    }

    public void testCreateCommand() {
        EPPCodecTst.printStart("testCreateCommand");
        EPPOrgCreateCmd theCommand = new EPPOrgCreateCmd();
        theCommand.setOrgId("res1523");
        theCommand.addRole(new EPPOrgRole("reseller", EPPOrgRoleStatus.ok, null));
        theCommand.addRole(new EPPOrgRole("privacyproxy", EPPOrgRoleStatus.ok, null));
        theCommand.addStatus(EPPOrgStatus.clientLinkProhibited);
        theCommand.setParentId("1523res");
        EPPOrgAddress theAddress = new EPPOrgAddress();
        theAddress.setStreets("124 Example Dr.", "Suite 200");
        theAddress.setCity("Dulles");
        theAddress.setStateProvince("VA");
        theAddress.setPostalCode("20166-6503");
        theAddress.setCountry("US");
        theCommand.addPostalInfo(new EPPOrgPostalDefinition(EPPOrgPostalDefinition.Type.INT, "Example Organization Inc.", theAddress));
        theCommand.setVoice("+1.7035555555");
        theCommand.setVoiceExt("1234");
        theCommand.setFax("+1.7035555556");
        theCommand.setEmail("contact@organization.example");
        theCommand.setUrl("http://organization.example");
        theCommand.addContact(new EPPOrgContact("sh8013", EPPOrgContact.Type.ADMINISTRATIVE));
        theCommand.addContact(new EPPOrgContact("sh8013", EPPOrgContact.Type.BILLING));
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testCreateCommand");
    }

    public void testCreateResponse() {
        EPPCodecTst.printStart("testCreateResponse");
        EPPTransId theTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        EPPOrgCreateResp theResp = new EPPOrgCreateResp(theTransId, "res1523", new GregorianCalendar(1999, 4, 3, 22, 0).getTime());
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theResp);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testCreateResponse");
    }

    public void testDeleteCommand() {
        EPPCodecTst.printStart("testDeleteCommand");
        EPPOrgDeleteCmd theCommand = new EPPOrgDeleteCmd("ABC-12345", "res1523");
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testDeleteCommand");
    }

    public void testUpdateCommand() {
        EPPCodecTst.printStart("testUpdateCommand");
        EPPOrgUpdateCmd theCommand = new EPPOrgUpdateCmd();
        theCommand.setOrgId("res1523");
        theCommand.addAddContact(new EPPOrgContact("sh8013", EPPOrgContact.Type.TECHNICAL));
        theCommand.addAddRole(new EPPOrgRole("privacyproxy", EPPOrgRoleStatus.clientLinkProhibited, null));
        theCommand.addAddStatus(EPPOrgStatus.clientLinkProhibited);
        theCommand.addRemContact(new EPPOrgContact("sh8014", EPPOrgContact.Type.BILLING));
        theCommand.addRemRole(new EPPOrgRole("reseller"));
        theCommand.addRemStatus(EPPOrgStatus.clientDeleteProhibited);
        theCommand.setParentId("1523res");
        EPPOrgAddress theAddress = new EPPOrgAddress();
        theAddress.setStreets("124 Example Dr.", "Suite 200");
        theAddress.setCity("Dulles");
        theAddress.setStateProvince("VA");
        theAddress.setPostalCode("20166-6503");
        theAddress.setCountry("US");
        EPPOrgPostalDefinition thePostalDef = new EPPOrgPostalDefinition(EPPOrgPostalDefinition.Type.INT);
        thePostalDef.setAddress(theAddress);
        theCommand.addPostalInfo(thePostalDef);
        theCommand.setVoice("+1.7034444444");
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testUpdateCommand");
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static Test suite() {
        EPPCodecTst.initEnvironment();
        TestSuite suite = new TestSuite(EPPOrgTst.class);
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.org.EPPOrgMapFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding factories to EPPCodec: " + e));
        }
        return suite;
    }

    public static void main(String[] args) {
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPOrgTst Thread " + i, EPPOrgTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPOrgTst.suite());
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }
}

