/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.nv;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.nv.EPPNameVerificationDocument;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRealNameVerification
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPRealNameVerification.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "rnv";
    public static final String ELM_NAME = "nv:rnv";
    public static final String ROLE_PERSON = "registrant";
    private static final String ELM_NUM = "num";
    private static final String ELM_REAL_NAME = "name";
    private static final String ELM_PROOF_TYPE = "proofType";
    private static final String ATTR_ROLE = "role";
    private Role role;
    private String name;
    private String num;
    private ProofType proofType;
    private List<EPPNameVerificationDocument> documents = new ArrayList<EPPNameVerificationDocument>();

    public EPPRealNameVerification() {
    }

    public EPPRealNameVerification(Role aRole, String aName, String aNum, ProofType aProofType) {
        this.role = aRole;
        this.name = aName;
        this.num = aNum;
        this.proofType = aProofType;
    }

    public EPPRealNameVerification(Role aRole, String aName, String aNum, ProofType aProofType, EPPNameVerificationDocument aDocument) {
        this.role = aRole;
        this.name = aName;
        this.num = aNum;
        this.proofType = aProofType;
        this.addDocument(aDocument);
    }

    public EPPRealNameVerification(Role aRole, String aName, String aNum, ProofType aProofType, List<EPPNameVerificationDocument> aDocuments) {
        this.role = aRole;
        this.name = aName;
        this.num = aNum;
        this.proofType = aProofType;
        this.setDocuments(aDocuments);
    }

    public Role getRole() {
        return this.role;
    }

    public void setRole(Role aRole) {
        this.role = aRole;
    }

    public String getNum() {
        return this.num;
    }

    public void setNum(String aNum) {
        this.num = aNum;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public ProofType getProofType() {
        return this.proofType;
    }

    public void setProofType(ProofType aProofType) {
        this.proofType = aProofType;
    }

    public boolean hasDocuments() {
        return !this.documents.isEmpty();
    }

    public List<EPPNameVerificationDocument> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<EPPNameVerificationDocument> aDocuments) {
        this.documents = aDocuments;
    }

    public void addDocument(EPPNameVerificationDocument aDocument) {
        this.documents.add(aDocument);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.role == null) {
            throw new EPPEncodeException("Undefined role in EPPRealNameVerification");
        }
        if (this.name == null) {
            throw new EPPEncodeException("Undefined name in EPPRealNameVerification");
        }
        if (this.num == null) {
            throw new EPPEncodeException("Undefined num in EPPRealNameVerification");
        }
        if (this.proofType == null) {
            throw new EPPEncodeException("Undefined proofType in EPPRealNameVerification");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:nv-1.0", ELM_NAME);
        root.setAttribute(ATTR_ROLE, this.role.toString());
        EPPUtil.encodeString(aDocument, root, this.name, "urn:ietf:params:xml:ns:nv-1.0", "nv:name");
        EPPUtil.encodeString(aDocument, root, this.num, "urn:ietf:params:xml:ns:nv-1.0", "nv:num");
        EPPUtil.encodeString(aDocument, root, this.proofType.toString(), "urn:ietf:params:xml:ns:nv-1.0", "nv:proofType");
        if (this.hasDocuments()) {
            EPPUtil.encodeCompList(aDocument, root, this.documents);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.role = Role.getRole(aElement.getAttribute(ATTR_ROLE));
        this.name = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:nv-1.0", ELM_REAL_NAME);
        this.num = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:nv-1.0", ELM_NUM);
        String theProofTypeStr = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:nv-1.0", ELM_PROOF_TYPE);
        this.proofType = ProofType.getProofType(theProofTypeStr);
        this.documents = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:nv-1.0", "nv:document", EPPNameVerificationDocument.class);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRealNameVerification)) {
            cat.error((Object)("EPPRealNameVerification.equals(): object " + aObject.getClass().getName() + "!= EPPRealNameVerification"));
            return false;
        }
        EPPRealNameVerification other = (EPPRealNameVerification)aObject;
        if (!EqualityUtil.equals((Object)this.role, (Object)other.role)) {
            cat.error((Object)"EPPRealNameVerification.equals(): role not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.name, other.name)) {
            cat.error((Object)"EPPRealNameVerification.equals(): name not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.num, other.num)) {
            cat.error((Object)"EPPRealNameVerification.equals(): num not equal");
            return false;
        }
        if (!EqualityUtil.equals((Object)this.proofType, (Object)other.proofType)) {
            cat.error((Object)"EPPRealNameVerification.equals(): proofType not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.documents, other.documents)) {
            cat.error((Object)"EPPRealNameVerification.equals(): documents not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRealNameVerification clone = (EPPRealNameVerification)super.clone();
        clone.documents = new ArrayList<EPPNameVerificationDocument>(this.documents.size());
        for (EPPNameVerificationDocument document : this.documents) {
            clone.documents.add((EPPNameVerificationDocument)document.clone());
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:nv-1.0";
    }

    public static enum ProofType {
        POC("poc"),
        POE("poe"),
        POOT("poot");

        private final String proofTypeStr;

        private ProofType(String aProofTypeStr) {
            this.proofTypeStr = aProofTypeStr;
        }

        public static ProofType getProofType(String aString) {
            if (aString.equals(ProofType.POC.proofTypeStr)) {
                return POC;
            }
            if (aString.equals(ProofType.POE.proofTypeStr)) {
                return POE;
            }
            if (aString.equals(ProofType.POOT.proofTypeStr)) {
                return POOT;
            }
            throw new InvalidParameterException("Proof type enum value of " + aString + " is not valid.");
        }

        public String toString() {
            return this.proofTypeStr;
        }
    }

    public static enum Role {
        PERSON("person"),
        ORG("org");

        private final String roleStr;

        private Role(String aRoleStr) {
            this.roleStr = aRoleStr;
        }

        public static Role getRole(String aString) {
            if (aString.equals(Role.PERSON.roleStr)) {
                return PERSON;
            }
            if (aString.equals(Role.ORG.roleStr)) {
                return ORG;
            }
            throw new InvalidParameterException("Role enum value of " + aString + " is not valid.");
        }

        public String toString() {
            return this.roleStr;
        }
    }
}

