/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.loginsecpolicy.v01;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPLoginSecPolicyPassword
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPLoginSecPolicyPassword.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "pw";
    public static final String ELM_NAME = "loginSecPolicy:pw";
    public static final String DEFAULT_LANG = "en";
    private static final String ELM_EXPRESSION = "expression";
    private static final String ELM_DESCRIPTION = "description";
    public static final String ATTR_LANG = "lang";
    private String expression = null;
    private String lang = "en";
    private String description = null;

    public EPPLoginSecPolicyPassword() {
    }

    public EPPLoginSecPolicyPassword(String aExpression) {
        this.expression = aExpression;
    }

    public EPPLoginSecPolicyPassword(String aExpression, String aLang, String aDescription) {
        this.expression = aExpression;
        this.setLang(aLang);
        this.description = aDescription;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.expression == null) {
            throw new EPPEncodeException("expression is null in EPPLoginSecPolicyPassword.encode(Document).");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:loginSecPolicy-0.1", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.expression, "urn:ietf:params:xml:ns:epp:loginSecPolicy-0.1", "loginSecPolicy:expression");
        if (this.hasDescription()) {
            Element theDescriptionElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:loginSecPolicy-0.1", "loginSecPolicy:description");
            theDescriptionElm.setAttribute(ATTR_LANG, this.lang);
            Text theDescText = aDocument.createTextNode(this.description);
            theDescriptionElm.appendChild(theDescText);
            root.appendChild(theDescriptionElm);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.expression = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:loginSecPolicy-0.1", ELM_EXPRESSION);
        Element theDescriptionElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:epp:loginSecPolicy-0.1", ELM_DESCRIPTION);
        if (theDescriptionElm != null) {
            this.setLang(EPPUtil.decodeStringAttr(theDescriptionElm, ATTR_LANG));
            this.description = EPPUtil.getTextContent(theDescriptionElm, true);
            if (this.description != null && this.description.isEmpty()) {
                this.description = null;
            }
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPLoginSecPolicyPassword)) {
            return false;
        }
        EPPLoginSecPolicyPassword theComp = (EPPLoginSecPolicyPassword)aObject;
        if (!EqualityUtil.equals(this.expression, theComp.expression)) {
            cat.error((Object)"EPPLoginSecPolicyPassword.equals(): expression not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.lang, theComp.lang)) {
            cat.error((Object)"EPPLoginSecPolicyPassword.equals(): lang not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.description, theComp.description)) {
            cat.error((Object)"EPPLoginSecPolicyPassword.equals(): description not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String aExpression) {
        this.expression = aExpression;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String aLang) {
        this.lang = aLang == null ? DEFAULT_LANG : aLang;
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String aDesc) {
        this.description = aDesc;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:loginSecPolicy-0.1";
    }
}

