/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.loginsec.v03;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.loginsec.v03.EventLevel;
import com.verisign.epp.codec.loginsec.v03.EventType;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.Date;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPLoginSecEvent
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPLoginSecEvent.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String DEFAULT_LANG = "en";
    public static final String ELM_LOCALNAME = "event";
    public static final String ELM_NAME = "loginSec:event";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_TYPE_NAME = "name";
    private static final String ATTR_LEVEL = "level";
    private static final String ATTR_EXDATE = "exDate";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_DURATION = "duration";
    private static final String ATTR_LANG = "lang";
    private EventType type;
    private String typeName;
    private EventLevel level;
    private Date exDate;
    private String value;
    private String duration;
    private String lang = "en";
    private String description;

    public EPPLoginSecEvent() {
    }

    public EPPLoginSecEvent(EventType aType, EventLevel aLevel) {
        this.type = aType;
        this.level = aLevel;
    }

    public EPPLoginSecEvent(EventType aType, EventLevel aLevel, String aDescription) {
        this(aType, aLevel);
        this.description = aDescription;
    }

    public EPPLoginSecEvent(EventType aType, EventLevel aLevel, Date aExDate, String aDescription) {
        this(aType, aLevel);
        this.exDate = aExDate;
        this.description = aDescription;
    }

    public EPPLoginSecEvent(EventType aType, EventLevel aLevel, String aValue, String aDescription) {
        this(aType, aLevel);
        this.value = aValue;
        this.description = aDescription;
    }

    public EPPLoginSecEvent(EventType aType, String aTypeName, EventLevel aLevel, String aDescription) {
        this(aType, aLevel);
        this.typeName = aTypeName;
        this.description = aDescription;
    }

    public EPPLoginSecEvent(EventType aType, String aTypeName, EventLevel aLevel, String aValue, String aDuration, String aDescription) {
        this(aType, aLevel);
        this.typeName = aTypeName;
        this.value = aValue;
        this.duration = aDuration;
        this.description = aDescription;
    }

    public EventType getType() {
        return this.type;
    }

    public void setType(EventType aType) {
        this.type = aType;
    }

    public boolean hasTypeName() {
        return this.typeName != null;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String aTypeName) {
        this.typeName = aTypeName;
    }

    public EventLevel getLevel() {
        return this.level;
    }

    public void setLevel(EventLevel aLevel) {
        this.level = aLevel;
    }

    public boolean hasExDate() {
        return this.exDate != null;
    }

    public Date getExDate() {
        return this.exDate;
    }

    public void setExDate(Date aExDate) {
        this.exDate = aExDate;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String aValue) {
        this.value = aValue;
    }

    public boolean hasDuration() {
        return this.duration != null;
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String aDuration) {
        this.duration = aDuration;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String aLang) {
        this.lang = aLang == null || aLang.isEmpty() ? DEFAULT_LANG : aLang;
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String aDescription) {
        this.description = aDescription;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPLoginSecEvent.encode(Document)");
        }
        if (this.type == null) {
            throw new EPPEncodeException("type is null on in EPPLoginSecEvent.encode(Document)");
        }
        if (this.level == null) {
            throw new EPPEncodeException("level is null on in EPPLoginSecEvent.encode(Document)");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:loginSec-0.3", ELM_NAME);
        root.setAttribute(ATTR_TYPE, this.type.toString());
        if (this.hasTypeName()) {
            root.setAttribute(ATTR_TYPE_NAME, this.typeName);
        }
        root.setAttribute(ATTR_LEVEL, this.level.toString());
        if (this.hasExDate()) {
            root.setAttribute(ATTR_EXDATE, EPPUtil.encodeTimeInstant(this.exDate));
        }
        if (this.hasValue()) {
            root.setAttribute(ATTR_VALUE, this.value);
        }
        if (this.hasDuration()) {
            root.setAttribute(ATTR_DURATION, this.duration);
        }
        if (this.hasDescription()) {
            root.setAttribute(ATTR_LANG, this.lang);
            Text descriptionText = aDocument.createTextNode(this.description);
            root.appendChild(descriptionText);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        String theAttr = null;
        theAttr = aElement.getAttribute(ATTR_TYPE);
        this.type = theAttr != null && !theAttr.isEmpty() ? EventType.getEventType(theAttr) : null;
        theAttr = aElement.getAttribute(ATTR_TYPE_NAME);
        this.typeName = theAttr != null && !theAttr.isEmpty() ? theAttr : null;
        theAttr = aElement.getAttribute(ATTR_LEVEL);
        this.level = theAttr != null && !theAttr.isEmpty() ? EventLevel.getEventLevel(theAttr) : null;
        theAttr = aElement.getAttribute(ATTR_EXDATE);
        this.exDate = theAttr != null && !theAttr.isEmpty() ? EPPUtil.decodeTimeInstant(theAttr) : null;
        theAttr = aElement.getAttribute(ATTR_VALUE);
        this.value = theAttr != null && !theAttr.isEmpty() ? theAttr : null;
        theAttr = aElement.getAttribute(ATTR_DURATION);
        this.duration = theAttr != null && !theAttr.isEmpty() ? theAttr : null;
        this.description = EPPUtil.getTextContent(aElement, true);
        if (this.description.isEmpty()) {
            this.description = null;
        }
        this.setLang(aElement.getAttribute(ATTR_LANG));
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPLoginSecEvent)) {
            cat.error((Object)("EPPLoginSecEvent.equals(): " + aObject.getClass().getName() + " not EPPLoginSecEvent instance"));
            return false;
        }
        EPPLoginSecEvent other = (EPPLoginSecEvent)aObject;
        if (!EqualityUtil.equals((Object)this.type, (Object)other.type)) {
            cat.error((Object)"EPPLoginSecEvent.equals(): type not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.typeName, other.typeName)) {
            cat.error((Object)"EPPLoginSecEvent.equals(): typeName not equal");
            return false;
        }
        if (!EqualityUtil.equals((Object)this.level, (Object)other.level)) {
            cat.error((Object)"EPPLoginSecEvent.equals(): level not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.exDate, other.exDate)) {
            cat.error((Object)"EPPLoginSecEvent.equals(): exDate not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.value, other.value)) {
            cat.error((Object)"EPPLoginSecEvent.equals(): value not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.duration, other.duration)) {
            cat.error((Object)"EPPLoginSecEvent.equals(): duration not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.description, other.description)) {
            cat.error((Object)"EPPLoginSecEvent.equals(): description not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.lang, other.lang)) {
            cat.error((Object)"EPPLoginSecEvent.equals(): lang not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPLoginSecEvent clone = (EPPLoginSecEvent)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:loginSec-0.3";
    }
}

