/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.launch;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.launch.EPPLaunchPhase;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPLaunchCheck
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPLaunchCheck.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String TYPE_CLAIMS = "claims";
    public static final String TYPE_AVAILABILITY = "avail";
    public static final String TYPE_TRADEMARK = "trademark";
    public static final String ELM_LOCALNAME = "check";
    public static final String ELM_NAME = "launch:check";
    private static final String ATTR_TYPE = "type";
    private EPPLaunchPhase phase;
    private String type;

    public EPPLaunchCheck() {
    }

    public EPPLaunchCheck(EPPLaunchPhase aPhase) {
        this.phase = aPhase;
    }

    public EPPLaunchCheck(EPPLaunchPhase aPhase, String aType) {
        this.phase = aPhase;
        this.type = aType;
    }

    public EPPLaunchCheck(String aType) {
        this.type = aType;
    }

    public boolean hasType() {
        return this.type != null;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String aType) {
        this.type = aType;
    }

    public boolean hasPhase() {
        return this.phase != null;
    }

    public EPPLaunchPhase getPhase() {
        return this.phase;
    }

    public void setPhase(EPPLaunchPhase aPhase) {
        this.phase = aPhase;
    }

    public void setPhase(String aPhaseString) {
        this.phase = new EPPLaunchPhase(aPhaseString);
    }

    public boolean isClaimsCheckForm() {
        return this.type == null || this.type.equals(TYPE_CLAIMS);
    }

    public boolean isAvailabilityCheckForm() {
        return this.type != null && this.type.equals(TYPE_AVAILABILITY);
    }

    public boolean isTrademarkCheckForm() {
        return this.type != null && this.type.equals(TYPE_TRADEMARK);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPLaunchCheck clone = (EPPLaunchCheck)super.clone();
        return clone;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPLaunchCheck.encode(Document)");
        }
        if (this.isTrademarkCheckForm()) {
            if (this.phase != null) {
                throw new EPPEncodeException("EPPLaunchCheck phase attribute must not be set using Trademark Check Form.");
            }
        } else if (this.phase == null) {
            throw new EPPEncodeException("EPPLaunchCheck phase attribute must be set when not the Trademark Check Form.");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:launch-1.0", ELM_NAME);
        if (this.type != null) {
            if (!(this.type.equals(TYPE_CLAIMS) || this.type.equals(TYPE_AVAILABILITY) || this.type.equals(TYPE_TRADEMARK))) {
                throw new EPPEncodeException("EPPLaunchCheck type attribute with invalid value of: " + this.type);
            }
            root.setAttribute(ATTR_TYPE, this.type);
        }
        EPPUtil.encodeComp(aDocument, root, this.phase);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.type = aElement.getAttribute(ATTR_TYPE);
        if (this.type.isEmpty()) {
            this.type = null;
        }
        if (this.isClaimsCheckForm() || this.isAvailabilityCheckForm()) {
            this.phase = (EPPLaunchPhase)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:launch-1.0", "launch:phase", EPPLaunchPhase.class);
            if (this.phase == null) {
                throw new EPPDecodeException("EPPLaunchCheck phase element not found.");
            }
        } else if (this.isTrademarkCheckForm()) {
            this.phase = null;
        } else {
            throw new EPPDecodeException("EPPLaunchCheck invalid form on decode");
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPLaunchCheck)) {
            cat.error((Object)("EPPLaunchCheck.equals(): " + aObject.getClass().getName() + " not EPPLaunchCheck instance"));
            return false;
        }
        EPPLaunchCheck other = (EPPLaunchCheck)aObject;
        if (!EqualityUtil.equals(this.type, other.type)) {
            cat.error((Object)"EPPLaunchCheck.equals(): type not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.phase, other.phase)) {
            cat.error((Object)"EPPLaunchCheck.equals(): phase not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:launch-1.0";
    }
}

