/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.jobscontact;

import com.verisign.epp.codec.contact.EPPContactAddChange;
import com.verisign.epp.codec.contact.EPPContactAddress;
import com.verisign.epp.codec.contact.EPPContactCreateCmd;
import com.verisign.epp.codec.contact.EPPContactDisclose;
import com.verisign.epp.codec.contact.EPPContactInfoResp;
import com.verisign.epp.codec.contact.EPPContactPostalDefinition;
import com.verisign.epp.codec.contact.EPPContactStatus;
import com.verisign.epp.codec.contact.EPPContactUpdateCmd;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.jobscontact.EPPJobsContactCreateCmd;
import com.verisign.epp.codec.jobscontact.EPPJobsContactInfoResp;
import com.verisign.epp.codec.jobscontact.EPPJobsContactUpdateCmd;
import com.verisign.epp.util.TestThread;
import java.util.Date;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class EPPJobsContactTst
extends TestCase {
    private static long numIterations = 1L;

    public EPPJobsContactTst(String name) {
        super(name);
    }

    public void testJobsContactCreate() {
        EPPCodecTst.printStart("testJobsContactCreate");
        EPPCodecTst.printStart("testContactCreate");
        Vector<String> streets = new Vector<String>();
        streets.addElement("123 Example Dr.");
        streets.addElement("Suite 100");
        EPPContactAddress address = new EPPContactAddress(null, "Dulles", "VA", "20166-6503", "US");
        EPPContactPostalDefinition name = new EPPContactPostalDefinition("John Doe", "Example Inc.", "loc", address);
        EPPContactCreateCmd theCommand = new EPPContactCreateCmd("ABC-12345", "sh8013", name, "jdoe@example.com", new EPPAuthInfo("2fooBAR"));
        theCommand.setFax("+1.7035555556");
        theCommand.setFaxExt("123");
        theCommand.setVoice("+1.7035555555");
        theCommand.setVoiceExt("456");
        EPPContactDisclose disclose = new EPPContactDisclose();
        disclose.setFlag(false);
        disclose.setNameInt(true);
        disclose.setNameLoc(true);
        disclose.setOrgInt(true);
        disclose.setOrgLoc(true);
        disclose.setAddrInt(true);
        disclose.setAddrLoc(true);
        disclose.setVoice(false);
        disclose.setFax(false);
        disclose.setEmail(false);
        theCommand.setDisclose(disclose);
        theCommand.addExtension(new EPPJobsContactCreateCmd("create-title", "website", "IT", "Yes", "Yes"));
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testJobsContactCreate");
    }

    public void testJobsContactUpdate() {
        EPPCodecTst.printStart("testJobsContactUpdate");
        EPPContactUpdateCmd theCommand = null;
        EPPEncodeDecodeStats commandStats = null;
        EPPCodecTst.printStart("testContactUpate");
        Vector<String> streets = new Vector<String>();
        streets.addElement("123 Example Dr.");
        streets.addElement("Suite 100");
        EPPContactAddress address = new EPPContactAddress(streets, "Dulles", "VA", "20166-6503", "US");
        EPPContactPostalDefinition name = new EPPContactPostalDefinition("John", "loc", address);
        EPPContactAddChange change = new EPPContactAddChange(name, "+1.7034444444", new EPPAuthInfo("2BARfoo"));
        change.setVoiceExt("678");
        change.setFax("+1.7037777777");
        change.setFaxExt("678");
        EPPContactDisclose disclose = new EPPContactDisclose();
        disclose.setFlag(false);
        disclose.setNameInt(true);
        disclose.setNameLoc(true);
        disclose.setOrgInt(true);
        disclose.setOrgLoc(true);
        disclose.setAddrInt(true);
        disclose.setAddrLoc(true);
        disclose.setVoice(false);
        disclose.setFax(false);
        disclose.setEmail(false);
        change.setDisclose(disclose);
        Vector<EPPContactStatus> addStatuses = new Vector<EPPContactStatus>();
        addStatuses.addElement(new EPPContactStatus("clientDeleteProhibited"));
        addStatuses.addElement(new EPPContactStatus("clientDeleteProhibited", "Hello World", "en"));
        EPPContactAddChange add = new EPPContactAddChange(addStatuses);
        theCommand = new EPPContactUpdateCmd("ABC-12345", "sh8013", add, null, change);
        theCommand.addExtension(new EPPJobsContactUpdateCmd("update-title", "website", "IT", "Yes", "Yes"));
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testJobsContactUpdate");
    }

    public void testJobsContactInfo() {
        EPPCodecTst.printStart("testJobsContactInfo");
        Vector<String> streets = new Vector<String>();
        streets.addElement("123 Example Dr.");
        streets.addElement("Suite 100");
        EPPContactAddress address = new EPPContactAddress(streets, "Dulles", "VA", "20166-6503", "US");
        EPPContactPostalDefinition name = new EPPContactPostalDefinition("John Doe", "Example Inc.", "loc", address);
        Vector<String> i15dStreets = new Vector<String>();
        i15dStreets.addElement("i15d 123 Example Dr.");
        i15dStreets.addElement("i15d Suite 100");
        EPPContactAddress i15dAddress = new EPPContactAddress(i15dStreets, "Dulles", "VA", "20166-6503", "US");
        EPPContactPostalDefinition i15dName = new EPPContactPostalDefinition("i15d John Doe", "i15d Example Inc.", "int", i15dAddress);
        Vector<EPPContactStatus> infoStatuses = new Vector<EPPContactStatus>();
        infoStatuses.addElement(new EPPContactStatus("linked"));
        infoStatuses.addElement(new EPPContactStatus("clientUpdateProhibited"));
        EPPTransId respTransId = new EPPTransId("144", "54321-XYZ");
        EPPContactInfoResp theResponse = new EPPContactInfoResp(respTransId, "SH8013-VRSN", "sh8013", infoStatuses, name, "jdoe@example.com", "ClientY", "ClientX", new Date(), new EPPAuthInfo("2fooBAR"));
        theResponse.setVoice("+1.7035555555");
        theResponse.setFax("+1.7035555556");
        theResponse.addPostalInfo(i15dName);
        EPPContactDisclose disclose = new EPPContactDisclose();
        disclose.setFlag(true);
        disclose.setNameInt(true);
        disclose.setNameLoc(true);
        disclose.setOrgInt(true);
        disclose.setOrgLoc(true);
        disclose.setAddrInt(true);
        disclose.setAddrLoc(true);
        disclose.setVoice(false);
        disclose.setFax(false);
        disclose.setEmail(false);
        theResponse.setDisclose(disclose);
        theResponse.setResult(1000);
        theResponse.addExtension(new EPPJobsContactInfoResp("Info-title", "whois.example.com", "IT", "Yes", "Yes"));
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        theResponse.setLastUpdatedBy("ClientX");
        theResponse.setLastUpdatedDate(new Date());
        theResponse.setLastUpdatedDate(new Date());
        EPPCodecTst.printEnd("testJobsContactInfo");
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(EPPJobsContactTst.class);
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.contact.EPPContactMapFactory");
            EPPFactory.getInstance().addExtFactory("com.verisign.epp.codec.jobscontact.EPPJobsContactExtFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding EPPContactMapFactory or EPPJobsContactExtFactory to EPPCodec: " + e));
        }
        return suite;
    }

    public static void main(String[] args) {
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPJobsContactTst Thread " + i, EPPJobsContactTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPJobsContactTst.suite());
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }
}

