/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.idntable;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.idntable.EPPIdnTableInfoDomain;
import com.verisign.epp.codec.idntable.EPPIdnTableInfoListItem;
import com.verisign.epp.codec.idntable.EPPIdnTableInfoTable;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPIdnTableInfoResp
extends EPPResponse {
    private static Logger cat = Logger.getLogger((String)EPPIdnTableInfoResp.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "infData";
    public static final String ELM_NAME = "idnTable:infData";
    private static final String ELM_LIST = "list";
    private Form form = Form.LIST_FORM;
    private EPPIdnTableInfoDomain domain;
    private EPPIdnTableInfoTable table;
    private List<EPPIdnTableInfoListItem> list = new ArrayList<EPPIdnTableInfoListItem>();

    public EPPIdnTableInfoResp() {
    }

    public EPPIdnTableInfoResp(EPPTransId aTransId) {
        super(aTransId);
    }

    public EPPIdnTableInfoResp(EPPTransId aTransId, EPPIdnTableInfoDomain aDomain) {
        super(aTransId);
        this.setDomain(aDomain);
    }

    public EPPIdnTableInfoResp(EPPTransId aTransId, EPPIdnTableInfoTable aTable) {
        super(aTransId);
        this.setTable(aTable);
    }

    public EPPIdnTableInfoResp(EPPTransId aTransId, List<EPPIdnTableInfoListItem> aList) {
        super(aTransId);
        this.setList(aList);
    }

    public Form getForm() {
        return this.form;
    }

    public void setForm(Form aForm) {
        this.form = aForm;
    }

    public EPPIdnTableInfoDomain getDomain() {
        return this.domain;
    }

    public void setDomain(EPPIdnTableInfoDomain aDomain) {
        this.domain = aDomain;
        if (this.domain != null) {
            this.setForm(Form.DOMAIN_FORM);
        }
    }

    public EPPIdnTableInfoTable getTable() {
        return this.table;
    }

    public void setTable(EPPIdnTableInfoTable aTable) {
        this.table = aTable;
        if (this.table != null) {
            this.setForm(Form.TABLE_FORM);
        }
    }

    public void addListItem(EPPIdnTableInfoListItem aListItem) {
        if (aListItem != null) {
            this.list.add(aListItem);
            this.setForm(Form.LIST_FORM);
        }
    }

    public List<EPPIdnTableInfoListItem> getList() {
        return this.list;
    }

    public void setList(List<EPPIdnTableInfoListItem> aList) {
        this.list = aList;
        if (this.list != null) {
            this.setForm(Form.LIST_FORM);
        } else {
            this.list = new ArrayList<EPPIdnTableInfoListItem>();
        }
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:idnTable-1.0", ELM_NAME);
        switch (this.form) {
            case DOMAIN_FORM: {
                if (this.domain == null) {
                    throw new EPPEncodeException("domain is null in EPPIdnTableInfoResp with Domain Info Form");
                }
                EPPUtil.encodeComp(aDocument, root, this.domain);
                break;
            }
            case TABLE_FORM: {
                if (this.table == null) {
                    throw new EPPEncodeException("table is null in EPPIdnTableInfoResp with Table Info Form");
                }
                EPPUtil.encodeComp(aDocument, root, this.table);
                break;
            }
            case LIST_FORM: {
                Element list = aDocument.createElementNS("urn:ietf:params:xml:ns:idnTable-1.0", "idnTable:list");
                EPPUtil.encodeCompList(aDocument, list, this.list);
                root.appendChild(list);
            }
        }
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.domain = null;
        this.table = null;
        this.list = new ArrayList<EPPIdnTableInfoListItem>();
        Element theListElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:idnTable-1.0", ELM_LIST);
        if (theListElm != null) {
            this.list = EPPUtil.decodeCompList(theListElm, "urn:ietf:params:xml:ns:idnTable-1.0", "idnTable:table", EPPIdnTableInfoListItem.class);
            this.setForm(Form.LIST_FORM);
            return;
        }
        this.domain = (EPPIdnTableInfoDomain)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:idnTable-1.0", "idnTable:domain", EPPIdnTableInfoDomain.class);
        if (this.domain != null) {
            this.setForm(Form.DOMAIN_FORM);
            return;
        }
        this.table = (EPPIdnTableInfoTable)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:idnTable-1.0", "idnTable:table", EPPIdnTableInfoTable.class);
        if (this.table != null) {
            this.setForm(Form.TABLE_FORM);
            return;
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPIdnTableInfoResp clone = (EPPIdnTableInfoResp)super.clone();
        clone.domain = this.domain != null ? (EPPIdnTableInfoDomain)this.domain.clone() : null;
        clone.table = this.table != null ? (EPPIdnTableInfoTable)this.table.clone() : null;
        clone.list = (List)((ArrayList)this.list).clone();
        return clone;
    }

    @Override
    public String getType() {
        return ELM_NAME;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:idnTable-1.0";
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPIdnTableInfoResp)) {
            return false;
        }
        EPPIdnTableInfoResp other = (EPPIdnTableInfoResp)aObject;
        if (!EqualityUtil.equals(this.domain, other.domain)) {
            cat.error((Object)"EPPIdnTableInfoResp.equals(): domain not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.table, other.table)) {
            cat.error((Object)"EPPIdnTableInfoResp.equals(): table not equal");
            return false;
        }
        if (!EPPUtil.equalLists(this.list, other.list)) {
            cat.error((Object)"EPPIdnTableInfoResp.equals(): list not equal");
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public static enum Form {
        DOMAIN_FORM,
        TABLE_FORM,
        LIST_FORM;

    }
}

