/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.host;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.host.EPPHostAddress;
import com.verisign.epp.codec.host.EPPHostStatus;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPHostAddRemove
implements EPPCodecComponent {
    static final short MODE_NONE = 0;
    static final short MODE_ADD = 1;
    static final short MODE_REMOVE = 2;
    static final String ELM_ADD = "host:add";
    static final String ELM_REMOVE = "host:rem";
    static final String ELM_CHANGE = "host:chg";
    static final String ELM_NAME = "host:name";
    static final short MODE_CHANGE = 3;
    private String name = null;
    private Vector statuses = null;
    private short mode = 0;
    private Vector addresses = null;

    public EPPHostAddRemove() {
        this.addresses = null;
        this.statuses = null;
        this.name = null;
    }

    public EPPHostAddRemove(Vector aAddresses) {
        this.setAddresses(aAddresses);
        this.statuses = null;
        this.name = null;
    }

    public EPPHostAddRemove(String aName) {
        this.addresses = null;
        this.statuses = null;
        this.name = aName;
    }

    public EPPHostAddRemove(Vector aAddresses, Vector aStatuses) {
        this.setAddresses(aAddresses);
        this.setStatuses(aStatuses);
        this.name = null;
    }

    public Vector getAddresses() {
        return this.addresses;
    }

    public void setAddresses(Vector aAddresses) {
        this.addresses = aAddresses;
        if (this.addresses != null && this.addresses.size() == 0) {
            this.addresses = null;
        }
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root;
        if (this.mode == 1) {
            root = aDocument.createElementNS("urn:ietf:params:xml:ns:host-1.0", ELM_ADD);
        } else if (this.mode == 2) {
            root = aDocument.createElementNS("urn:ietf:params:xml:ns:host-1.0", ELM_REMOVE);
        } else if (this.mode == 3) {
            root = aDocument.createElementNS("urn:ietf:params:xml:ns:host-1.0", ELM_CHANGE);
        } else {
            throw new EPPEncodeException("Invalid EPPHostAddRemove mode of " + this.mode);
        }
        if (this.mode == 3) {
            EPPUtil.encodeString(aDocument, root, this.name, "urn:ietf:params:xml:ns:host-1.0", ELM_NAME);
        } else {
            EPPUtil.encodeCompVector(aDocument, root, this.addresses);
            EPPUtil.encodeCompVector(aDocument, root, this.statuses);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        if (aElement.getLocalName().equals(EPPUtil.getLocalName(ELM_ADD))) {
            this.mode = 1;
        } else if (aElement.getLocalName().equals(EPPUtil.getLocalName(ELM_REMOVE))) {
            this.mode = (short)2;
        } else if (aElement.getLocalName().equals(EPPUtil.getLocalName(ELM_CHANGE))) {
            this.mode = (short)3;
        } else {
            throw new EPPDecodeException("Invalid EPPHostAddRemove mode of " + aElement.getLocalName());
        }
        if (this.mode == 3) {
            this.name = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:host-1.0", ELM_NAME);
        } else {
            this.addresses = EPPUtil.decodeCompVector(aElement, "urn:ietf:params:xml:ns:host-1.0", "host:addr", EPPHostAddress.class);
            if (this.addresses.size() == 0) {
                this.addresses = null;
            }
            this.statuses = EPPUtil.decodeCompVector(aElement, "urn:ietf:params:xml:ns:host-1.0", "host:status", EPPHostStatus.class);
            if (this.statuses.size() == 0) {
                this.statuses = null;
            }
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPHostAddRemove)) {
            return false;
        }
        EPPHostAddRemove theComp = (EPPHostAddRemove)aObject;
        if (this.mode != theComp.mode) {
            return false;
        }
        if (!EPPUtil.equalVectors(this.addresses, theComp.addresses)) {
            return false;
        }
        if (!EPPUtil.equalVectors(this.statuses, theComp.statuses)) {
            return false;
        }
        return this.name != null ? this.name.equals(theComp.name) : theComp.name == null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        int i;
        EPPHostAddRemove clone = null;
        clone = (EPPHostAddRemove)super.clone();
        if (this.addresses != null) {
            clone.addresses = (Vector)this.addresses.clone();
            for (i = 0; i < this.addresses.size(); ++i) {
                clone.addresses.setElementAt(((EPPHostAddress)this.addresses.elementAt(i)).clone(), i);
            }
        }
        if (this.statuses != null) {
            clone.statuses = (Vector)this.statuses.clone();
            for (i = 0; i < this.statuses.size(); ++i) {
                clone.statuses.setElementAt(((EPPHostStatus)this.statuses.elementAt(i)).clone(), i);
            }
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    short getMode() {
        return this.mode;
    }

    void setMode(short aMode) {
        this.mode = aMode;
    }

    public String getName() {
        return this.name;
    }

    public Vector getStatuses() {
        return this.statuses;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public void setStatuses(Vector aStatuses) {
        this.statuses = aStatuses;
        if (this.statuses != null && this.statuses.size() == 0) {
            this.statuses = null;
        }
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:host-1.0";
    }
}

