/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.gen;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class EPPValue
implements EPPCodecComponent {
    private static DocumentBuilderFactory factory = null;
    static final String ELM_NAME = "value";
    private static Logger cat;
    private String value;
    private String prefix = null;
    private String namespace = "urn:ietf:params:xml:ns:epp-1.0";

    public EPPValue() {
    }

    public EPPValue(String aValue) {
        this.value = aValue;
    }

    public EPPValue(String aValue, String aPrefix, String aNamespace) {
        this.value = aValue;
        this.prefix = aPrefix;
        this.setNamespace(aNamespace);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String aValue) {
        this.value = aValue;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String aPrefix) {
        this.prefix = aPrefix;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String aNamespace) {
        this.namespace = aNamespace;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", ELM_NAME);
        if (this.namespace != null) {
            String thePrefix = "xmlns";
            if (this.prefix != null) {
                thePrefix = thePrefix + ":" + this.prefix;
            }
            root.setAttributeNS("http://www.w3.org/2000/xmlns/", thePrefix, this.namespace);
        }
        DocumentBuilder theParser = null;
        try {
            theParser = factory.newDocumentBuilder();
        }
        catch (Exception ex) {
            cat.error((Object)("EPPValue.encode(): error creating DocumentBuilder: " + ex));
            throw new EPPEncodeException("Error creating DocumentBuilder: " + ex);
        }
        ByteArrayInputStream theValueStream = new ByteArrayInputStream(this.value.getBytes());
        Document theValueDoc = null;
        try {
            theValueDoc = theParser.parse(theValueStream);
        }
        catch (Exception ex) {
            cat.error((Object)("EPPValue.encode(): error parsing value [" + this.value + "]: " + ex));
            throw new EPPEncodeException("Error parsing value [" + this.value + "]: " + ex);
        }
        Element theValueElm = theValueDoc.getDocumentElement();
        root.appendChild(aDocument.importNode(theValueElm, true));
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        Element valueNode = EPPUtil.getFirstElementChild(aElement);
        if (valueNode == null) {
            cat.error((Object)"EPPValue.decode(): value node could not be found");
            throw new EPPDecodeException("EPPValue.decode(): value node could not be found");
        }
        NamedNodeMap theAttrs = aElement.getAttributes();
        for (int i = 0; i < theAttrs.getLength(); ++i) {
            Node theAttr = theAttrs.item(i);
            System.out.println("theAttr Namespace URI = " + theAttr.getNamespaceURI());
            if (!theAttr.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) continue;
            this.prefix = theAttr.getLocalName();
            this.namespace = theAttr.getNodeValue();
            break;
        }
        System.out.println("prefix = " + this.prefix + ", namespace = " + this.namespace);
        this.value = EPPUtil.toString(valueNode);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPValue)) {
            cat.error((Object)("EPPValue.equals(): " + aObject.getClass().getName() + " not EPPValue instance"));
            return false;
        }
        EPPValue theComp = (EPPValue)aObject;
        if (!EqualityUtil.equals(this.namespace, theComp.namespace)) {
            cat.error((Object)("this.prefix = " + this.prefix + ", theComp.prefix = " + theComp.prefix));
            cat.error((Object)("this.namespace = " + this.namespace + ", theComp.namespace = " + theComp.namespace));
            cat.error((Object)"EPPValue.equals(): namespace not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPValue clone = null;
        clone = (EPPValue)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    static {
        factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        cat = Logger.getLogger((String)EPPValue.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    }
}

