/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.gen;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPExtValue;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.gen.EPPValue;
import com.verisign.epp.util.EPPCatFactory;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class EPPResult
implements EPPCodecComponent {
    public static final String DEFAULT_LANG = "en";
    public static final int SUCCESS = 1000;
    public static final int SUCCESS_PENDING = 1001;
    public static final int SUCCESS_POLL_NO_MSGS = 1300;
    public static final int SUCCESS_POLL_MSG = 1301;
    public static final int SUCCESS_END_SESSION = 1500;
    public static final int UNKNOWN_COMMAND = 2000;
    public static final int COMMAND_SYNTAX_ERROR = 2001;
    public static final int COMMAND_USE_ERROR = 2002;
    public static final int MISSING_PARAMETER = 2003;
    public static final int PARAM_OUT_OF_RANGE = 2004;
    public static final int PARAM_SYNTAX_ERROR = 2005;
    public static final int UNIMPLEMENTED_VERSION = 2100;
    public static final int UNIMPLEMENTED_COMMAND = 2101;
    public static final int UNIMPLEMENTED_OPTION = 2102;
    public static final int UNIMPLEMENTED_EXTENSION = 2103;
    public static final int BILLING_ERROR = 2104;
    public static final int NOT_RENEWABLE = 2105;
    public static final int NOT_TRANSFERABLE = 2106;
    public static final int AUTHENTICATION_ERROR = 2200;
    public static final int AUTHORIZATION_ERROR = 2201;
    public static final int INVALID_AUTHORIZATION_INFO = 2202;
    public static final int OBJECT_PENDING_TRANSFER = 2300;
    public static final int OBJECT_NOT_PENDING_TRANSFER = 2301;
    public static final int OBJECT_EXISTS = 2302;
    public static final int OBJECT_DOES_NOT_EXIST = 2303;
    public static final int STATUS_PROHIBITS_OP = 2304;
    public static final int ASSOC_PROHIBITS_OP = 2305;
    public static final int PARAM_VALUE_POLICY_ERROR = 2306;
    public static final int UNIMPLEMENTED_OBJECT_SERVICE = 2307;
    public static final int DATA_MGT_POLICY_VIOLATION = 2308;
    public static final int COMMAND_FAILED = 2400;
    public static final int COMMAND_FAILED_END = 2500;
    public static final int AUTHENTICATION_ERROR_END = 2501;
    public static final int SESSION_LIMIT_END = 2502;
    private static Hashtable defaultMsg = new Hashtable();
    static final String ELM_NAME = "result";
    private static final String ELM_MSG = "msg";
    private static final String ELM_DATA = "data";
    private static final String ELM_EXT_VALUE = "extValue";
    private static final String ATTR_CODE = "code";
    private static final String ATTR_LANG = "lang";
    private static Logger cat;
    private int code = -1;
    private String message = "";
    private Vector values = null;
    private Vector extValues = null;
    private String lang = "en";

    public EPPResult() {
        this.code = 1000;
        this.message = (String)defaultMsg.get(this.code);
    }

    public EPPResult(int aCode) {
        this.code = aCode;
        this.message = (String)defaultMsg.get(aCode);
    }

    public EPPResult(int aCode, String aMessage) {
        this.code = aCode;
        this.message = aMessage;
    }

    public EPPResult(int aCode, String aMessage, String aLang) {
        this.code = aCode;
        this.message = aMessage;
        this.lang = aLang;
    }

    public EPPResult(int aCode, String aMessage, Vector aValues) {
        this.code = aCode;
        this.message = aMessage;
        this.setAllValues(aValues);
    }

    public EPPResult(int aCode, String aMessage, String aLang, Vector aValues) {
        this.code = aCode;
        this.message = aMessage;
        this.lang = aLang;
        this.setAllValues(aValues);
    }

    public void addValue(String aValue) {
        if (this.values == null) {
            this.values = new Vector();
        }
        this.values.addElement(new EPPValue(aValue));
    }

    public void addValue(EPPValue aValue) {
        if (this.values == null) {
            this.values = new Vector();
        }
        this.values.addElement(aValue);
    }

    public void addExtValueReason(String aReason) {
        if (this.extValues == null) {
            this.extValues = new Vector();
        }
        this.extValues.addElement(new EPPExtValue(aReason));
    }

    public void addExtValue(EPPExtValue aExtValue) {
        if (this.extValues == null) {
            this.extValues = new Vector();
        }
        this.extValues.addElement(aExtValue);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        int i;
        EPPResult clone = null;
        clone = (EPPResult)super.clone();
        if (this.values != null) {
            clone.values = (Vector)this.values.clone();
            for (i = 0; i < this.values.size(); ++i) {
                clone.values.set(i, ((EPPValue)this.values.elementAt(i)).clone());
            }
        }
        if (this.extValues != null) {
            clone.extValues = (Vector)this.extValues.clone();
            for (i = 0; i < this.extValues.size(); ++i) {
                clone.extValues.set(i, ((EPPExtValue)this.extValues.elementAt(i)).clone());
            }
        }
        return clone;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.code = Integer.parseInt(aElement.getAttribute(ATTR_CODE));
        NodeList currElmList = aElement.getElementsByTagNameNS("urn:ietf:params:xml:ns:epp-1.0", ELM_MSG);
        if (currElmList.getLength() == 0) {
            throw new EPPDecodeException("Required EPPResult element msg not found");
        }
        Element currElm = (Element)currElmList.item(0);
        this.message = currElm.getFirstChild().getNodeValue();
        if (this.message == null) {
            throw new EPPDecodeException("Required message value of EPPResult element msg not found");
        }
        this.setLang(currElm.getAttribute(ATTR_LANG));
        this.values = EPPUtil.decodeCompVector(aElement, "urn:ietf:params:xml:ns:epp-1.0", "value", EPPValue.class);
        if (this.values.size() == 0) {
            this.values = null;
        }
        this.extValues = EPPUtil.decodeCompVector(aElement, "urn:ietf:params:xml:ns:epp-1.0", ELM_EXT_VALUE, EPPExtValue.class);
        if (this.extValues.size() == 0) {
            this.extValues = null;
        }
        currElmList = aElement.getElementsByTagNameNS("urn:ietf:params:xml:ns:epp-1.0", ELM_DATA);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", ELM_NAME);
        root.setAttribute(ATTR_CODE, this.code + "");
        Element currElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", ELM_MSG);
        Text currVal = aDocument.createTextNode(this.message);
        if (!this.lang.equals(DEFAULT_LANG)) {
            currElm.setAttribute(ATTR_LANG, this.lang);
        }
        currElm.appendChild(currVal);
        root.appendChild(currElm);
        EPPUtil.encodeCompVector(aDocument, root, this.values);
        EPPUtil.encodeCompVector(aDocument, root, this.extValues);
        return root;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPResult)) {
            cat.error((Object)("EPPResult.equals(): " + aObject.getClass().getName() + " not EPPResult instance"));
            return false;
        }
        EPPResult theResult = (EPPResult)aObject;
        if (this.code != theResult.code) {
            cat.error((Object)"EPPResult.equals(): code not equal");
            return false;
        }
        if (!(this.message != null ? this.message.equals(theResult.message) : theResult.message == null)) {
            cat.error((Object)"EPPResult.equals(): message not equal");
            return false;
        }
        if (!this.lang.equals(theResult.lang)) {
            cat.error((Object)"EPPResult.equals(): lang not equal");
            return false;
        }
        if (!EPPUtil.equalVectors(this.values, theResult.values)) {
            cat.error((Object)"EPPResult.equals(): values not equal");
            return false;
        }
        if (!EPPUtil.equalVectors(this.extValues, theResult.extValues)) {
            cat.error((Object)"EPPResult.equals(): extValues not equal");
            return false;
        }
        return true;
    }

    public int getCode() {
        return this.code;
    }

    public String getLang() {
        return this.lang;
    }

    public String getMessage() {
        return this.message;
    }

    public Vector getValues() {
        return this.values;
    }

    public Vector getExtValues() {
        return this.extValues;
    }

    public Vector getAllValues() {
        if (this.values == null && this.extValues == null) {
            return null;
        }
        if (this.values == null) {
            return this.extValues;
        }
        if (this.extValues == null) {
            return this.values;
        }
        Vector theValues = new Vector();
        theValues.addAll(this.values);
        theValues.addAll(this.extValues);
        return theValues;
    }

    public void setAllValues(Vector aValues) {
        if (aValues != null) {
            for (Object currValue : aValues) {
                if (currValue instanceof EPPValue) {
                    this.addValue((EPPValue)currValue);
                    continue;
                }
                if (currValue instanceof EPPExtValue) {
                    this.addExtValue((EPPExtValue)currValue);
                    continue;
                }
                cat.error((Object)("EPPResult.setAllValues(): " + currValue.getClass().getName() + " not EPPValue or EPPExtValue instance"));
            }
        }
    }

    public Vector getStrValues() {
        if (this.values == null) {
            return null;
        }
        Vector<String> theStrValues = new Vector<String>();
        for (EPPValue currValue : this.values) {
            theStrValues.add(currValue.getValue());
        }
        return theStrValues;
    }

    public boolean isSuccess() {
        return this.code >= 1000 && this.code < 2000;
    }

    public boolean shouldCloseSession() {
        return this.code == 2500 || this.code == 2501 || this.code == 2502 || this.code == 1500;
    }

    public void setCode(int aCode) {
        this.code = aCode;
    }

    public void setCode(int aCode, boolean aUseDefaultMessage) {
        this.code = aCode;
        if (aUseDefaultMessage) {
            this.message = (String)defaultMsg.get(aCode);
        }
    }

    public void setLang(String aLang) {
        this.lang = aLang == null || aLang.equals("") ? DEFAULT_LANG : aLang;
    }

    public void setMessage(String aMessage) {
        this.message = aMessage;
    }

    public void setMessage(String aMessage, String aLang) {
        this.message = aMessage;
        this.setLang(aLang);
    }

    public void setValues(EPPValue[] aValues) {
        this.values = new Vector();
        this.values.copyInto(aValues);
    }

    public void setValues(Vector aValues) {
        this.values = aValues;
    }

    public void setExtValues(EPPExtValue[] aExtValues) {
        this.extValues = new Vector();
        this.extValues.copyInto(aExtValues);
    }

    public void setExtValues(Vector aExtValues) {
        this.extValues = aExtValues;
    }

    public void setExtValueReasons(Vector aReasons) {
        if (aReasons != null) {
            Iterator theIter = aReasons.iterator();
            while (theIter.hasNext()) {
                this.addExtValueReason((String)theIter.next());
            }
        }
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp-1.0";
    }

    static {
        defaultMsg.put(1000, "Command completed successfully");
        defaultMsg.put(1001, "Command completed successfully; action pending");
        defaultMsg.put(1300, "Command completed successfully; no messages");
        defaultMsg.put(1301, "Command completed successfully; ack to dequeue");
        defaultMsg.put(1500, "Command completed successfully; ending session");
        defaultMsg.put(2000, "Unknown command");
        defaultMsg.put(2001, "Command syntax error");
        defaultMsg.put(2002, "Command use error");
        defaultMsg.put(2003, "Required parameter missing");
        defaultMsg.put(2004, "Parameter value range error");
        defaultMsg.put(2005, "Parameter value syntax error");
        defaultMsg.put(2100, "Unimplemented protocol version");
        defaultMsg.put(2101, "Unimplemented command");
        defaultMsg.put(2102, "Unimplemented option");
        defaultMsg.put(2103, "Unimplemented extension");
        defaultMsg.put(2104, "Billing failure");
        defaultMsg.put(2105, "Object is not eligible for renewal");
        defaultMsg.put(2106, "Object is not eligible for transfer");
        defaultMsg.put(2200, "Authentication error");
        defaultMsg.put(2201, "Authorization error");
        defaultMsg.put(2202, "Invalid authorization information");
        defaultMsg.put(2300, "Object pending transfer");
        defaultMsg.put(2301, "Object not pending transfer");
        defaultMsg.put(2302, "Object exists");
        defaultMsg.put(2303, "Object does not exist");
        defaultMsg.put(2304, "Object status prohibits operation");
        defaultMsg.put(2305, "Object association prohibits operation");
        defaultMsg.put(2306, "Parameter value policy error");
        defaultMsg.put(2307, "Unimplemented object service");
        defaultMsg.put(2308, "Data management policy violation");
        defaultMsg.put(2400, "Command failed");
        defaultMsg.put(2500, "Command failed; server closing connection");
        defaultMsg.put(2501, "Authentication error; server closing connection");
        defaultMsg.put(2502, "Session limit exceeded; server closing connection");
        cat = Logger.getLogger((String)EPPResult.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    }
}

