/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.gen;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPExtValue;
import com.verisign.epp.codec.gen.EPPPollMessageFilter;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.codec.gen.EPPService;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.gen.EPPValue;
import com.verisign.epp.exception.EPPException;
import com.verisign.epp.util.EPPCatFactory;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class EPPFullExtValuePollMessageFilter
implements EPPPollMessageFilter {
    private static Logger cat = Logger.getLogger((String)EPPFullExtValuePollMessageFilter.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());

    @Override
    public EPPResponse filter(EPPResponse aResponse, List<EPPService> aServices, List<EPPService> aExtServices) throws EPPException {
        return this.filter(aResponse, aServices, aExtServices, false);
    }

    @Override
    public EPPResponse filter(EPPResponse aResponse, List<EPPService> aServices, List<EPPService> aExtServices, boolean aNoOp) throws EPPException {
        cat.debug((Object)("filter(EPPResponse, List, List, boolean): enter - NoOp = " + aNoOp));
        EPPResponse theResponse = null;
        boolean theResponseFiltered = false;
        if (aResponse == null) {
            throw new EPPException("EPPFullExtValuePollMessageFilter.filter(): null poll message EPPResponse passed");
        }
        if (!aResponse.hasMsgQueue()) {
            cat.debug((Object)"filter(EPPResponse, List, List, boolean): exit - the response does not contain a poll message.");
            return aResponse;
        }
        try {
            aResponse.getMsgQueueMsg();
            if (!aResponse.getClass().getName().equals(EPPResponse.class.getName())) {
                if (!this.supportsNamespace(aResponse.getNamespace(), aServices)) {
                    if (!aNoOp) {
                        theResponseFiltered = true;
                        EPPExtValue theExtValue = this.createObjectExtValue(aResponse);
                        EPPResult theResult = (EPPResult)aResponse.getResult().clone();
                        theResult.addExtValue(theExtValue);
                        theResponse = new EPPResponse(aResponse.getTransId(), theResult);
                        theResponse.setMsgQueue(aResponse.getMsgQueue());
                        theResponse.setExtensions(aResponse.getExtensions());
                    } else {
                        cat.info((Object)("filter(EPPResponse, List, List, boolean): object service [" + aResponse.getNamespace() + "] not supported"));
                        theResponse = (EPPResponse)aResponse.clone();
                    }
                } else {
                    theResponse = (EPPResponse)aResponse.clone();
                }
            } else {
                theResponse = (EPPResponse)aResponse.clone();
            }
            Vector theExtensions = theResponse.getExtensions();
            if (theExtensions != null) {
                Iterator iterator = theExtensions.iterator();
                while (iterator.hasNext()) {
                    EPPCodecComponent theExtension = (EPPCodecComponent)iterator.next();
                    if (this.supportsNamespace(theExtension.getNamespace(), aExtServices)) continue;
                    if (!aNoOp) {
                        theResponseFiltered = true;
                        theResponse.getResult().addExtValue(this.createExtensionExtValue(theExtension));
                        iterator.remove();
                        continue;
                    }
                    cat.info((Object)("filter(EPPResponse, List, List, boolean): extension service [" + theExtension.getNamespace() + "] not supported"));
                }
            }
        }
        catch (Exception ex) {
            cat.error((Object)("Unexpected exception: " + ex + " filtering the poll message: " + aResponse));
            throw new EPPException("Exception filtering poll message", ex);
        }
        if (theResponseFiltered) {
            cat.info((Object)("Filtered poll message [" + aResponse + "] to [" + theResponse + "]"));
        } else {
            cat.debug((Object)("Not filtered poll message [" + aResponse + "]"));
        }
        cat.debug((Object)"filter(EPPResponse, List, List): exit");
        return theResponse;
    }

    private boolean supportsNamespace(String aNamespace, List<EPPService> aServices) {
        cat.debug((Object)("supportsNamespace(String, List); Looking for namespace " + aNamespace + " support"));
        if (aServices != null) {
            for (EPPService theService : aServices) {
                if (!theService.getNamespaceURI().equals(aNamespace)) continue;
                cat.debug((Object)("supportsNamespace(String, List); namespace " + aNamespace + " supported"));
                return true;
            }
        }
        cat.debug((Object)("supportsNamespace(String, List); namespace " + aNamespace + " not supported"));
        return false;
    }

    private EPPExtValue createExtensionExtValue(EPPCodecComponent aExtension) throws EPPException {
        EPPExtValue theExtValue = new EPPExtValue();
        DocumentImpl theDoc = new DocumentImpl();
        Element theRootElm = aExtension.encode((Document)theDoc);
        theExtValue.setValue(new EPPValue(EPPUtil.toString(theRootElm), theRootElm.getPrefix(), theRootElm.getNamespaceURI()));
        theExtValue.setReason(theRootElm.getNamespaceURI() + " not in login services");
        return theExtValue;
    }

    private EPPExtValue createObjectExtValue(EPPResponse aResponse) throws EPPException {
        EPPExtValue theExtValue = new EPPExtValue();
        DocumentImpl theDoc = new DocumentImpl();
        Element theRootElm = aResponse.encode((Document)theDoc);
        NodeList theResDataElm = theRootElm.getElementsByTagNameNS("urn:ietf:params:xml:ns:epp-1.0", EPPUtil.getLocalName("resData"));
        if (theResDataElm.getLength() != 1) {
            throw new EPPException("Response does not include a <resData> element");
        }
        Element theObjectElm = EPPUtil.getFirstElementChild((Element)theResDataElm.item(0));
        if (theObjectElm == null) {
            throw new EPPException("Response object data element not found");
        }
        String theObjectXml = EPPUtil.toString(theObjectElm);
        theExtValue.setValue(new EPPValue(theObjectXml, theObjectElm.getPrefix(), theObjectElm.getNamespaceURI()));
        theExtValue.setReason(aResponse.getNamespace() + " not in login services");
        return theExtValue;
    }
}

