/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.gen;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPExtValue;
import com.verisign.epp.codec.gen.EPPPollMessageFilter;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.codec.gen.EPPService;
import com.verisign.epp.codec.gen.EPPValue;
import com.verisign.epp.exception.EPPException;
import com.verisign.epp.util.EPPCatFactory;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class EPPExtValuePollMessageFilter
implements EPPPollMessageFilter {
    private static Logger cat = Logger.getLogger((String)EPPExtValuePollMessageFilter.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());

    @Override
    public EPPResponse filter(EPPResponse aResponse, List<EPPService> aServices, List<EPPService> aExtServices) throws EPPException {
        return this.filter(aResponse, aServices, aExtServices, false);
    }

    @Override
    public EPPResponse filter(EPPResponse aResponse, List<EPPService> aServices, List<EPPService> aExtServices, boolean aNoOp) throws EPPException {
        cat.debug((Object)("filter(EPPResponse, List, List, boolean): enter - NoOp = " + aNoOp));
        EPPResponse theResponse = null;
        boolean theResponseFiltered = false;
        if (aResponse == null) {
            throw new EPPException("EPPExtValuePollMessageFilter.filter(): null poll message EPPResponse passed");
        }
        if (!aResponse.hasMsgQueue()) {
            cat.debug((Object)"filter(EPPResponse, List, List, boolean): exit - the response does not contain a poll message.");
            return aResponse;
        }
        try {
            aResponse.getMsgQueueMsg();
            if (!aResponse.getClass().getName().equals(EPPResponse.class.getName())) {
                if (!this.supportsNamespace(aResponse.getNamespace(), aServices)) {
                    if (!aNoOp) {
                        theResponseFiltered = true;
                        EPPExtValue theExtValue = this.createExtValue(aResponse.getNamespace());
                        EPPResult theResult = (EPPResult)aResponse.getResult().clone();
                        theResult.addExtValue(theExtValue);
                        theResponse = new EPPResponse(aResponse.getTransId(), theResult);
                        theResponse.setMsgQueue(aResponse.getMsgQueue());
                        theResponse.setExtensions(aResponse.getExtensions());
                    } else {
                        cat.info((Object)("filter(EPPResponse, List, List, boolean): object service [" + aResponse.getNamespace() + "] not supported"));
                        theResponse = (EPPResponse)aResponse.clone();
                    }
                } else {
                    theResponse = (EPPResponse)aResponse.clone();
                }
            } else {
                theResponse = (EPPResponse)aResponse.clone();
            }
            Vector theExtensions = theResponse.getExtensions();
            if (theExtensions != null) {
                Iterator iterator = theExtensions.iterator();
                while (iterator.hasNext()) {
                    EPPCodecComponent theExtension = (EPPCodecComponent)iterator.next();
                    if (this.supportsNamespace(theExtension.getNamespace(), aExtServices)) continue;
                    if (!aNoOp) {
                        theResponseFiltered = true;
                        theResponse.getResult().addExtValue(this.createExtValue(theExtension.getNamespace()));
                        iterator.remove();
                        continue;
                    }
                    cat.info((Object)("filter(EPPResponse, List, List, boolean): extension service [" + theExtension.getNamespace() + "] not supported"));
                }
            }
        }
        catch (Exception ex) {
            cat.error((Object)("Unexpected exception: " + ex + " filtering the poll message: " + aResponse));
            throw new EPPException("Exception filtering poll message", ex);
        }
        if (theResponseFiltered) {
            cat.info((Object)("Filtered poll message [" + aResponse + "] to [" + theResponse + "]"));
        } else {
            cat.debug((Object)("Not filtered poll message [" + aResponse + "]"));
        }
        cat.debug((Object)"filter(EPPResponse, List, List): exit");
        return theResponse;
    }

    private boolean supportsNamespace(String aNamespace, List<EPPService> aServices) {
        cat.debug((Object)("supportsNamespace(String, List); Looking for namespace " + aNamespace + " support"));
        if (aServices != null) {
            for (EPPService theService : aServices) {
                if (!theService.getNamespaceURI().equals(aNamespace)) continue;
                cat.debug((Object)("supportsNamespace(String, List); namespace " + aNamespace + " supported"));
                return true;
            }
        }
        cat.debug((Object)("supportsNamespace(String, List); namespace " + aNamespace + " not supported"));
        return false;
    }

    private EPPExtValue createExtValue(String aNamespace) {
        EPPExtValue theExtValue = new EPPExtValue();
        theExtValue.setValue(new EPPValue("<notSupported>" + aNamespace + "</notSupported>"));
        theExtValue.setReason("Message incomplete due to missing " + aNamespace + " in the login services");
        return theExtValue;
    }
}

