/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.gen;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.gen.EPPValue;
import com.verisign.epp.util.EPPCatFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class EPPExtValue
implements EPPCodecComponent {
    public static final String DEFAULT_LANG = "en";
    public static final String DEFAULT_VALUE = "<epp:undef/>";
    static final String ELM_NAME = "extValue";
    private static final String ELM_REASON = "reason";
    private static final String ATTR_LANG = "lang";
    private static Logger cat = Logger.getLogger((String)EPPExtValue.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private EPPValue value = null;
    private String reason;
    private String lang = "en";

    public EPPExtValue() {
    }

    public EPPExtValue(String aReason) {
        this.reason = aReason;
        this.value = new EPPValue(DEFAULT_VALUE, "epp", "urn:ietf:params:xml:ns:epp-1.0");
    }

    public EPPExtValue(String aReason, String aValue) {
        this.reason = aReason;
        this.value = new EPPValue(aValue);
    }

    public EPPExtValue(String aReason, EPPValue aValue) {
        this.reason = aReason;
        this.value = aValue;
    }

    public EPPExtValue(String aReason, String aValue, String aPrefix, String aNamespace) {
        this.reason = aReason;
        this.value = new EPPValue(aValue, aPrefix, aNamespace);
    }

    public EPPValue getValue() {
        return this.value;
    }

    public void setValue(EPPValue aValue) {
        this.value = aValue;
    }

    public String getValueStr() {
        if (this.value != null) {
            return this.value.getValue();
        }
        return null;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String aReason) {
        this.reason = aReason;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String aLang) {
        this.lang = aLang == null || aLang.equals("") ? DEFAULT_LANG : aLang;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", ELM_NAME);
        EPPUtil.encodeComp(aDocument, root, this.value);
        Element currElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", ELM_REASON);
        Text currVal = aDocument.createTextNode(this.reason);
        currElm.appendChild(currVal);
        root.appendChild(currElm);
        if (!this.lang.equals(DEFAULT_LANG)) {
            currElm.setAttribute(ATTR_LANG, this.lang);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.value = (EPPValue)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp-1.0", "value", EPPValue.class);
        Element theReasonElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:epp-1.0", ELM_REASON);
        if (theReasonElm == null) {
            cat.error((Object)"EPPExtValue.decode(): Required element reason not found");
            throw new EPPDecodeException("EPPExtValue.decode(): Required element reason not found");
        }
        Node theTextNode = theReasonElm.getFirstChild();
        this.reason = theTextNode != null ? theTextNode.getNodeValue() : "";
        this.setLang(theReasonElm.getAttribute(ATTR_LANG));
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPExtValue)) {
            cat.error((Object)("EPPExtValue.equals(): " + aObject.getClass().getName() + " not EPPExtValue instance"));
            return false;
        }
        EPPExtValue theExtValue = (EPPExtValue)aObject;
        if (!(this.value != null ? this.value.equals(theExtValue.value) : theExtValue.value == null)) {
            cat.error((Object)"EPPExtValue.equals(): value not equal");
            return false;
        }
        if (!(this.reason != null ? this.reason.equals(theExtValue.reason) : theExtValue.reason == null)) {
            cat.error((Object)"EPPExtValue.equals(): reason not equal");
            return false;
        }
        if (!this.lang.equals(theExtValue.lang)) {
            cat.error((Object)"EPPExtValue.equals(): lang not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPExtValue clone = null;
        clone = (EPPExtValue)super.clone();
        if (this.value != null) {
            clone.value = (EPPValue)this.value.clone();
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp-1.0";
    }
}

