/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.gen;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPStatement;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.types.Duration;
import com.verisign.epp.util.EPPCatFactory;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPDcp
implements EPPCodecComponent {
    public static final short EXPIRY_NONE = 0;
    public static final short EXPIRY_ABSOLUTE = 1;
    public static final short EXPIRY_RELATIVE = 2;
    public static final short ACCESS_ALL = 0;
    public static final short ACCESS_NONE = 1;
    public static final short ACCESS_NULL = 2;
    public static final short ACCESS_PERSONAL = 3;
    public static final short ACCESS_PERSONAL_AND_OTHER = 4;
    public static final short ACCESS_OTHER = 5;
    static final String ELM_NAME = "dcp";
    private static final String ELM_ACCESS = "access";
    private static final String ELM_ACCESS_ALL = "all";
    private static final String ELM_ACCESS_NONE = "none";
    private static final String ELM_ACCESS_NULL = "null";
    private static final String ELM_ACCESS_PERSONAL = "personal";
    private static final String ELM_ACCESS_PERSONAL_AND_OTHER = "personalAndOther";
    private static final String ELM_ACCESS_OTHER = "other";
    private static final String ELM_EXPIRY = "expiry";
    private static final String ELM_EXPIRY_ABSOLUTE = "absolute";
    private static final String ELM_EXPIRY_RELATIVE = "relative";
    private static final String[] accessElms = new String[]{"all", "none", "null", "personal", "personalAndOther", "other"};
    private static HashMap accessElmHash = new HashMap();
    private static Logger cat;
    private short access = 0;
    private Vector statements = null;
    private Date expiryAbsolute = null;
    private Duration expiryRelative = null;

    public EPPDcp() {
    }

    public EPPDcp(short aAccess, Vector aStatements) {
        this.access = aAccess;
        this.statements = aStatements;
    }

    public EPPDcp(short aAccess, Vector aStatements, Date aExpiryAbsolute) {
        this.access = aAccess;
        this.statements = aStatements;
        this.setExpiryAbsolute(aExpiryAbsolute);
    }

    public EPPDcp(short aAccess, Vector aStatements, Duration aExpiryRelative) {
        this.access = aAccess;
        this.statements = aStatements;
        this.setExpiryRelative(aExpiryRelative);
    }

    public Vector getStatements() {
        return this.statements;
    }

    public void setStatements(Vector aStatements) {
        this.statements = aStatements;
    }

    public void addStatement(EPPStatement aStatement) {
        if (this.statements == null) {
            this.statements = new Vector();
        }
        this.statements.addElement(aStatement);
    }

    public short getAccess() {
        return this.access;
    }

    public void setAccess(short aAccess) {
        this.access = aAccess;
    }

    public Date getExpiryAbsolute() {
        return this.expiryAbsolute;
    }

    public void setExpiryAbsolute(Date aExpiryDate) {
        this.expiryAbsolute = aExpiryDate;
        this.expiryRelative = null;
    }

    public Duration getExpiryyRelative() {
        return this.expiryRelative;
    }

    public void setExpiryRelative(Duration aDuration) {
        this.expiryRelative = aDuration;
        this.expiryAbsolute = null;
    }

    public short getExpiryType() {
        if (this.expiryAbsolute == null && this.expiryRelative == null) {
            return 0;
        }
        if (this.expiryAbsolute != null) {
            return 1;
        }
        return 2;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element theElm = null;
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", ELM_NAME);
        if (this.access < 0 || this.access >= accessElms.length) {
            cat.error((Object)("EPPDcp.encode(): Unknown access value of " + this.access));
            throw new EPPEncodeException("EPPDcp.encode(): Unknown access value of " + this.access);
        }
        Element theAccessElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", ELM_ACCESS);
        root.appendChild(theAccessElm);
        theElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", accessElms[this.access]);
        theAccessElm.appendChild(theElm);
        EPPUtil.encodeCompVector(aDocument, root, this.statements);
        Element theExpiryElm = null;
        switch (this.getExpiryType()) {
            case 0: {
                break;
            }
            case 1: {
                theExpiryElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", ELM_EXPIRY);
                root.appendChild(theExpiryElm);
                EPPUtil.encodeString(aDocument, theExpiryElm, EPPUtil.encodeTimeInstant(this.expiryAbsolute), "urn:ietf:params:xml:ns:epp-1.0", ELM_EXPIRY_ABSOLUTE);
                break;
            }
            case 2: {
                theExpiryElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", ELM_EXPIRY);
                root.appendChild(theExpiryElm);
                EPPUtil.encodeString(aDocument, theExpiryElm, this.expiryRelative.toString(), "urn:ietf:params:xml:ns:epp-1.0", ELM_EXPIRY_RELATIVE);
                break;
            }
            default: {
                cat.error((Object)("EPPDcp.encode(): Invalid expiry type of " + this.getExpiryType()));
                throw new EPPEncodeException("EPPDcp.encode(): Invalid expiry type of " + this.getExpiryType());
            }
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        Element theElm = null;
        theElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:epp-1.0", ELM_ACCESS);
        if (theElm == null) {
            cat.error((Object)"EPPDcp.decode(): could not find access element");
            throw new EPPDecodeException("EPPDcp could not find access element");
        }
        Element theAccessValueElm = EPPUtil.getFirstElementChild(theElm);
        if (theAccessValueElm == null) {
            cat.error((Object)"EPPDcp.decode(): could not find access element value");
            throw new EPPDecodeException("EPPDcp could not find access element value");
        }
        Short theAccessValue = (Short)accessElmHash.get(theAccessValueElm.getLocalName());
        if (theAccessValue == null) {
            cat.error((Object)"EPPDcp.decode(): could not find valid access element value");
            throw new EPPDecodeException("EPPDcp could not find valid access element value");
        }
        this.access = theAccessValue;
        this.statements = EPPUtil.decodeCompVector(aElement, "urn:ietf:params:xml:ns:epp-1.0", "statement", EPPStatement.class);
        Element theExpiryElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:epp-1.0", ELM_EXPIRY);
        if (theExpiryElm != null) {
            Element theExpiryValue = EPPUtil.getElementByTagNameNS(theExpiryElm, "urn:ietf:params:xml:ns:epp-1.0", ELM_EXPIRY_ABSOLUTE);
            if (theExpiryValue != null) {
                this.setExpiryAbsolute(EPPUtil.decodeTimeInstant(theExpiryValue.getFirstChild().getNodeValue()));
            } else {
                theExpiryValue = EPPUtil.getElementByTagNameNS(theExpiryElm, "urn:ietf:params:xml:ns:epp-1.0", ELM_EXPIRY_RELATIVE);
                if (theExpiryValue == null) {
                    cat.error((Object)"EPPDcp.decode(): Could not find valid expiry element");
                    throw new EPPDecodeException("EPPDcp.decode(): Could not find valid expiry element");
                }
                try {
                    this.setExpiryRelative(Duration.parseDuration(theExpiryValue.getFirstChild().getNodeValue()));
                }
                catch (ParseException ex) {
                    cat.error((Object)("EPPDcp.decode(): xception parsing relative expiry value " + theExpiryValue.getFirstChild().getNodeValue() + ": " + ex));
                    throw new EPPDecodeException("EPPDcp.decode(): Exception parsing relative expiry value " + theExpiryValue.getFirstChild().getNodeValue() + ": " + ex);
                }
            }
        } else {
            this.expiryAbsolute = null;
            this.expiryRelative = null;
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPDcp)) {
            cat.error((Object)("EPPDCP.equals(): " + aObject.getClass().getName() + " not EPPDcp instance"));
            return false;
        }
        EPPDcp theDCP = (EPPDcp)aObject;
        if (this.access != theDCP.access) {
            cat.error((Object)"EPPDCP.equals(): access not equal");
            return false;
        }
        if (!EPPUtil.equalVectors(this.statements, theDCP.statements)) {
            cat.error((Object)"EPPDCP.equals(): statements not equal");
            return false;
        }
        if (!(this.expiryAbsolute != null ? this.expiryAbsolute.equals(theDCP.expiryAbsolute) : theDCP.expiryAbsolute == null)) {
            cat.error((Object)"EPPDCP.equals(): expiryAbsolute not equal");
            return false;
        }
        if (!(this.expiryRelative != null ? this.expiryRelative.equals(theDCP.expiryRelative) : theDCP.expiryRelative == null)) {
            cat.error((Object)"EPPDCP.equals(): expiryRelative not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPDcp clone = null;
        clone = (EPPDcp)super.clone();
        clone.access = this.access;
        clone.statements = (Vector)this.statements.clone();
        for (int i = 0; i < this.statements.size(); ++i) {
            clone.statements.setElementAt(((EPPStatement)this.statements.elementAt(i)).clone(), i);
        }
        if (this.expiryAbsolute != null) {
            clone.expiryAbsolute = (Date)this.expiryAbsolute.clone();
        }
        if (this.expiryRelative != null) {
            clone.expiryRelative = new Duration(this.expiryRelative.toLong());
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp-1.0";
    }

    static {
        accessElmHash.put(EPPUtil.getLocalName(ELM_ACCESS_ALL), (short)0);
        accessElmHash.put(EPPUtil.getLocalName(ELM_ACCESS_NONE), (short)1);
        accessElmHash.put(EPPUtil.getLocalName(ELM_ACCESS_NULL), (short)2);
        accessElmHash.put(EPPUtil.getLocalName(ELM_ACCESS_PERSONAL), (short)3);
        accessElmHash.put(EPPUtil.getLocalName(ELM_ACCESS_PERSONAL_AND_OTHER), (short)4);
        accessElmHash.put(EPPUtil.getLocalName(ELM_ACCESS_OTHER), (short)5);
        cat = Logger.getLogger((String)EPPDcp.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    }
}

