/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.gen;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EPPAuthInfo
implements EPPCodecComponent {
    public static final short TYPE_PW = 0;
    public static final short TYPE_EXT = 1;
    static final String ELM_NAME = "authInfo";
    protected static final String ELM_PW = "pw";
    protected static final String ELM_EXT = "ext";
    protected static final String ATTR_ROID = "roid";
    private static Logger cat = Logger.getLogger((String)EPPAuthInfo.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    protected String password = null;
    protected EPPCodecComponent ext = null;
    protected short type = 0;
    protected String roid = null;
    private String rootName = "authInfo";
    private String rootNS = "urn:ietf:params:xml:ns:epp-1.0";

    public EPPAuthInfo() {
    }

    public EPPAuthInfo(String aPassword) {
        this.setPassword(aPassword);
    }

    public EPPAuthInfo(String aRootNS, String aRootName, String aPassword) {
        this.setRootName(aRootNS, aRootName);
        this.setPassword(aPassword);
    }

    public EPPAuthInfo(String aRootNS, String aRootName, String aRoid, String aPassword) {
        this.setRootName(aRootNS, aRootName);
        this.roid = aRoid;
        this.setPassword(aPassword);
    }

    public EPPAuthInfo(EPPCodecComponent aExt) {
        this.setExt(aExt);
    }

    public EPPAuthInfo(String aRootNS, String aRootName, EPPCodecComponent aExt) {
        this.setRootName(aRootNS, aRootName);
        this.setExt(aExt);
    }

    public String getRoid() {
        return this.roid;
    }

    public void setRoid(String aRoid) {
        this.roid = aRoid;
    }

    public String getRootNS() {
        return this.rootNS;
    }

    public String getRootName() {
        return this.rootName;
    }

    public void setRootName(String aRootNS, String newRootName) {
        this.rootNS = aRootNS;
        this.rootName = newRootName;
    }

    public String getAuthInfo() {
        return this.password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String aPassword) {
        this.password = aPassword;
        this.type = 0;
    }

    public EPPCodecComponent getExt() {
        return this.ext;
    }

    public void setExt(EPPCodecComponent aExt) {
        this.ext = aExt;
        this.type = 1;
    }

    public void setAuthInfo(String aPassword) {
        this.password = aPassword;
    }

    public short getType() {
        return this.type;
    }

    public void setType(short aType) {
        this.type = aType;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPAuthInfo clone = null;
        clone = (EPPAuthInfo)super.clone();
        if (this.ext != null) {
            clone.ext = (EPPCodecComponent)this.ext.clone();
        }
        return clone;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.setRootName(aElement.getNamespaceURI(), aElement.getTagName());
        Element theTypeElm = EPPUtil.getFirstElementChild(aElement);
        if (theTypeElm == null) {
            throw new EPPDecodeException("EPPAuthInfo.decode could not find type child element");
        }
        if (theTypeElm.getLocalName().equals(ELM_PW)) {
            this.type = 0;
            Node textNode = theTypeElm.getFirstChild();
            this.password = textNode != null ? textNode.getNodeValue() : "";
            this.roid = theTypeElm.getAttribute(ATTR_ROID).equals("") ? null : theTypeElm.getAttribute(ATTR_ROID);
        } else if (theTypeElm.getLocalName().equals(ELM_EXT)) {
            this.type = 1;
            Element theExtElm = EPPUtil.getFirstElementChild(theTypeElm);
            try {
                this.ext = EPPFactory.getInstance().createExtension(theExtElm);
            }
            catch (EPPCodecException e) {
                throw new EPPDecodeException("EPPAuthInfo.decode unable to create authInfo extension object: " + e);
            }
            this.ext.decode(theExtElm);
        } else {
            throw new EPPDecodeException("EPPAuthInfo.decode invalid type child element tag name of " + theTypeElm.getTagName());
        }
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root = aDocument.createElementNS(this.rootNS, this.rootName);
        String nsPrefix = EPPUtil.getPrefix(this.rootName);
        if (nsPrefix.length() != 0) {
            nsPrefix = nsPrefix + ":";
        }
        switch (this.type) {
            case 0: {
                if (this.password == null) {
                    throw new EPPEncodeException("EPPAuthInfo: password is null on call to encode");
                }
                Element thePasswordElm = aDocument.createElementNS(this.rootNS, nsPrefix + ELM_PW);
                thePasswordElm.appendChild(aDocument.createTextNode(this.password));
                if (this.roid != null) {
                    thePasswordElm.setAttribute(ATTR_ROID, this.roid);
                }
                root.appendChild(thePasswordElm);
                break;
            }
            case 1: {
                if (this.ext == null) {
                    throw new EPPEncodeException("EPPAuthInfo: ext is null on call to encode");
                }
                Element theExtElm = aDocument.createElementNS(this.rootNS, nsPrefix + ELM_EXT);
                EPPUtil.encodeComp(aDocument, theExtElm, this.ext);
                root.appendChild(theExtElm);
                break;
            }
            default: {
                throw new EPPEncodeException("EPPAuthInfo: invalid type" + this.type);
            }
        }
        return root;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPAuthInfo)) {
            cat.error((Object)("EPPAuthInfo.equals(): " + aObject.getClass().getName() + " not EPPAuthInfo instance"));
            return false;
        }
        EPPAuthInfo theComp = (EPPAuthInfo)aObject;
        if (!this.rootNS.equals(theComp.rootNS)) {
            cat.error((Object)"EPPAuthInfo.equals(): rootNS not equal");
            return false;
        }
        if (!EPPUtil.getLocalName(this.rootName).equals(EPPUtil.getLocalName(theComp.rootName))) {
            cat.error((Object)"EPPAuthInfo.equals(): rootName not equal");
            return false;
        }
        if (!(this.password != null ? this.password.equals(theComp.password) : theComp.password == null)) {
            cat.error((Object)"EPPAuthInfo.equals(): password not equal");
            return false;
        }
        if (!(this.ext != null ? this.ext.equals(theComp.ext) : theComp.ext == null)) {
            cat.error((Object)"EPPAuthInfo.equals(): ext not equal");
            return false;
        }
        if (this.type != theComp.type) {
            cat.error((Object)"EPPAuthInfo.equals(): type not equal");
            return false;
        }
        if (!(this.roid != null ? this.roid.equals(theComp.roid) : theComp.roid == null)) {
            cat.error((Object)"EPPAuthInfo.equals(): roid not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp-1.0";
    }
}

