/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.fee.v23;

import com.verisign.epp.codec.fee.v23.Command;
import com.verisign.epp.codec.fee.v23.EPPFeePeriod;
import com.verisign.epp.codec.fee.v23.Phase;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPFeeCommand
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPFeeCommand.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "command";
    public static final String ELM_NAME = "fee:command";
    public static final String ATTR_PHASE = "phase";
    public static final String ATTR_SUBPHASE = "subphase";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_CUSTOMNAME = "customName";
    private Phase phase;
    private String subphase;
    private Command command;
    private String customName;
    private EPPFeePeriod period;

    public EPPFeeCommand() {
    }

    public EPPFeeCommand(Command aCommand) {
        this.command = aCommand;
    }

    public EPPFeeCommand(Command aCommand, EPPFeePeriod aPeriod) {
        this.command = aCommand;
        this.period = aPeriod;
    }

    public EPPFeeCommand(Command aCommand, String aCustomName) {
        this.command = aCommand;
        this.customName = aCustomName;
    }

    public EPPFeeCommand(Command aCommand, Phase aPhase) {
        this.command = aCommand;
        this.phase = aPhase;
    }

    public EPPFeeCommand(Command aCommand, Phase aPhase, String aSubPhase) {
        this.command = aCommand;
        this.phase = aPhase;
        this.subphase = aSubPhase;
    }

    public EPPFeeCommand(Command aCommand, String aCustomName, Phase aPhase, String aSubPhase, EPPFeePeriod aPeriod) {
        this.command = aCommand;
        this.customName = aCustomName;
        this.phase = aPhase;
        this.subphase = aSubPhase;
        this.period = aPeriod;
    }

    public EPPFeeCommand(EPPFeeCommand aCommand) {
        this.command = aCommand.getCommand();
        this.customName = aCommand.getCustomName();
        this.phase = aCommand.getPhase();
        this.subphase = aCommand.getSubPhase();
        if (this.period != null) {
            try {
                this.period = (EPPFeePeriod)aCommand.period.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
    }

    public boolean hasCommand() {
        return this.command != null;
    }

    public Command getCommand() {
        return this.command;
    }

    public void setCommand(Command aCommand) {
        this.command = aCommand;
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String aCustomName) {
        this.customName = aCustomName;
    }

    public boolean hasPhase() {
        return this.phase != null;
    }

    public Phase getPhase() {
        return this.phase;
    }

    public void setPhase(Phase aPhase) {
        this.phase = aPhase;
    }

    public boolean hasSubPhase() {
        return this.subphase != null;
    }

    public String getSubPhase() {
        return this.subphase;
    }

    public void setSubPhase(String aSubPhase) {
        this.subphase = aSubPhase;
    }

    public boolean hasPeriod() {
        return this.period != null;
    }

    public EPPFeePeriod getPeriod() {
        return this.period;
    }

    public void setPeriod(EPPFeePeriod aPeriod) {
        this.period = aPeriod;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPFeeCommand clone = null;
        clone = (EPPFeeCommand)super.clone();
        clone.phase = this.phase;
        clone.subphase = this.subphase;
        clone.command = this.command;
        clone.customName = this.customName;
        if (this.period != null) {
            clone.period = (EPPFeePeriod)this.period.clone();
        }
        return clone;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        String thePhase = aElement.getAttribute(ATTR_PHASE);
        this.phase = thePhase != null && !thePhase.isEmpty() ? Phase.getPhase(thePhase) : null;
        String theSubPhase = aElement.getAttribute(ATTR_SUBPHASE);
        this.subphase = theSubPhase != null && !theSubPhase.isEmpty() ? theSubPhase : null;
        String theName = aElement.getAttribute(ATTR_NAME);
        this.command = theName != null && !theName.isEmpty() ? Command.getCommand(theName) : null;
        String theCustomName = aElement.getAttribute(ATTR_CUSTOMNAME);
        this.customName = theCustomName != null && !theCustomName.isEmpty() ? theCustomName : null;
        this.period = (EPPFeePeriod)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:fee-0.23", "fee:period", EPPFeePeriod.class);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPFeeCommand.encode(Document)");
        }
        if (this.command == null) {
            throw new EPPEncodeException("command is null on in EPPFeeCommand.encode(Document)");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:fee-0.23", ELM_NAME);
        if (this.hasPhase()) {
            root.setAttribute(ATTR_PHASE, this.phase.toString());
        }
        if (this.hasSubPhase()) {
            root.setAttribute(ATTR_SUBPHASE, this.subphase);
        }
        root.setAttribute(ATTR_NAME, this.command.toString());
        if (this.hasCustomName()) {
            root.setAttribute(ATTR_CUSTOMNAME, this.customName);
        }
        EPPUtil.encodeComp(aDocument, root, this.period);
        return root;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPFeeCommand)) {
            cat.error((Object)("EPPFeeCommand.equals(): " + aObject.getClass().getName() + "! instanceof " + EPPFeeCommand.class.getName()));
            return false;
        }
        EPPFeeCommand other = (EPPFeeCommand)aObject;
        if (!EqualityUtil.equals((Object)this.phase, (Object)other.phase)) {
            cat.error((Object)"EPPFeeCommand.equals(): phase not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.subphase, other.subphase)) {
            cat.error((Object)"EPPFeeCommand.equals(): subphase not equal");
            return false;
        }
        if (!EqualityUtil.equals((Object)this.command, (Object)other.command)) {
            cat.error((Object)"EPPFeeCommand.equals(): command not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.customName, other.customName)) {
            cat.error((Object)"EPPFeeCommand.equals(): customName not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.period, other.period)) {
            cat.error((Object)"EPPFeeCommand.equals(): period not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:fee-0.23";
    }
}

