/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.fee.v1_0;

import com.verisign.epp.codec.fee.v1_0.EPPFeeCommandData;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPFeeCheckResult
implements EPPCodecComponent {
    public static final String ELM_LOCALNAME = "cd";
    public static final String ELM_NAME = "fee:cd";
    private static Logger cat = Logger.getLogger((String)EPPFeeCheckResult.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private static final String ELM_OBJ_ID = "objID";
    private static final String ELM_CLASSIFICATION = "class";
    private static final String ELM_REASON = "reason";
    private static final String ATTR_AVAIL = "avail";
    private static final String ATTR_LANG = "lang";
    private static final String DEFAULT_LANG = "en";
    private String objID;
    private String classification;
    private boolean available;
    private List<EPPFeeCommandData> commands = new ArrayList<EPPFeeCommandData>();
    private String language = "en";
    private String reason;

    public EPPFeeCheckResult() {
    }

    public EPPFeeCheckResult(String aObjID, boolean aAvailable) {
        this.setObjID(aObjID);
        this.setAvailable(aAvailable);
    }

    public EPPFeeCheckResult(String aObjID, EPPFeeCommandData aCommand) {
        this.setObjID(aObjID);
        this.setAvailable(true);
        this.addCommand(aCommand);
    }

    public EPPFeeCheckResult(String aObjID, List<EPPFeeCommandData> aCommands) {
        this.setObjID(aObjID);
        this.setAvailable(true);
        this.setCommands(aCommands);
    }

    public EPPFeeCheckResult(String aObjID, String aReason) {
        this.setObjID(aObjID);
        this.setAvailable(false);
        this.setReason(aReason);
    }

    public EPPFeeCheckResult(String aObjID, String aReason, String aLanguage) {
        this(aObjID, aReason);
        this.setLanguage(aLanguage);
    }

    public EPPFeeCheckResult(String aObjID, String aClassification, String aReason, String aLanguage) {
        this(aObjID, aReason);
        this.classification = aClassification;
        this.setLanguage(aLanguage);
    }

    public String getObjID() {
        return this.objID;
    }

    public void setObjID(String aObjID) {
        this.objID = aObjID;
    }

    public boolean hasClassification() {
        return this.classification != null;
    }

    public String getClassification() {
        return this.classification;
    }

    public void setClassification(String aClassification) {
        this.classification = aClassification;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean aAvailable) {
        this.available = aAvailable;
    }

    public boolean hasCommands() {
        return !this.commands.isEmpty();
    }

    public List<EPPFeeCommandData> getCommands() {
        return this.commands;
    }

    public void addCommand(EPPFeeCommandData aCommand) {
        if (aCommand == null) {
            return;
        }
        this.commands.add(aCommand);
    }

    public void setCommands(List<EPPFeeCommandData> aCommands) {
        this.commands = aCommands == null ? new ArrayList<EPPFeeCommandData>() : aCommands;
    }

    public boolean hasReason() {
        return this.reason != null;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String aReason) {
        this.reason = aReason;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String aLanguage) {
        this.language = aLanguage == null ? DEFAULT_LANG : aLanguage;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPFeeCheckResult.encode(Document)");
        }
        if (this.objID == null) {
            throw new EPPEncodeException("Required objID attribute is null in EPPFeeCheckResult.encode(Document).");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:fee-1.0", ELM_NAME);
        EPPUtil.encodeBooleanAttr(root, ATTR_AVAIL, this.available);
        EPPUtil.encodeString(aDocument, root, this.objID, "urn:ietf:params:xml:ns:epp:fee-1.0", "fee:objID");
        EPPUtil.encodeString(aDocument, root, this.classification, "urn:ietf:params:xml:ns:epp:fee-1.0", "fee:class");
        EPPUtil.encodeCompList(aDocument, root, this.commands);
        if (this.hasReason()) {
            Element reasonElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:fee-1.0", "fee:reason");
            root.appendChild(reasonElm);
            if (!this.language.equals(DEFAULT_LANG)) {
                reasonElm.setAttribute(ATTR_LANG, this.language);
            }
            Text aReason = aDocument.createTextNode(this.reason);
            reasonElm.appendChild(aReason);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.available = EPPUtil.decodeBooleanAttr(aElement, ATTR_AVAIL);
        this.objID = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:fee-1.0", ELM_OBJ_ID);
        this.classification = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:fee-1.0", ELM_CLASSIFICATION);
        this.commands = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:epp:fee-1.0", "command", EPPFeeCommandData.class);
        Element theReasonElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:epp:fee-1.0", ELM_REASON);
        if (theReasonElm != null) {
            this.reason = theReasonElm.getFirstChild().getNodeValue();
            String theLang = theReasonElm.getAttribute(ATTR_LANG);
            if (theLang.length() > 0) {
                this.language = theLang;
            }
        }
        this.reason = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:fee-1.0", ELM_REASON);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPFeeCheckResult clone = (EPPFeeCheckResult)super.clone();
        clone.available = this.available;
        clone.objID = this.objID;
        clone.classification = this.classification;
        clone.commands = new ArrayList<EPPFeeCommandData>();
        for (EPPFeeCommandData command : this.commands) {
            clone.commands.add((EPPFeeCommandData)command.clone());
        }
        clone.reason = this.reason;
        clone.language = this.language;
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPFeeCheckResult)) {
            cat.error((Object)("EPPFeeCheckResult.equals(): " + aObject.getClass().getName() + " not EPPFeeCheckResult instance"));
            return false;
        }
        EPPFeeCheckResult other = (EPPFeeCheckResult)aObject;
        if (!EqualityUtil.equals(this.available, other.available)) {
            cat.error((Object)"EPPFeeCheckResult.equals(): available not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.objID, other.objID)) {
            cat.error((Object)"EPPFeeCheckResult.equals(): objID not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.classification, other.classification)) {
            cat.error((Object)"EPPFeeCheckResult.equals(): classification not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.commands, other.commands)) {
            cat.error((Object)"EPPFeeCheckResult.equals(): commands not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.reason, other.reason)) {
            cat.error((Object)"EPPFeeCheckResult.equals(): reason not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.language, other.language)) {
            cat.error((Object)"EPPFeeCheckResult.equals(): language not equal");
            return false;
        }
        return true;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:fee-1.0";
    }
}

