/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.fee.v1_0;

import com.verisign.epp.codec.fee.v1_0.EPPFeeCommand;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPFeeCheck
implements EPPCodecComponent {
    public static final String ELM_LOCALNAME = "check";
    public static final String ELM_NAME = "fee:check";
    private static Logger cat = Logger.getLogger((String)EPPFeeCheck.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private static final String ELM_CURRENCY = "currency";
    private List<EPPFeeCommand> commands = new ArrayList<EPPFeeCommand>();
    private String currency;

    public EPPFeeCheck() {
    }

    public EPPFeeCheck(EPPFeeCommand aCommand) {
        this.addCommand(aCommand);
    }

    public EPPFeeCheck(List<EPPFeeCommand> aCommands) {
        this.setCommands(aCommands);
    }

    public EPPFeeCheck(EPPFeeCommand aCommand, String aCurrency) {
        this.addCommand(aCommand);
        this.setCurrency(aCurrency);
    }

    public EPPFeeCheck(List<EPPFeeCommand> aCommands, String aCurrency) {
        this.setCommands(aCommands);
        this.setCurrency(aCurrency);
    }

    public boolean hasCommands() {
        return !this.commands.isEmpty();
    }

    public List<EPPFeeCommand> getCommands() {
        return this.commands;
    }

    public void addCommand(EPPFeeCommand aCommand) {
        if (aCommand == null) {
            return;
        }
        this.commands.add(aCommand);
    }

    public void setCommands(List<EPPFeeCommand> aCommands) {
        this.commands = aCommands == null ? new ArrayList<EPPFeeCommand>() : aCommands;
    }

    public boolean hasCurrency() {
        return this.currency != null;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String aCurrency) {
        this.currency = aCurrency;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPFeeCheck.encode(Document)");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:fee-1.0", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.currency, "urn:ietf:params:xml:ns:epp:fee-1.0", "fee:currency");
        EPPUtil.encodeCompList(aDocument, root, this.commands);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.currency = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:fee-1.0", ELM_CURRENCY);
        if (this.currency != null && this.currency.isEmpty()) {
            this.currency = null;
        }
        this.commands = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:epp:fee-1.0", "command", EPPFeeCommand.class);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPFeeCheck clone = (EPPFeeCheck)super.clone();
        clone.currency = this.currency;
        clone.commands = new ArrayList<EPPFeeCommand>();
        for (EPPFeeCommand command : this.commands) {
            clone.commands.add((EPPFeeCommand)command.clone());
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPFeeCheck)) {
            cat.error((Object)("EPPFeeCheck.equals(): " + aObject.getClass().getName() + " not EPPFeeCheck instance"));
            return false;
        }
        EPPFeeCheck other = (EPPFeeCheck)aObject;
        if (!EqualityUtil.equals(this.commands, other.commands)) {
            cat.error((Object)"EPPFeeCheck.equals(): commands not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.currency, other.currency)) {
            cat.error((Object)"EPPFeeCheck.equals(): currency not equal");
            return false;
        }
        return true;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:fee-1.0";
    }
}

