/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.fee.v11;

import com.verisign.epp.codec.domain.EPPDomainAddRemove;
import com.verisign.epp.codec.domain.EPPDomainCheckCmd;
import com.verisign.epp.codec.domain.EPPDomainCheckResp;
import com.verisign.epp.codec.domain.EPPDomainCheckResult;
import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainCreateResp;
import com.verisign.epp.codec.domain.EPPDomainPeriod;
import com.verisign.epp.codec.domain.EPPDomainRenewCmd;
import com.verisign.epp.codec.domain.EPPDomainRenewResp;
import com.verisign.epp.codec.domain.EPPDomainTransferCmd;
import com.verisign.epp.codec.domain.EPPDomainTransferResp;
import com.verisign.epp.codec.domain.EPPDomainUpdateCmd;
import com.verisign.epp.codec.fee.v11.EPPFeeCheck;
import com.verisign.epp.codec.fee.v11.EPPFeeChkData;
import com.verisign.epp.codec.fee.v11.EPPFeeCommand;
import com.verisign.epp.codec.fee.v11.EPPFeeCreData;
import com.verisign.epp.codec.fee.v11.EPPFeeCreate;
import com.verisign.epp.codec.fee.v11.EPPFeeCredit;
import com.verisign.epp.codec.fee.v11.EPPFeeDelData;
import com.verisign.epp.codec.fee.v11.EPPFeeObjectResult;
import com.verisign.epp.codec.fee.v11.EPPFeePeriod;
import com.verisign.epp.codec.fee.v11.EPPFeeRenData;
import com.verisign.epp.codec.fee.v11.EPPFeeRenew;
import com.verisign.epp.codec.fee.v11.EPPFeeTransfer;
import com.verisign.epp.codec.fee.v11.EPPFeeTrnData;
import com.verisign.epp.codec.fee.v11.EPPFeeUpdData;
import com.verisign.epp.codec.fee.v11.EPPFeeUpdate;
import com.verisign.epp.codec.fee.v11.EPPFeeValue;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.util.TestThread;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class EPPFeeTst
extends TestCase {
    private static long numIterations = 1L;

    public EPPFeeTst(String name) {
        super(name);
    }

    public void testDomainCheck() {
        EPPCodecTst.printStart("testDomainCheck");
        Vector<String> domains = new Vector<String>();
        domains.addElement("example.com");
        domains.addElement("example.net");
        domains.addElement("example.xyz");
        EPPDomainCheckCmd theCommand = new EPPDomainCheckCmd("ABC-12345", domains);
        EPPFeeCheck theCheckExt = new EPPFeeCheck(new EPPFeeCommand("create"));
        theCheckExt.setCurrency("USD");
        theCommand.addExtension(theCheckExt);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPDomainCheckResp theResponse = new EPPDomainCheckResp(respTransId, new EPPDomainCheckResult("example1.com", true));
        theResponse.setResult(1000);
        EPPFeeChkData theChkDataExt = new EPPFeeChkData();
        EPPFeeObjectResult theFeeResult = new EPPFeeObjectResult("urn:ietf:params:xml:ns:domain-1.0", "domain:name", "example.com", "USD", new EPPFeeCommand("create"));
        theFeeResult.addFee(new EPPFeeValue(new BigDecimal("5.00"), "Registration Fee", true, "P5D", null));
        theFeeResult.setPeriod(new EPPFeePeriod(1));
        theChkDataExt.addCheckResult(theFeeResult);
        theFeeResult = new EPPFeeObjectResult("urn:ietf:params:xml:ns:domain-1.0", "domain:name", "example.net", "USD", new EPPFeeCommand("create"), new EPPFeePeriod(1), new EPPFeeValue(new BigDecimal("5.00"), "Registration Fee", true, "P5D", null));
        theFeeResult.setPeriod(new EPPFeePeriod(1));
        theChkDataExt.addCheckResult(theFeeResult);
        theFeeResult = new EPPFeeObjectResult("urn:ietf:params:xml:ns:domain-1.0", "domain:name", "example.xyz", "USD", new EPPFeeCommand("create"), "minimum period is 2 years.");
        theFeeResult.setPeriod(new EPPFeePeriod(1));
        theChkDataExt.addCheckResult(theFeeResult);
        theResponse.addExtension(theChkDataExt);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testDomainCheck");
    }

    public void testDomainCreate() {
        EPPCodecTst.printStart("testDomainCreate");
        EPPDomainCreateCmd theCommand = new EPPDomainCreateCmd("ABC-12345", "example.com", new EPPAuthInfo("2fooBAR"));
        EPPFeeCreate theCreateExt = new EPPFeeCreate(new EPPFeeValue(new BigDecimal("5.00")));
        theCreateExt.setCurrency("USD");
        theCommand.addExtension(theCreateExt);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPDomainCreateResp theResponse = new EPPDomainCreateResp(respTransId, "example.com", new GregorianCalendar(1999, 4, 3).getTime(), new GregorianCalendar(2001, 4, 3).getTime());
        theResponse.setResult(1000);
        EPPFeeCreData theRespExt = new EPPFeeCreData("USD", new EPPFeeValue(new BigDecimal("5.00")));
        theCommand.addExtension(theRespExt);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        theResponse = new EPPDomainCreateResp(respTransId, "example.com", new GregorianCalendar(1999, 4, 3).getTime(), new GregorianCalendar(2001, 4, 3).getTime());
        theResponse.setResult(1000);
        theRespExt = new EPPFeeCreData("USD", new EPPFeeValue(new BigDecimal("5.00")));
        theRespExt.setBalance(new BigDecimal("-5.00"));
        theRespExt.setCreditLimit(new BigDecimal("1000.00"));
        theCommand.addExtension(theRespExt);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testDomainCreate");
    }

    public void testDomainRenew() {
        EPPCodecTst.printStart("testDomainRenew");
        Calendar theCal = Calendar.getInstance();
        theCal.setTimeZone(TimeZone.getTimeZone("UTC"));
        theCal.set(2000, 4, 3, 0, 0, 0);
        theCal.set(14, 0);
        Date theDate = theCal.getTime();
        EPPDomainRenewCmd theCommand = new EPPDomainRenewCmd("ABC-12345", "example.com", theDate, new EPPDomainPeriod(5));
        EPPFeeRenew theRenewExt = new EPPFeeRenew(new EPPFeeValue(new BigDecimal("5.00")));
        theCommand.addExtension(theRenewExt);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPDomainRenewResp theResponse = new EPPDomainRenewResp(respTransId, "example.com", new GregorianCalendar(2000, 4, 3).getTime());
        theResponse.setResult(1000);
        EPPFeeRenData theRespExt = new EPPFeeRenData("USD", new EPPFeeValue(new BigDecimal("5.00")));
        theResponse.addExtension(theRespExt);
        commandStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(commandStats);
        respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        theResponse = new EPPDomainRenewResp(respTransId, "example.com", new GregorianCalendar(2000, 4, 3).getTime());
        theResponse.setResult(1000);
        theRespExt = new EPPFeeRenData();
        theRespExt.setCurrency("USD");
        theRespExt.addFee(new EPPFeeValue(new BigDecimal("5.00"), null, true, "P5D", EPPFeeValue.APPLIED_IMMEDIATE));
        theRespExt.setBalance(new BigDecimal("1000.00"));
        theResponse.addExtension(theRespExt);
        commandStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testDomainRenew");
    }

    public void testDomainUpdate() {
        EPPCodecTst.printStart("testDomainUpdate");
        EPPDomainAddRemove theChange = new EPPDomainAddRemove();
        theChange.setRegistrant("sh8013");
        EPPDomainUpdateCmd theCommand = new EPPDomainUpdateCmd("ABC-12345", "example.com", null, null, theChange);
        EPPFeeUpdate theUpdateExt = new EPPFeeUpdate(new EPPFeeValue(new BigDecimal("5.00")));
        theUpdateExt.setCurrency("USD");
        theCommand.addExtension(theUpdateExt);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPResponse theResponse = new EPPResponse(respTransId);
        theResponse.setResult(1000);
        EPPFeeUpdData theRespExt = new EPPFeeUpdData("USD", new EPPFeeValue(new BigDecimal("5.00")));
        theResponse.addExtension(theRespExt);
        commandStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(commandStats);
        respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        theResponse = new EPPResponse(respTransId);
        theResponse.setResult(1000);
        theRespExt = new EPPFeeUpdData();
        theRespExt.setCurrency("USD");
        theRespExt.addFee(new EPPFeeValue(new BigDecimal("5.00"), null, true, "P5D", EPPFeeValue.APPLIED_IMMEDIATE));
        theRespExt.setBalance(new BigDecimal("1000.00"));
        theResponse.addExtension(theRespExt);
        commandStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testDomainUpdate");
    }

    public void testDomainTransfer() {
        EPPCodecTst.printStart("testDomainTransfer");
        EPPDomainTransferCmd theCommand = new EPPDomainTransferCmd("ABC-12345", "request", "example.com", new EPPAuthInfo("2fooBAR"), new EPPDomainPeriod(1));
        EPPFeeTransfer theTransferExt = new EPPFeeTransfer(new EPPFeeValue(new BigDecimal("5.00")));
        theCommand.addExtension(theTransferExt);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPDomainTransferResp theResponse = new EPPDomainTransferResp(respTransId, "example.com");
        theResponse.setResult(1000);
        theResponse.setRequestClient("ClientX");
        theResponse.setActionClient("ClientY");
        theResponse.setTransferStatus("pending");
        theResponse.setRequestDate(new GregorianCalendar(2000, 6, 8).getTime());
        theResponse.setActionDate(new GregorianCalendar(2000, 6, 13).getTime());
        theResponse.setExpirationDate(new GregorianCalendar(2002, 9, 8).getTime());
        EPPFeeTrnData theRespExt = new EPPFeeTrnData("USD", new EPPFeeValue(new BigDecimal("5.00")));
        theResponse.addExtension(theRespExt);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        theResponse = new EPPDomainTransferResp(respTransId, "example.com");
        theResponse.setResult(1000);
        theResponse.setRequestClient("ClientX");
        theResponse.setActionClient("ClientY");
        theResponse.setTransferStatus("pending");
        theResponse.setRequestDate(new GregorianCalendar(2000, 6, 8).getTime());
        theResponse.setActionDate(new GregorianCalendar(2000, 6, 13).getTime());
        theResponse.setExpirationDate(new GregorianCalendar(2002, 9, 8).getTime());
        theRespExt = new EPPFeeTrnData();
        theRespExt.setCurrency("USD");
        theRespExt.setPeriod(new EPPFeePeriod(1));
        theRespExt.addFee(new EPPFeeValue(new BigDecimal("5.00"), null, true, "P5D", EPPFeeValue.APPLIED_IMMEDIATE));
        theResponse.addExtension(theRespExt);
        responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testDomainTransfer");
    }

    public void testDomainDelete() {
        EPPCodecTst.printStart("testDomainDelete");
        EPPTransId respTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        EPPResponse theResponse = new EPPResponse(respTransId);
        EPPFeeDelData theRespExt = new EPPFeeDelData("USD", new EPPFeeCredit(new BigDecimal("-5.00"), "AGP Credit"));
        theRespExt.setBalance(new BigDecimal("1005.00"));
        theResponse.addExtension(theRespExt);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testDomainDelete");
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static Test suite() {
        EPPCodecTst.initEnvironment();
        TestSuite suite = new TestSuite(EPPFeeTst.class);
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.host.EPPHostMapFactory");
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.domain.EPPDomainMapFactory");
            EPPFactory.getInstance().addExtFactory("com.verisign.epp.codec.fee.v11.EPPFeeExtFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding factories to EPPCodec: " + e));
        }
        return suite;
    }

    public static void main(String[] args) {
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPFeeTst Thread " + i, EPPFeeTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPFeeTst.suite());
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }
}

