/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.fee.v11;

import com.verisign.epp.codec.fee.v11.EPPFeeCommand;
import com.verisign.epp.codec.fee.v11.EPPFeePeriod;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPFeeCheck
implements EPPCodecComponent {
    public static final String ELM_LOCALNAME = "check";
    public static final String ELM_NAME = "fee:check";
    private static Logger cat = Logger.getLogger((String)EPPFeeCheck.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private static final String ELM_CURRENCY = "currency";
    private static final String ELM_CLASSIFICATION = "class";
    private EPPFeeCommand command;
    private String currency;
    private EPPFeePeriod period;
    private String classification;

    public EPPFeeCheck() {
    }

    public EPPFeeCheck(EPPFeeCommand aCommand) {
        this.setCommand(aCommand);
    }

    public EPPFeeCheck(EPPFeeCommand aCommand, String aCurrency, EPPFeePeriod aPeriod, String aClassification) {
        this.setCommand(aCommand);
        this.setCurrency(aCurrency);
        this.setPeriod(aPeriod);
        this.setClassification(aClassification);
    }

    public EPPFeeCommand getCommand() {
        return this.command;
    }

    public void setCommand(EPPFeeCommand aCommand) {
        this.command = aCommand;
    }

    public boolean hasCurrency() {
        return this.currency != null;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String aCurrency) {
        this.currency = aCurrency;
    }

    public boolean hasPeriod() {
        return this.period != null;
    }

    public EPPFeePeriod getPeriod() {
        return this.period;
    }

    public void setPeriod(EPPFeePeriod aPeriod) {
        this.period = aPeriod;
    }

    public boolean hasClassification() {
        return this.classification != null;
    }

    public String getClassification() {
        return this.classification;
    }

    public void setClassification(String aClassification) {
        this.classification = aClassification;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPFeeCheck.encode(Document)");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:fee-0.11", ELM_NAME);
        EPPUtil.encodeComp(aDocument, root, this.command);
        EPPUtil.encodeString(aDocument, root, this.currency, "urn:ietf:params:xml:ns:fee-0.11", "fee:currency");
        EPPUtil.encodeComp(aDocument, root, this.period);
        EPPUtil.encodeString(aDocument, root, this.classification, "urn:ietf:params:xml:ns:fee-0.11", "fee:class");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.command = (EPPFeeCommand)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:fee-0.11", "fee:command", EPPFeeCommand.class);
        this.currency = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:fee-0.11", ELM_CURRENCY);
        if (this.currency != null && this.currency.isEmpty()) {
            this.currency = null;
        }
        this.period = (EPPFeePeriod)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:fee-0.11", "fee:period", EPPFeePeriod.class);
        this.classification = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:fee-0.11", ELM_CLASSIFICATION);
        if (this.classification != null && this.classification.isEmpty()) {
            this.classification = null;
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPFeeCheck clone = (EPPFeeCheck)super.clone();
        clone.command = this.command == null ? null : (EPPFeeCommand)this.command.clone();
        clone.currency = this.currency;
        clone.period = this.period == null ? null : (EPPFeePeriod)this.period.clone();
        clone.classification = this.classification;
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPFeeCheck)) {
            cat.error((Object)("EPPFeeCheck.equals(): " + aObject.getClass().getName() + " not EPPFeeCheck instance"));
            return false;
        }
        EPPFeeCheck other = (EPPFeeCheck)aObject;
        if (!EqualityUtil.equals(this.command, other.command)) {
            cat.error((Object)"EPPFeeCheck.equals(): command not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.currency, other.currency)) {
            cat.error((Object)"EPPFeeCheck.equals(): currency not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.period, other.period)) {
            cat.error((Object)"EPPFeeCheck.equals(): period not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.classification, other.classification)) {
            cat.error((Object)"EPPFeeCheck.equals(): fee classification not equal");
            return false;
        }
        return true;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:fee-0.11";
    }
}

