/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.fee.v09;

import com.verisign.epp.codec.fee.v09.EPPFeeCredit;
import com.verisign.epp.codec.fee.v09.EPPFeePeriod;
import com.verisign.epp.codec.fee.v09.EPPFeeValue;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class EPPFeeTransformResult
implements EPPCodecComponent {
    private String ELM_NAME = "fee:" + this.getLocalName();
    private static Logger cat = Logger.getLogger((String)EPPFeeTransformResult.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private static final String ELM_CURRENCY = "currency";
    private static final String ELM_BALANCE = "balance";
    private static final String ELM_CREDIT_LIMIT = "creditLimit";
    private String currency;
    private EPPFeePeriod period;
    private List<EPPFeeValue> fees = new ArrayList<EPPFeeValue>();
    private List<EPPFeeCredit> credits = new ArrayList<EPPFeeCredit>();
    private BigDecimal balance;
    private BigDecimal creditLimit;

    protected abstract String getLocalName();

    protected abstract void validateAttributes() throws EPPEncodeException;

    public EPPFeeTransformResult() {
    }

    public EPPFeeTransformResult(String aCurrency, EPPFeeValue aFee) {
        this.setCurrency(aCurrency);
        this.addFee(aFee);
    }

    public EPPFeeTransformResult(String aCurrency, List<EPPFeeValue> aFees) {
        this.setCurrency(aCurrency);
        this.setFees(aFees);
    }

    public EPPFeeTransformResult(String aCurrency, EPPFeeCredit aCredit) {
        this.setCurrency(aCurrency);
        this.addCredit(aCredit);
    }

    public EPPFeeTransformResult(String aCurrency, List<EPPFeeValue> aFees, BigDecimal aBalance, BigDecimal aCreditLimit) {
        this.setCurrency(aCurrency);
        this.setFees(aFees);
        this.setBalance(aBalance);
        this.setCreditLimit(aCreditLimit);
    }

    public EPPFeeTransformResult(String aCurrency, BigDecimal aBalance, BigDecimal aCreditLimit, List<EPPFeeCredit> aCredits) {
        this.setCurrency(aCurrency);
        this.setCredits(aCredits);
        this.setBalance(aBalance);
        this.setCreditLimit(aCreditLimit);
    }

    public boolean hasCurrency() {
        return this.currency != null;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String aCurrency) {
        this.currency = aCurrency;
    }

    public boolean hasPeriod() {
        return this.period != null;
    }

    public EPPFeePeriod getPeriod() {
        return this.period;
    }

    public void setPeriod(EPPFeePeriod aPeriod) {
        this.period = aPeriod;
    }

    public boolean hasFees() {
        return !this.fees.isEmpty();
    }

    public List<EPPFeeValue> getFees() {
        return this.fees;
    }

    public void addFee(EPPFeeValue aFee) {
        if (aFee == null) {
            return;
        }
        this.fees.add(aFee);
    }

    public void setFees(List<EPPFeeValue> aFees) {
        this.fees = aFees == null ? new ArrayList<EPPFeeValue>() : aFees;
    }

    public boolean hasCredits() {
        return !this.credits.isEmpty();
    }

    public List<EPPFeeCredit> getCredits() {
        return this.credits;
    }

    public void addCredit(EPPFeeCredit aCredit) {
        if (aCredit == null) {
            return;
        }
        this.credits.add(aCredit);
    }

    public void setCredits(List<EPPFeeCredit> aCredits) {
        this.credits = aCredits == null ? new ArrayList<EPPFeeCredit>() : aCredits;
    }

    public boolean hasBalance() {
        return this.balance != null;
    }

    public BigDecimal getBalance() {
        return this.balance;
    }

    public void setBalance(BigDecimal aBalance) {
        this.balance = aBalance;
    }

    public boolean hasCreditLimit() {
        return this.creditLimit != null;
    }

    public BigDecimal getCreditLimit() {
        return this.creditLimit;
    }

    public void setCreditLimit(BigDecimal aCreditLimit) {
        this.creditLimit = aCreditLimit;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPFeeTransformResult.encode(Document)");
        }
        this.validateAttributes();
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:fee-0.9", this.ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.currency, "urn:ietf:params:xml:ns:fee-0.9", "fee:currency");
        EPPUtil.encodeComp(aDocument, root, this.period);
        EPPUtil.encodeCompList(aDocument, root, this.fees);
        EPPUtil.encodeCompList(aDocument, root, this.credits);
        EPPUtil.encodeBigDecimal(aDocument, root, this.balance, "urn:ietf:params:xml:ns:fee-0.9", "fee:balance", null);
        EPPUtil.encodeBigDecimal(aDocument, root, this.creditLimit, "urn:ietf:params:xml:ns:fee-0.9", "fee:creditLimit", null);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.currency = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:fee-0.9", ELM_CURRENCY);
        if (this.currency != null && this.currency.isEmpty()) {
            this.currency = null;
        }
        this.period = (EPPFeePeriod)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:fee-0.9", "fee:period", EPPFeePeriod.class);
        this.fees = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:fee-0.9", "fee", EPPFeeValue.class);
        this.credits = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:fee-0.9", "credit", EPPFeeCredit.class);
        this.balance = EPPUtil.decodeBigDecimal(aElement, "urn:ietf:params:xml:ns:fee-0.9", ELM_BALANCE);
        this.creditLimit = EPPUtil.decodeBigDecimal(aElement, "urn:ietf:params:xml:ns:fee-0.9", ELM_CREDIT_LIMIT);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPFeeTransformResult clone = (EPPFeeTransformResult)super.clone();
        clone.currency = this.currency;
        clone.period = this.period == null ? null : (EPPFeePeriod)this.period.clone();
        clone.fees = new ArrayList<EPPFeeValue>();
        for (EPPFeeValue fee : this.fees) {
            clone.fees.add((EPPFeeValue)fee.clone());
        }
        clone.credits = new ArrayList<EPPFeeCredit>();
        for (EPPFeeCredit credit : this.credits) {
            clone.credits.add((EPPFeeCredit)credit.clone());
        }
        clone.balance = this.balance != null ? new BigDecimal(this.balance.toString()) : null;
        clone.creditLimit = this.creditLimit != null ? new BigDecimal(this.creditLimit.toString()) : null;
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPFeeTransformResult)) {
            cat.error((Object)("EPPFeeTransformResult.equals(): " + aObject.getClass().getName() + " not EPPFeeTransformResult instance"));
            return false;
        }
        EPPFeeTransformResult other = (EPPFeeTransformResult)aObject;
        if (!EqualityUtil.equals(this.currency, other.currency)) {
            cat.error((Object)"EPPFeeTransformResult.equals(): currency not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.period, other.period)) {
            cat.error((Object)"EPPFeeInfo.equals(): period not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.fees, other.fees)) {
            cat.error((Object)"EPPFeeTransformResult.equals(): fees not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.credits, other.credits)) {
            cat.error((Object)"EPPFeeTransformResult.equals(): credits not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.balance, other.balance)) {
            cat.error((Object)"EPPFeeTransformResult.equals(): balance not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.creditLimit, other.creditLimit)) {
            cat.error((Object)"EPPFeeTransformResult.equals(): creditLimit not equal");
            return false;
        }
        return true;
    }
}

