/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.defReg;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPDefRegPeriod
implements EPPCodecComponent {
    public static final String PERIOD_UNIT_MONTH = "m";
    public static final String PERIOD_UNIT_YEAR = "y";
    static final int UNSPEC_PERIOD = -1;
    static final String ELM_NAME = "defReg:period";
    private static final String ELM_PERIOD = "defReg:period";
    private static final String ELM_PERIOD_UNIT = "unit";
    private static final int MAX_PERIOD = 99;
    private static final int MIN_PERIOD = 1;
    private int period = 0;
    private String pUnit = "y";

    public EPPDefRegPeriod() {
        this.period = -1;
    }

    public EPPDefRegPeriod(int aPeriod) {
        this.period = aPeriod;
        this.pUnit = PERIOD_UNIT_YEAR;
    }

    public EPPDefRegPeriod(String aPUnit, int aPeriod) {
        this.pUnit = aPUnit;
        if (!this.pUnit.equals(PERIOD_UNIT_YEAR) && !this.pUnit.equals(PERIOD_UNIT_MONTH)) {
            this.pUnit = PERIOD_UNIT_YEAR;
        }
        this.period = aPeriod;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPDefRegPeriod clone = null;
        clone = (EPPDefRegPeriod)super.clone();
        return clone;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        String tempVal = null;
        tempVal = aElement.getFirstChild().getNodeValue();
        this.pUnit = aElement.getAttribute(ELM_PERIOD_UNIT);
        this.period = tempVal == null ? -1 : Integer.parseInt(tempVal);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root = aDocument.createElementNS("http://www.nic.name/epp/defReg-1.0", "defReg:period");
        if (this.pUnit == null) {
            throw new EPPEncodeException("EPPDefRegPeriod: Period Unit should not be null");
        }
        if (!this.pUnit.equals(PERIOD_UNIT_YEAR) && !this.pUnit.equals(PERIOD_UNIT_MONTH)) {
            throw new EPPEncodeException("EPPDefRegPeriod: Period Unit has an invalid value");
        }
        root.setAttribute(ELM_PERIOD_UNIT, this.pUnit);
        Text currVal = aDocument.createTextNode(this.period + "");
        root.appendChild(currVal);
        return root;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPDefRegPeriod)) {
            return false;
        }
        EPPDefRegPeriod theComp = (EPPDefRegPeriod)aObject;
        if (this.period != theComp.period) {
            return false;
        }
        return this.pUnit != null ? this.pUnit.equals(theComp.pUnit) : theComp.pUnit == null;
    }

    public int getPeriod() {
        return this.period;
    }

    public String getPUnit() {
        return this.pUnit;
    }

    public boolean isPeriodUnspec() {
        return this.period == -1;
    }

    public void setPeriod(int newPeriod) throws EPPCodecException {
        if (this.period != -1 && this.period < 1 && this.period > 99) {
            throw new EPPCodecException("period of " + this.period + " is out of range, must be between " + 1 + " and " + 99);
        }
        this.period = newPeriod;
    }

    public void setPUnit(String newPUnit) {
        this.pUnit = newPUnit;
        if (!this.pUnit.equals(PERIOD_UNIT_YEAR) && !this.pUnit.equals(PERIOD_UNIT_MONTH)) {
            this.pUnit = PERIOD_UNIT_YEAR;
        }
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "http://www.nic.name/epp/defReg-1.0";
    }
}

