/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.changepoll;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class EPPChangeOperation
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPChangeOperation.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String OPERATION_CREATE = "create";
    public static final String OPERATION_DELETE = "delete";
    public static final String OPERATION_RENEW = "renew";
    public static final String OPERATION_TRANSFER = "transfer";
    public static final String OPERATION_UPDATE = "update";
    public static final String OPERATION_RESTORE = "restore";
    public static final String OPERATION_AUTO_RENEW = "autoRenew";
    public static final String OPERATION_AUTO_DELETE = "autoDelete";
    public static final String OPERATION_AUTO_PURGE = "autoPurge";
    public static final String OPERATION_CUSTOM = "custom";
    public static final String ELM_LOCALNAME = "operation";
    public static final String ELM_NAME = "changePoll:operation";
    private static final String ATTR_OP = "op";
    private String value;
    private String op;

    public EPPChangeOperation() {
    }

    public EPPChangeOperation(String aValue) {
        this.value = aValue;
    }

    public EPPChangeOperation(String aValue, String aOp) {
        this.value = aValue;
        this.op = aOp;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String aValue) {
        this.value = aValue;
    }

    public boolean hasOp() {
        return this.op != null;
    }

    public String getOp() {
        return this.op;
    }

    public void setOp(String aOp) {
        this.op = aOp;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPChangeOperation clone = null;
        clone = (EPPChangeOperation)super.clone();
        return clone;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        String theOp = aElement.getAttribute(ATTR_OP);
        this.op = theOp != null && !theOp.isEmpty() ? theOp : null;
        Node textNode = aElement.getFirstChild();
        if (textNode != null) {
            this.value = textNode.getNodeValue();
        }
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPChangeOperation.encode(Document)");
        }
        if (this.value == null) {
            throw new EPPEncodeException("value is null on in EPPChangeOperation.encode(Document)");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:changePoll-1.0", ELM_NAME);
        if (this.op != null) {
            root.setAttribute(ATTR_OP, this.op);
        }
        Text phaseText = aDocument.createTextNode(this.value);
        root.appendChild(phaseText);
        return root;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPChangeOperation)) {
            return false;
        }
        EPPChangeOperation other = (EPPChangeOperation)aObject;
        if (!EqualityUtil.equals(this.op, other.op)) {
            cat.error((Object)"EPPChangeOperation.equals(): op not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.value, other.value)) {
            cat.error((Object)"EPPChangeOperation.equals(): value not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:changePoll-1.0";
    }
}

